/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.debugger;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.util.ApplicationKt;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.framework.impl.RdTask;
import com.jetbrains.rd.ide.model.StackFrameModelBase;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdserver.debugger.StackFrameUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001e\u0010 \u001a\u00020\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\f2\u0006\u0010#\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/rdserver/debugger/ClientFrameContainer;", "Lcom/intellij/xdebugger/frame/XExecutionStack$XStackFrameContainer;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "process", "Lcom/intellij/xdebugger/XDebugProcess;", "stack", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "task", "Lcom/jetbrains/rd/framework/impl/RdTask;", "", "Lcom/jetbrains/rd/ide/model/StackFrameModelBase;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/client/ClientProjectSession;Lcom/intellij/xdebugger/XDebugProcess;Lcom/intellij/xdebugger/frame/XExecutionStack;Lcom/jetbrains/rd/framework/impl/RdTask;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getSession", "()Lcom/intellij/openapi/client/ClientProjectSession;", "getProcess", "()Lcom/intellij/xdebugger/XDebugProcess;", "getTask", "()Lcom/jetbrains/rd/framework/impl/RdTask;", "stackFrameModels", "", "isObsolete", "", "errorOccurred", "", "errorMessage", "", "addStackFrames", "stackFrames", "Lcom/intellij/xdebugger/frame/XStackFrame;", "last", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nClientFrameContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientFrameContainer.kt\ncom/jetbrains/rdserver/debugger/ClientFrameContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n1586#2:50\n1661#2,3:51\n*S KotlinDebug\n*F\n+ 1 ClientFrameContainer.kt\ncom/jetbrains/rdserver/debugger/ClientFrameContainer\n*L\n39#1:50\n39#1:51,3\n*E\n"})
public final class ClientFrameContainer
implements XExecutionStack.XStackFrameContainer {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private final XDebugProcess process;
    @NotNull
    private final XExecutionStack stack;
    @NotNull
    private final RdTask<List<StackFrameModelBase>> task;
    @NotNull
    private final List<StackFrameModelBase> stackFrameModels;

    public ClientFrameContainer(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull XDebugProcess process2, @NotNull XExecutionStack stack, @NotNull RdTask<List<StackFrameModelBase>> task2) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        this.lifetime = lifetime;
        this.session = session;
        this.process = process2;
        this.stack = stack;
        this.task = task2;
        this.stackFrameModels = new ArrayList();
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final ClientProjectSession getSession() {
        return this.session;
    }

    @NotNull
    public final XDebugProcess getProcess() {
        return this.process;
    }

    @NotNull
    public final RdTask<List<StackFrameModelBase>> getTask() {
        return this.task;
    }

    public boolean isObsolete() {
        return RLifetimeKt.isNotAlive((Lifetime)this.lifetime);
    }

    public void errorOccurred(@NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        ApplicationKt.getApplication().invokeLater(() -> ClientFrameContainer.errorOccurred$lambda$0(this, errorMessage));
    }

    public void addStackFrames(@NotNull List<? extends XStackFrame> stackFrames, boolean last) {
        Intrinsics.checkNotNullParameter(stackFrames, (String)"stackFrames");
        ApplicationKt.getApplication().invokeLater(() -> ClientFrameContainer.addStackFrames$lambda$0(this, stackFrames, last));
    }

    private static final Unit errorOccurred$lambda$0$0(ClientFrameContainer this$0, String $errorMessage) {
        this$0.task.getResult().set((Object)new RdTaskResult.Fault((Throwable)new Exception($errorMessage)));
        return Unit.INSTANCE;
    }

    private static final void errorOccurred$lambda$0(ClientFrameContainer this$0, String $errorMessage) {
        ClientId.Companion.withClientId(this$0.session.getClientId(), () -> ClientFrameContainer.errorOccurred$lambda$0$0(this$0, $errorMessage));
    }

    private static final Unit addStackFrames$lambda$0$1(ClientFrameContainer this$0) {
        this$0.task.set(this$0.stackFrameModels);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final void addStackFrames$lambda$0(ClientFrameContainer this$0, List $stackFrames, boolean $last) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = $stackFrames;
        List<StackFrameModelBase> list = this$0.stackFrameModels;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void xFrame;
            XStackFrame xStackFrame = (XStackFrame)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StackFrameUtilsKt.createStackFrameModel((XStackFrame)xFrame, this$0.session, this$0.process, this$0.stack));
        }
        list.addAll((List)destination$iv$iv);
        if ($last) {
            ClientId.Companion.withClientId(this$0.session.getClientId(), () -> ClientFrameContainer.addStackFrames$lambda$0$1(this$0));
        }
    }
}

