/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.editors;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.document.PatchEngineDocumentSynchronizer;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.requests.ChangeScope;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchEngine;
import com.jetbrains.rdserver.daemon.BackendEditorMarkupModelContributor;
import com.jetbrains.rdserver.daemon.BackendMarkupHost;
import com.jetbrains.rdserver.daemon.BackendMarkupModelContributor;
import com.jetbrains.rdserver.document.BackendDocumentHostKt;
import com.jetbrains.rdserver.editors.BackendEditorHost;
import com.jetbrains.rdserver.editors.BackendEditorSynchronizer;
import com.jetbrains.rdserver.requests.BackendPatchEngineKt;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0082@\u00a2\u0006\u0002\u0010\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getEditorStates", "Lcom/jetbrains/rd/ide/model/RdPatch;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "ids", "", "Lcom/jetbrains/rd/ide/model/TextControlId;", "(Lcom/intellij/openapi/client/ClientAppSession;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendEditorHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendEditorHost.kt\ncom/jetbrains/rdserver/editors/BackendEditorHostKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,493:1\n1#2:494\n62#3,7:495\n69#3,2:507\n71#3,6:510\n77#3,2:517\n57#4:502\n35#4,2:503\n82#4,2:505\n84#4:509\n23#4:516\n13#4:521\n1915#5,2:519\n*S KotlinDebug\n*F\n+ 1 BackendEditorHost.kt\ncom/jetbrains/rdserver/editors/BackendEditorHostKt\n*L\n422#1:495,7\n422#1:507,2\n422#1:510,6\n422#1:517,2\n422#1:502\n422#1:503,2\n422#1:505,2\n422#1:509\n422#1:516\n60#1:521\n446#1:519,2\n*E\n"})
public final class BackendEditorHostKt {
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Object getEditorStates(ClientAppSession session, List<? extends TextControlId> ids, Continuation<? super RdPatch> $completion) {
        boolean bl;
        boolean bl2 = bl = !((Collection)ids).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-BackendEditorHostKt$getEditorStates$332 = false;
            String $i$a$-assert-BackendEditorHostKt$getEditorStates$332 = "Editors to recover is empty";
            throw new AssertionError((Object)$i$a$-assert-BackendEditorHostKt$getEditorStates$332);
        }
        LOG.warn(">> Start recovering editor states after exception. session: " + session.getClientId() + ", editors: " + ids);
        try {
            RdPatch rdPatch;
            void $this$recordChanges$iv;
            BackendEditorHost editorHost = BackendEditorHost.Companion.getInstance(session);
            PatchEngine patchEngine = BackendPatchEngineKt.getEngine(session);
            String description$iv = "getEditorStates";
            boolean $i$f$recordChanges = false;
            $this$recordChanges$iv.softAssertThereIsNoActivePatch("recordChanges must no be called under another patch, because it leads to recording and  sending the same patch multiple times");
            boolean alreadyOpened$iv = $this$recordChanges$iv.getHasActivePatch();
            try {
                RdPatch rdPatch2;
                AutoCloseable autoCloseable = (AutoCloseable)PatchEngine.openAccumulatingSession$default((PatchEngine)$this$recordChanges$iv, (boolean)false, (String)description$iv, null, null, null, (int)28, null);
                Throwable throwable = null;
                try {
                    Object object;
                    void $this$runAndLogException$iv$iv;
                    RdPatchEngine.ChangeAccumulatingSessionToken it$iv = (RdPatchEngine.ChangeAccumulatingSessionToken)autoCloseable;
                    boolean bl322 = false;
                    boolean $i$f$fileLogger232 = false;
                    boolean $i$f$currentClassLogger = false;
                    Class<?> clazz$iv$iv$iv = MethodHandles.lookup().lookupClass();
                    Logger logger = Logger.getInstance(clazz$iv$iv$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    Logger $i$f$fileLogger232 = logger;
                    boolean $i$f$runAndLogException = false;
                    void var15_25 = $this$runAndLogException$iv$iv;
                    try {
                        void $this$runAndLogException_u24lambda_u240$iv$iv = var15_25;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        ChangeScope $this$getEditorStates_u24lambda_u241 = it$iv.getSession().getChangeScope();
                        boolean bl6 = false;
                        for (TextControlId textControlId : ids) {
                            BackendEditorSynchronizer editorSynchronizer;
                            DocumentSynchronizer synchronizer;
                            RdDocumentId documentId = textControlId.getDocumentId();
                            if (BackendDocumentHostKt.toSynchronizerOrNull(documentId, session) == null) continue;
                            PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer = synchronizer instanceof PatchEngineDocumentSynchronizer ? (PatchEngineDocumentSynchronizer)synchronizer : null;
                            if (patchEngineDocumentSynchronizer != null) {
                                patchEngineDocumentSynchronizer.sendInitialTextChange();
                            }
                            if (editorHost.tryGetSynchronizer(textControlId) == null) continue;
                            editorSynchronizer.sendInitialCaretState();
                        }
                        object = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable throwable2) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                    }
                    LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv$iv);
                    rdPatch2 = it$iv.getSession().buildPatchAndClear();
                }
                catch (Throwable bl322) {
                    try {
                        throwable = bl322;
                        throw bl322;
                    }
                    catch (Throwable bl322) {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, throwable);
                        throw bl322;
                    }
                }
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                rdPatch = rdPatch2;
            }
            finally {
                if (!alreadyOpened$iv && $this$recordChanges$iv.getHasActivePatch()) {
                    void $this$thisLogger$iv$iv = $this$recordChanges$iv;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(PatchEngine.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("There are unclosed accumulating sessions after recordChanges. Close them forcibly");
                    while ($this$recordChanges$iv.getHasActivePatch()) {
                        $this$recordChanges$iv.closeCurrentSession("Wrong dispose ordering: " + description$iv);
                    }
                }
            }
            RdPatch patch = rdPatch;
            ApplicationKt.getApplication().invokeLater(() -> BackendEditorHostKt.getEditorStates$lambda$2(session, ids, editorHost));
            patchEngine = patch;
            return patchEngine;
        }
        finally {
            LOG.warn("<< End recovering editor states");
        }
    }

    private static final void getEditorStates$lambda$2(ClientAppSession $session, List $ids, BackendEditorHost $editorHost) {
        if ($session.isDisposed()) {
            return;
        }
        HashSet<Document> documents = new HashSet<Document>();
        HashSet<Editor> editors = new HashSet<Editor>();
        for (TextControlId id : $ids) {
            BackendEditorSynchronizer editorSynchronizer;
            DocumentSynchronizer synchronizer;
            RdDocumentId documentId = id.getDocumentId();
            if (BackendDocumentHostKt.toSynchronizerOrNull(documentId, $session) == null) continue;
            documents.add(synchronizer.getDocument());
            if ($editorHost.tryGetSynchronizer(id) == null) continue;
            editors.add(editorSynchronizer.getEditor());
        }
        BackendMarkupHost markupHost = BackendMarkupHost.Companion.getInstance($session);
        Iterator iterator = documents.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Document document = (Document)e;
            Iterable $this$forEach$iv = $session.getProjectSessions();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ClientProjectSession projectSession = (ClientProjectSession)element$iv;
                boolean bl = false;
                BackendMarkupModelContributor backendMarkupModelContributor = markupHost.getContributor(document, projectSession.getProject());
                if (backendMarkupModelContributor == null) continue;
                backendMarkupModelContributor.recoverMarkupState();
            }
        }
        Iterator iterator3 = editors.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
        iterator2 = iterator3;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Editor editor = (Editor)e;
            BackendEditorMarkupModelContributor backendEditorMarkupModelContributor = markupHost.getContributor(editor);
            if (backendEditorMarkupModelContributor == null) continue;
            backendEditorMarkupModelContributor.recoverMarkupState();
        }
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ Object access$getEditorStates(ClientAppSession session, List ids, Continuation $completion) {
        return BackendEditorHostKt.getEditorStates(session, ids, (Continuation<? super RdPatch>)$completion);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BackendEditorHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

