/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.execution.configurations;

import com.intellij.build.BuildView;
import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.console.DuplexConsoleView;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.actions.ConsolePropertiesProvider;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.externalSystem.execution.ExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.execution.DefaultExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemProcessHandler;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemExecuteTaskTask;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.ui.content.Content;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.codeWithMe.model.BackendRunContentModel;
import com.jetbrains.codeWithMe.model.BackendRunContentModel_GeneratedKt;
import com.jetbrains.codeWithMe.model.ConsoleInfo;
import com.jetbrains.codeWithMe.model.ExecutionConsoleKind;
import com.jetbrains.codeWithMe.model.ExternalSystemInfo;
import com.jetbrains.codeWithMe.model.RunDebugToolwindowId;
import com.jetbrains.codeWithMe.model.RunnerContentModel;
import com.jetbrains.codeWithMe.model.RunnerDefaultTab;
import com.jetbrains.codeWithMe.model.RunnerLayoutUiModel;
import com.jetbrains.codeWithMe.model.SessionPortForwarding;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.rd.actions.ActionsKt;
import com.jetbrains.rd.ide.model.ActionRegistrationModel;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.platform.codeWithMe.permissions.RunAccessLevel;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import com.jetbrains.rdserver.SplitBackendBundle;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import com.jetbrains.rdserver.editors.BackendEditorHost;
import com.jetbrains.rdserver.execution.ExternalSystemModelUtilsKt;
import com.jetbrains.rdserver.execution.configurations.BackendRunContentHostKt;
import com.jetbrains.rdserver.permissions.ClientPermissionManager;
import com.jetbrains.rdserver.portForwarding.utils.PortForwardingSessionUtils;
import com.jetbrains.rdserver.ui.converters.ConverterRegistryKt;
import com.jetbrains.rdserver.ui.converters.EditorComponentImplConverterKt;
import com.jetbrains.rdserver.ui.converters.TrackOptions;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0002&'B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\bJ$\u0010\u0013\u001a\u00020\u00142\b\u0010\u0012\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\bH\u0002J\b\u0010\u001a\u001a\u00020\u0014H\u0002J\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dJ\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u000e\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RZ\u0010\u0006\u001aN\u0012\u000e\u0012\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\n\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b \f*%\u0012\u000e\u0012\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\n\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\r\u00a2\u0006\u0002\b\t0\u0007\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000RZ\u0010\u000e\u001aN\u0012\u000e\u0012\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\n\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000f0\u000f \f*%\u0012\u000e\u0012\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\n\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000f0\u000f0\r\u00a2\u0006\u0002\b\t0\u0007\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/jetbrains/rdserver/execution/configurations/BackendRunContentHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "<init>", "(Lcom/intellij/openapi/client/ClientProjectSession;)V", "consoleToIdMap", "", "Lcom/intellij/execution/ui/ConsoleView;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "kotlin.jvm.PlatformType", "", "consoleToPortForwardingMap", "Lcom/jetbrains/codeWithMe/model/SessionPortForwarding;", "nextConsoleId", "getConsoleId", "console", "storePortForwardingSession", "", "Lcom/intellij/execution/ui/ExecutionConsole;", "model", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "tryAssociatePortForwardingWithBeModel", "bindWithModel", "processStarted", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "syncStartedProcess", "executor", "Lcom/intellij/execution/Executor;", "descriptor", "Lcom/intellij/execution/ui/RunContentDescriptor;", "processTerminated", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "MyExecutionListener", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendRunContentHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendRunContentHost.kt\ncom/jetbrains/rdserver/execution/configurations/BackendRunContentHost\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,384:1\n1#2:385\n60#3,5:386\n60#3,5:391\n60#3,5:396\n13#3:402\n13#4:401\n*S KotlinDebug\n*F\n+ 1 BackendRunContentHost.kt\ncom/jetbrains/rdserver/execution/configurations/BackendRunContentHost\n*L\n102#1:386,5\n107#1:391,5\n112#1:396,5\n204#1:402\n204#1:401\n*E\n"})
public final class BackendRunContentHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private final Map<ConsoleView, Integer> consoleToIdMap;
    @NotNull
    private final Map<ConsoleView, SessionPortForwarding> consoleToPortForwardingMap;
    private int nextConsoleId;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Key<LifetimeDefinition> processHandlerLifetimeKey;
    @NotNull
    private static final String runToolWindowPortLabel = "runToolWindowPort";

    public BackendRunContentHost(@NotNull ClientProjectSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        Map map2 = ContainerUtil.createWeakKeySoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createWeakKeySoftValueMap(...)");
        this.consoleToIdMap = map2;
        Map map3 = ContainerUtil.createWeakKeySoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"createWeakKeySoftValueMap(...)");
        this.consoleToPortForwardingMap = map3;
        RdCoroutinesUtilKt.launchOnUi$default((Lifetime)this.getServiceLifetime(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ BackendRunContentHost this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.this$0.bindWithModel();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final int getConsoleId(@NotNull ConsoleView console) {
        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
        ThreadingAssertions.assertEventDispatchThread();
        Integer n = this.consoleToIdMap.get(console);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            return it;
        }
        int n2 = this.nextConsoleId;
        this.nextConsoleId = n2 + 1;
        int id = n2;
        this.consoleToIdMap.put(console, id);
        this.tryAssociatePortForwardingWithBeModel(console);
        return id;
    }

    private final void storePortForwardingSession(ExecutionConsole console, SessionPortForwarding model2, Lifetime lifetime) {
        ConsoleView consoleView;
        ThreadingAssertions.assertEventDispatchThread();
        if (model2 == null) {
            Logger $this$debug_u24default$iv = logger;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Port Forwarding model is not set for " + console + ". Skipping storing port forwarding session.", t$iv);
            }
            return;
        }
        if (console == null) {
            Logger $this$debug_u24default$iv = logger;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Console object is not defined. Skipping storing port forwarding session.", t$iv);
            }
            return;
        }
        if (!(console instanceof ConsoleView)) {
            Logger $this$debug_u24default$iv = logger;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Console object is not an instance of ConsoleView. Skipping storing port forwarding session.", t$iv);
            }
            return;
        }
        ExecutionConsole executionConsole = console;
        ConsoleViewImpl consoleViewImpl = executionConsole instanceof ConsoleViewImpl ? (ConsoleViewImpl)executionConsole : null;
        if (consoleViewImpl != null) {
            consoleView = (ConsoleView)consoleViewImpl;
        } else {
            consoleView = (ConsoleView)DataManager.getInstance().getDataContext((Component)((ConsoleView)console).getComponent()).getData(LangDataKeys.CONSOLE_VIEW);
            if (consoleView == null) {
                consoleView = (ConsoleView)console;
            }
        }
        ConsoleView consoleView2 = consoleView;
        CollectionExKt.addUnique(this.consoleToPortForwardingMap, (Lifetime)lifetime, (Object)consoleView2, (Object)model2);
        this.tryAssociatePortForwardingWithBeModel(consoleView2);
    }

    private final void tryAssociatePortForwardingWithBeModel(ConsoleView console) {
        Integer n = this.consoleToIdMap.get(console);
        if (n == null) {
            return;
        }
        int consoleId2 = n;
        SessionPortForwarding sessionPortForwarding = this.consoleToPortForwardingMap.get(console);
        if (sessionPortForwarding == null) {
            return;
        }
        SessionPortForwarding pfSession = sessionPortForwarding;
        IMutableViewableMap sessionsMap = BackendRunContentModel_GeneratedKt.getBackendRunContentModel((Solution)RemoteSessionKt.getProtocolModel(this.session)).getPortForwardingSessions();
        CollectionExKt.put((Map)((Map)sessionsMap), (Lifetime)this.getServiceLifetime(), (Object)consoleId2, (Object)pfSession);
        pfSession.getSessionEnded().advise(this.getServiceLifetime(), arg_0 -> BackendRunContentHost.tryAssociatePortForwardingWithBeModel$lambda$0(sessionsMap, consoleId2, arg_0));
        this.consoleToPortForwardingMap.remove(console);
    }

    private final void bindWithModel() {
        BackendRunContentModel runContentModel = BackendRunContentModel_GeneratedKt.getBackendRunContentModel((Solution)RemoteSessionKt.getProtocolModel(this.session));
        if (this.session.isController()) {
            runContentModel.getShowRunDebugToolwindow().advise(this.getServiceLifetime(), arg_0 -> BackendRunContentHost.bindWithModel$lambda$0(this, arg_0));
        }
    }

    public final void processStarted(@NotNull ExecutionEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        RunProfile runProfile = env.getRunProfile();
        Object object = runProfile instanceof RunConfiguration ? (RunConfiguration)runProfile : null;
        if (object == null) {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = env.getRunnerAndConfigurationSettings();
            object = runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getConfiguration() : null;
        }
        RunConfiguration configuration = object;
        RunContentDescriptor runContentDescriptor = env.getContentToReuse();
        if (runContentDescriptor == null) {
            BackendRunContentHost $this$processStarted_u24lambda_u240 = this;
            boolean bl = false;
            RunConfiguration runConfiguration = configuration;
            logger.warn("env.contentToReuse is null - can't synchronize a process with executionId = " + env.getExecutionId() + " and configuration name = \"" + (runConfiguration != null ? runConfiguration.getName() : null) + "\"");
            return;
        }
        RunContentDescriptor descriptor = runContentDescriptor;
        Executor executor = env.getExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"getExecutor(...)");
        this.syncStartedProcess(executor, descriptor);
    }

    private final void syncStartedProcess(Executor executor, RunContentDescriptor descriptor) {
        ExecutionConsole executionConsole;
        ExecutionConsole executionConsole2;
        if (ClientPermissionManager.Companion.getInstance(this.session).getRunAccess() == RunAccessLevel.Disabled) {
            return;
        }
        if (Intrinsics.areEqual((Object)executor.getToolWindowId(), (Object)"Debug")) {
            return;
        }
        LifetimeDefinition startedProcessLifetime = this.getServiceLifetime().createNested();
        ProcessHandler processHandler2 = descriptor.getProcessHandler();
        if (processHandler2 == null) {
            return;
        }
        ProcessHandler handler = processHandler2;
        handler.putUserData(processHandlerLifetimeKey, (Object)startedProcessLifetime);
        ExecutionConsole it = descriptor.getExecutionConsole();
        boolean bl = false;
        if (it instanceof BuildView) {
            executionConsole2 = ((BuildView)it).getConsoleView();
            if (executionConsole2 == null) {
                executionConsole2 = it;
            }
        } else {
            executionConsole2 = it;
        }
        ConsoleViewImpl consoleViewImpl = (executionConsole = executionConsole2) instanceof ConsoleViewImpl ? (ConsoleViewImpl)executionConsole : null;
        if (consoleViewImpl != null) {
            UiUtils.putUserData((JComponent)((JComponent)consoleViewImpl), processHandlerLifetimeKey, (Object)startedProcessLifetime);
        }
        SessionPortForwarding portForwardingSession = PortForwardingSessionUtils.INSTANCE.setupPortForwardingSession((Lifetime)startedProcessLifetime, this.session.getAppSession(), handler, runToolWindowPortLabel);
        this.storePortForwardingSession(executionConsole, portForwardingSession, (Lifetime)startedProcessLifetime);
    }

    public final void processTerminated(@NotNull ProcessHandler handler) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            if (ClientPermissionManager.Companion.getInstance(this.session).getRunAccess() == RunAccessLevel.Disabled) {
                return;
            }
            LifetimeDefinition lifetimeDefinition = (LifetimeDefinition)handler.getUserData(processHandlerLifetimeKey);
            if (lifetimeDefinition == null) break block1;
            LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
        }
    }

    private static final Unit tryAssociatePortForwardingWithBeModel$lambda$0(IMutableViewableMap $sessionsMap, int $consoleId, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $sessionsMap.remove((Object)$consoleId);
        return Unit.INSTANCE;
    }

    private static final Unit bindWithModel$lambda$0$0(BackendRunContentHost this$0, String $toolWindowId) {
        block0: {
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this$0.session.getProject()).getToolWindow($toolWindowId);
            if (toolWindow == null) break block0;
            toolWindow.show();
        }
        return Unit.INSTANCE;
    }

    private static final Unit bindWithModel$lambda$0(BackendRunContentHost this$0, RunDebugToolwindowId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (WhenMappings.$EnumSwitchMapping$0[id.ordinal()] != 1) {
            throw new IllegalStateException(("Unknown RunDebugToolwindowId: " + id).toString());
        }
        String toolWindowId = "Debug";
        ClientId.Companion.withExplicitClientId(ClientId.Companion.getLocalId(), () -> BackendRunContentHost.bindWithModel$lambda$0$0(this$0, toolWindowId));
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BackendRunContentHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        BackendRunContentHost.logger = logger;
        processHandlerLifetimeKey = new Key("cwm.processHandler.lifetime");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\r\u001a\u00020\u000eJ\"\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017J*\u0010\u0018\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ$\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J%\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b+J(\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/2\u0006\u0010)\u001a\u0002002\u0006\u0010'\u001a\u00020(2\u0006\u00101\u001a\u00020 J \u00102\u001a\u0004\u0018\u0001032\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/jetbrains/rdserver/execution/configurations/BackendRunContentHost$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "processHandlerLifetimeKey", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "runToolWindowPortLabel", "", "getInstance", "Lcom/jetbrains/rdserver/execution/configurations/BackendRunContentHost;", "project", "Lcom/intellij/openapi/project/Project;", "tryGetInstance", "getAllInstances", "", "getExternalSystemInfo", "Lcom/jetbrains/codeWithMe/model/ExternalSystemInfo;", "configuration", "Lcom/intellij/execution/configurations/RunProfile;", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "tryGetTestFramework", "executor", "Lcom/intellij/execution/Executor;", "console", "Lcom/intellij/execution/ui/ExecutionConsole;", "getConsoleProperties", "Lcom/intellij/execution/testframework/TestConsoleProperties;", "tryGuessIsTest", "", "task", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTask;", "getExecutionConsoleKind", "Lcom/jetbrains/codeWithMe/model/ExecutionConsoleKind;", "createConsoleInfo", "Lcom/jetbrains/codeWithMe/model/ConsoleInfo;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "createConsoleInfo$intellij_platform_backend_split", "getRunnerLayoutUiModel", "Lcom/jetbrains/codeWithMe/model/RunnerLayoutUiModel;", "descriptor", "Lcom/intellij/execution/ui/RunContentDescriptor;", "Lcom/intellij/openapi/client/ClientAppSession;", "isDebug", "bindConsoleEditor", "Lcom/jetbrains/rd/ide/model/TextControlId;", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendRunContentHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendRunContentHost.kt\ncom/jetbrains/rdserver/execution/configurations/BackendRunContentHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,384:1\n30#2,2:385\n50#2:387\n65#2:388\n1#3:389\n1586#4:390\n1661#4,3:391\n*S KotlinDebug\n*F\n+ 1 BackendRunContentHost.kt\ncom/jetbrains/rdserver/execution/configurations/BackendRunContentHost$Companion\n*L\n208#1:385,2\n210#1:387\n212#1:388\n346#1:390\n346#1:391,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BackendRunContentHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<BackendRunContentHost> serviceClass$iv = BackendRunContentHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (BackendRunContentHost)((Object)object);
        }

        @Nullable
        public final BackendRunContentHost tryGetInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$serviceOrNull$iv = (ComponentManager)project;
            boolean $i$f$serviceOrNull = false;
            return (BackendRunContentHost)((Object)$this$serviceOrNull$iv.getService(BackendRunContentHost.class));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<BackendRunContentHost> getAllInstances(@NotNull Project project) {
            void $this$services$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean includeLocal$iv = false;
            boolean $i$f$services = false;
            List list = $this$services$iv.getServices(BackendRunContentHost.class, ClientKind.REMOTE);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getServices(...)");
            return list;
        }

        @Nullable
        public final ExternalSystemInfo getExternalSystemInfo(@NotNull Project project, @Nullable RunProfile configuration, @NotNull ProcessHandler handler) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            if (!(handler instanceof ExternalSystemProcessHandler)) {
                return null;
            }
            ExternalSystemTask externalSystemTask = ((ExternalSystemProcessHandler)handler).getTask();
            if (externalSystemTask == null) {
                return null;
            }
            ExternalSystemTask task2 = externalSystemTask;
            ExternalSystemTaskId externalSystemTaskId = task2.getId();
            Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskId, (String)"getId(...)");
            ExternalSystemTaskId taskId = externalSystemTaskId;
            Object object = configuration;
            IconModel configurationIcon = object != null && (object = object.getIcon()) != null ? UtilKt.toModel((Icon)object) : null;
            List taskNames = null;
            Object executionName = null;
            if (task2 instanceof ExternalSystemExecuteTaskTask) {
                List list = ((ExternalSystemExecuteTaskTask)task2).getTasksToExecute();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTasksToExecute(...)");
                taskNames = list;
                String string = ((ExternalSystemExecuteTaskTask)task2).getIdeProject().getName();
                List list2 = ((ExternalSystemExecuteTaskTask)task2).getTasksToExecute();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTasksToExecute(...)");
                executionName = string + " [" + CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, null, (int)63, null) + "]";
            } else {
                taskNames = CollectionsKt.emptyList();
                executionName = SplitBackendBundle.INSTANCE.message("run.content.tabName.unknown", new Object[0]);
            }
            return new ExternalSystemInfo(ExternalSystemModelUtilsKt.toModel(taskId, project), (String)executionName, taskNames, configurationIcon);
        }

        @NotNull
        public final String tryGetTestFramework(@NotNull Project project, @Nullable RunProfile configuration, @NotNull Executor executor, @Nullable ExecutionConsole console) {
            ExternalSystemExecuteTaskTask task2;
            String testFramework;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            TestConsoleProperties testConsoleProperties = this.getConsoleProperties(configuration, executor, console);
            String string = testFramework = testConsoleProperties != null ? BackendRunContentHostKt.getTestFrameworkName(testConsoleProperties) : null;
            if (configuration instanceof ExternalSystemRunConfiguration && !this.tryGuessIsTest((ExternalSystemTask)(task2 = new ExternalSystemExecuteTaskTask(project, ((ExternalSystemRunConfiguration)configuration).getSettings(), null, (ExternalSystemRunConfiguration)configuration)))) {
                return "";
            }
            String string2 = testFramework;
            if (string2 == null) {
                string2 = "";
            }
            return string2;
        }

        @Nullable
        public final TestConsoleProperties getConsoleProperties(@Nullable RunProfile configuration, @NotNull Executor executor, @Nullable ExecutionConsole console) {
            BaseTestsOutputConsoleView testsOutputConsoleView;
            SMTRunnerConsoleProperties createdProperties;
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            ConsolePropertiesProvider consolePropertiesProvider = configuration instanceof ConsolePropertiesProvider ? (ConsolePropertiesProvider)configuration : null;
            TestConsoleProperties testConsoleProperties = consolePropertiesProvider != null ? consolePropertiesProvider.createTestConsoleProperties(executor) : null;
            SMTRunnerConsoleProperties sMTRunnerConsoleProperties = createdProperties = testConsoleProperties instanceof SMTRunnerConsoleProperties ? (SMTRunnerConsoleProperties)testConsoleProperties : null;
            if (createdProperties != null) {
                return (TestConsoleProperties)createdProperties;
            }
            BaseTestsOutputConsoleView baseTestsOutputConsoleView = testsOutputConsoleView = console instanceof BaseTestsOutputConsoleView ? (BaseTestsOutputConsoleView)console : null;
            return baseTestsOutputConsoleView != null ? baseTestsOutputConsoleView.getProperties() : null;
        }

        public final boolean tryGuessIsTest(@NotNull ExternalSystemTask task2) {
            Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
            ExternalSystemExecutionConsoleManager externalSystemExecutionConsoleManager = ExternalSystemUtil.getConsoleManagerFor((ExternalSystemTask)task2);
            Intrinsics.checkNotNullExpressionValue((Object)externalSystemExecutionConsoleManager, (String)"getConsoleManagerFor(...)");
            ExternalSystemExecutionConsoleManager consoleManager = externalSystemExecutionConsoleManager;
            return !(consoleManager instanceof DefaultExternalSystemExecutionConsoleManager);
        }

        private final ExecutionConsoleKind getExecutionConsoleKind(ExecutionConsole console) {
            ExecutionConsole executionConsole = console;
            return executionConsole instanceof TerminalExecutionConsole ? ExecutionConsoleKind.TerminalExecutionConsole : (executionConsole instanceof LanguageConsoleImpl || executionConsole instanceof DuplexConsoleView ? ExecutionConsoleKind.BeControlledConsole : ExecutionConsoleKind.ConsoleViewImpl);
        }

        @NotNull
        public final ConsoleInfo createConsoleInfo$intellij_platform_backend_split(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull ExecutionConsole console) {
            BeControl beControl;
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)console, (String)"console");
            ExecutionConsoleKind consoleKind = this.getExecutionConsoleKind(console);
            TextControlId textControlId = consoleKind != ExecutionConsoleKind.BeControlledConsole ? this.bindConsoleEditor(lifetime, session, console) : null;
            ExecutionConsole executionConsole = console;
            if (executionConsole instanceof LanguageConsoleImpl || executionConsole instanceof DuplexConsoleView) {
                Container container = ((ComponentContainer)console).getComponent().getParent().getParent();
                JComponent jComponent = container instanceof JComponent ? (JComponent)container : null;
                if (jComponent != null) {
                    JComponent it = jComponent;
                    boolean bl = false;
                    UIUtil.markAsShowing((JComponent)it, (boolean)true);
                }
                Container container2 = container;
                beControl = container2 != null ? ConverterRegistryKt.toBeModel(container2, new TrackOptions(session.getAppSession(), false, null, null, false, null, null, null, true, null, null, 1790, null), lifetime) : null;
            } else if (executionConsole instanceof BuildView) {
                ConsoleViewImpl consoleImpl;
                ExecutionConsole executionConsole2 = ((BuildView)console).getConsoleView();
                ConsoleViewImpl consoleViewImpl = consoleImpl = executionConsole2 instanceof ConsoleViewImpl ? (ConsoleViewImpl)executionConsole2 : null;
                if (consoleImpl != null) {
                    UIUtil.markAsShowing((JComponent)((JComponent)consoleImpl), (boolean)true);
                    beControl = ConverterRegistryKt.toBeModel((Component)consoleImpl, new TrackOptions(session.getAppSession(), false, null, null, false, null, null, null, true, null, null, 1790, null), lifetime);
                } else {
                    beControl = null;
                }
            } else if (executionConsole instanceof ConsoleViewImpl) {
                UIUtil.markAsShowing((JComponent)((JComponent)console), (boolean)true);
                beControl = ConverterRegistryKt.toBeModel((Component)console, new TrackOptions(session.getAppSession(), false, null, null, false, null, null, null, true, null, null, 1790, null), lifetime);
            } else {
                beControl = null;
            }
            BeControl beModel = beControl;
            return new ConsoleInfo(consoleKind, textControlId, beModel);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final RunnerLayoutUiModel getRunnerLayoutUiModel(@NotNull RunContentDescriptor descriptor, @NotNull ClientAppSession session, @NotNull Lifetime lifetime, boolean isDebug) {
            void $this$mapTo$iv$iv;
            Object content2;
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Content[] contentArray = descriptor.getRunnerLayoutUi();
            RunnerLayoutUiImpl runnerLayoutUiImpl = contentArray instanceof RunnerLayoutUiImpl ? (RunnerLayoutUiImpl)contentArray : null;
            if (runnerLayoutUiImpl == null) {
                return null;
            }
            RunnerLayoutUiImpl runnerLayoutUi = runnerLayoutUiImpl;
            ArrayList<RunnerContentModel> contentModels = new ArrayList<RunnerContentModel>();
            Content[] contentArray2 = runnerLayoutUi.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray2, (String)"getContents(...)");
            for (Object content2 : contentArray2) {
                String contentId;
                if ((String)content2.getUserData(RunnerLayoutUiImpl.CONTENT_TYPE) == null || isDebug && !Intrinsics.areEqual((Object)contentId, (Object)"ConsoleContent") && !StringsKt.startsWith$default((String)contentId, (String)"ConsoleViewWrapper", (boolean)false, (int)2, null)) continue;
                BeControl component = null;
                ActionRegistrationModel actions = null;
                if (!Intrinsics.areEqual((Object)contentId, (Object)"ConsoleContent")) {
                    try {
                        JComponent jComponent = content2.getComponent();
                        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
                        component = ConverterRegistryKt.toBeModel(jComponent, new TrackOptions(session, false, null, null, false, null, null, null, false, null, null, 2046, null), lifetime);
                        ActionGroup contentActions = content2.getActions();
                        if (contentActions != null) {
                            actions = ActionsKt.toBeModel((AnAction)((AnAction)contentActions), (Lifetime)lifetime, (ClientAppSession)session);
                        }
                    }
                    catch (Exception e) {
                        logger.info("Failed to create component for content '" + content2.getDisplayName() + "'", (Throwable)e);
                    }
                }
                String string = content2.getDisplayName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
                Icon icon2 = content2.getIcon();
                Object object = icon2 != null ? UtilKt.toModel((Icon)icon2) : null;
                boolean bl = content2.isCloseable();
                int n = runnerLayoutUi.getLayout().getDefaultTabIndex(contentId);
                Object object2 = runnerLayoutUi.getLayout().getDefaultPlaceInGrid(contentId);
                if (object2 == null || (object2 = object2.name()) == null) {
                    object2 = "center";
                }
                contentModels.add(new RunnerContentModel(component, actions, string, object, bl, contentId, n, (String)object2, runnerLayoutUi.getLayout().getDefaultIsMinimized(contentId)));
            }
            if (contentModels.size() <= 1) {
                return null;
            }
            Iterable $this$map$iv = contentModels;
            boolean $i$f$map22 = false;
            content2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RunnerContentModel runnerContentModel = (RunnerContentModel)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getTabIndex());
            }
            Set tabIndexes = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
            tabIndexes.remove(-1);
            ArrayList<RunnerDefaultTab> defaultTabs = new ArrayList<RunnerDefaultTab>();
            Iterator $i$f$map22 = tabIndexes.iterator();
            while ($i$f$map22.hasNext()) {
                int i = ((Number)$i$f$map22.next()).intValue();
                String label = runnerLayoutUi.getLayout().getDefaultDisplayName(i);
                Icon icon3 = runnerLayoutUi.getLayout().getDefaultIcon(i);
                if (label == null && icon3 == null) continue;
                Icon icon4 = icon3;
                defaultTabs.add(new RunnerDefaultTab(i, label, (IconModel)(icon4 != null ? UtilKt.toModel((Icon)icon4) : null)));
            }
            RunnerContentUi runnerContentUi = runnerLayoutUi.getContentUI();
            Intrinsics.checkNotNullExpressionValue((Object)runnerContentUi, (String)"getContentUI(...)");
            RunnerContentUi contentUi = runnerContentUi;
            return new RunnerLayoutUiModel((List)defaultTabs, (List)contentModels, contentUi.isMoveToGridActionEnabled());
        }

        @Nullable
        public final TextControlId bindConsoleEditor(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull ExecutionConsole console) {
            ConsoleViewImpl consoleViewImpl;
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)console, (String)"console");
            if (console instanceof ConsoleViewImpl) {
                consoleViewImpl = (ConsoleViewImpl)console;
            } else if (console instanceof BuildView && ((BuildView)console).getConsoleView() instanceof ConsoleViewImpl) {
                ExecutionConsole executionConsole = ((BuildView)console).getConsoleView();
                Intrinsics.checkNotNull((Object)executionConsole, (String)"null cannot be cast to non-null type com.intellij.execution.impl.ConsoleViewImpl");
                consoleViewImpl = (ConsoleViewImpl)executionConsole;
            } else if (console instanceof BuildView && ((BuildView)console).getConsoleView() instanceof SMTRunnerConsoleView && session.isController()) {
                ExecutionConsole executionConsole = ((BuildView)console).getConsoleView();
                Intrinsics.checkNotNull((Object)executionConsole, (String)"null cannot be cast to non-null type com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView");
                ConsoleView consoleView = ((SMTRunnerConsoleView)executionConsole).getConsole();
                Intrinsics.checkNotNull((Object)consoleView, (String)"null cannot be cast to non-null type com.intellij.execution.impl.ConsoleViewImpl");
                consoleViewImpl = (ConsoleViewImpl)consoleView;
            } else {
                return null;
            }
            ConsoleViewImpl consoleView = consoleViewImpl;
            consoleView.getComponent();
            Editor editor = consoleView.getEditor();
            ClientAppSession clientAppSession = session.getAppSession();
            Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
            EditorEx editorCopy = EditorComponentImplConverterKt.copyEditor(clientAppSession, (EditorEx)editor, lifetime);
            return BackendEditorHost.bindEditor$default(BackendEditorHost.Companion.getInstance(session.getAppSession()), (Editor)editorCopy, false, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rdserver/execution/configurations/BackendRunContentHost$MyExecutionListener;", "Lcom/intellij/execution/ExecutionListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "processStarted", "", "executorId", "", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "processTerminated", "exitCode", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendRunContentHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendRunContentHost.kt\ncom/jetbrains/rdserver/execution/configurations/BackendRunContentHost$MyExecutionListener\n+ 2 util.kt\ncom/intellij/util/containers/UtilKt\n*L\n1#1,384:1\n194#2,9:385\n194#2,9:394\n*S KotlinDebug\n*F\n+ 1 BackendRunContentHost.kt\ncom/jetbrains/rdserver/execution/configurations/BackendRunContentHost$MyExecutionListener\n*L\n156#1:385,9\n162#1:394,9\n*E\n"})
    public static final class MyExecutionListener
    implements ExecutionListener {
        @NotNull
        private final Project project;

        public MyExecutionListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        /*
         * WARNING - void declaration
         */
        public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
            void $this$forEachLoggingErrors$iv;
            Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Collection collection = Companion.getAllInstances(this.project);
            Logger logger$iv = logger;
            boolean $i$f$forEachLoggingErrors = false;
            for (Object it$iv : $this$forEachLoggingErrors$iv) {
                try {
                    BackendRunContentHost it = (BackendRunContentHost)((Object)it$iv);
                    boolean bl = false;
                    it.processStarted(env);
                }
                catch (Throwable e$iv) {
                    logger$iv.error(e$iv);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler, int exitCode) {
            void $this$forEachLoggingErrors$iv;
            Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Collection collection = Companion.getAllInstances(this.project);
            Logger logger$iv = logger;
            boolean $i$f$forEachLoggingErrors = false;
            for (Object it$iv : $this$forEachLoggingErrors$iv) {
                try {
                    BackendRunContentHost it = (BackendRunContentHost)((Object)it$iv);
                    boolean bl = false;
                    it.processTerminated(handler);
                }
                catch (Throwable e$iv) {
                    logger$iv.error(e$iv);
                }
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RunDebugToolwindowId.values().length];
            try {
                nArray[RunDebugToolwindowId.Debug.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

