/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.lux.adapter;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.platform.impl.toolkit.IdeGraphicsEnvironment;
import com.intellij.platform.impl.toolkit.IdeKeyboardFocusManagerPeer;
import com.intellij.platform.impl.toolkit.IdeMouseInfoPeer;
import com.intellij.util.ui.ImageUtil;
import com.jetbrains.codeWithMe.model.RemoteGraphicsConfigurationModel;
import com.jetbrains.rd.framework.IRdEndpoint;
import com.jetbrains.rd.ide.model.LxAbstractComponent;
import com.jetbrains.rd.ide.model.LxEvent;
import com.jetbrains.rd.ide.model.LxKeyEvent;
import com.jetbrains.rd.ide.model.LxLocalComponent;
import com.jetbrains.rd.ide.model.LxLocalComponentId;
import com.jetbrains.rd.ide.model.LxMouseEvent;
import com.jetbrains.rd.ide.model.LxMouseEventBase;
import com.jetbrains.rd.ide.model.LxMouseEventType;
import com.jetbrains.rd.ide.model.LxPanel;
import com.jetbrains.rd.ide.model.LxPoint;
import com.jetbrains.rd.ide.model.LxRect;
import com.jetbrains.rd.ide.model.LxSize;
import com.jetbrains.rd.ui.bindable.views.listControl.utils.SwingTreeUtilsKt;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdserver.lux.adapter.LuxComponentAdapter;
import com.jetbrains.rdserver.lux.adapter.LuxGraphicsAdapter;
import com.jetbrains.rdserver.lux.awt.graphics.LuxGraphicsConfiguration;
import com.jetbrains.rdserver.lux.local.LuxBackendLocalBindingManager;
import com.jetbrains.rdserver.lux.services.LuxHostConnection;
import com.jetbrains.rdserver.lux.services.LuxHostService;
import com.jetbrains.rdserver.lux.util.UnattendedHostEventHelper;
import com.jetbrains.rdserver.lux.util.UtilKt;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.font.TextHitInfo;
import java.awt.geom.Point2D;
import java.awt.im.InputMethodRequests;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.swing.JPasswordField;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AWTAccessor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008e\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000 \u008f\u00012\u00020\u0001:\u0002\u008f\u0001B!\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010;\u001a\u00020\u00192\u0006\u0010<\u001a\u00020\u0015H\u0002J\u0016\u0010=\u001a\u00020\u00152\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0014J\u0010\u0010?\u001a\u00020\u00192\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010B\u001a\u00020\u00192\u0006\u0010C\u001a\u00020DH\u0002J\u0018\u0010E\u001a\u00020\u00192\u0006\u0010F\u001a\u00020*2\u0006\u0010G\u001a\u00020*H\u0014J\u0006\u0010H\u001a\u00020\u0019J\u0012\u0010I\u001a\u00020\u00192\b\u0010J\u001a\u0004\u0018\u00010KH\u0016J\u000e\u0010L\u001a\u00020\u00192\u0006\u0010M\u001a\u00020NJ\u0006\u0010O\u001a\u00020\u0019J\u0006\u0010P\u001a\u00020QJ\u000e\u0010R\u001a\n T*\u0004\u0018\u00010S0SJ\u0006\u0010U\u001a\u00020VJ\u0006\u0010W\u001a\u00020XJ\u0010\u0010Y\u001a\u0004\u0018\u00010Z2\u0006\u0010[\u001a\u00020\\J\u000e\u0010]\u001a\u00020\u00192\u0006\u0010^\u001a\u00020_J\u000e\u0010`\u001a\u00020\u00192\u0006\u0010^\u001a\u00020_J\u000e\u0010a\u001a\u00020\u00192\u0006\u0010b\u001a\u00020\\J\u0006\u0010c\u001a\u00020\u0019J\b\u0010d\u001a\u00020\u0019H\u0002J\b\u0010e\u001a\u00020\u0019H\u0002J\u0010\u0010f\u001a\u00020\u00152\b\u0010g\u001a\u0004\u0018\u00010SJ\u000e\u0010h\u001a\u00020\u00192\u0006\u0010<\u001a\u00020\u0015J.\u0010i\u001a\u00020\u00152\u0006\u0010j\u001a\u00020k2\u0006\u0010l\u001a\u00020\u00152\u0006\u0010m\u001a\u00020\u00152\u0006\u0010n\u001a\u00020o2\u0006\u0010p\u001a\u00020qJ\u0006\u0010r\u001a\u00020\u0019J\u0006\u0010s\u001a\u00020\u0019J\u0006\u0010t\u001a\u00020\u0019J\u0010\u0010u\u001a\u00020\u00192\b\u0010v\u001a\u0004\u0018\u00010wJ\u0010\u0010x\u001a\u00020\u00192\b\u0010v\u001a\u0004\u0018\u00010wJ\u000e\u0010y\u001a\n T*\u0004\u0018\u00010D0DJ\u000e\u0010z\u001a\n T*\u0004\u0018\u00010K0KJ\u0006\u0010{\u001a\u00020\u0019J\u0006\u0010|\u001a\u00020\u0019J\u0014\u0010}\u001a\u00020\u00192\f\u0010~\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J\u0019\u0010\u007f\u001a\u00030\u0080\u00012\u0006\u0010 \u001a\u00020\u00032\b\u0010\u0081\u0001\u001a\u00030\u0082\u0001J\t\u0010\u0083\u0001\u001a\u00020\u0019H\u0002J+\u0010\u0084\u0001\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00032\u0010\u0010\u0085\u0001\u001a\u000b\u0012\u0006\u0012\u0004\u0018\u00010k0\u0086\u0001H\u0002J\u0007\u0010\u0087\u0001\u001a\u00020*J\u000f\u0010\u0088\u0001\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0003\u0010\u0089\u0001J\u0010\u0010\u008a\u0001\u001a\t0\u008b\u0001\u00a2\u0006\u0003\b\u008c\u0001H\u0002J\f\u0010\u008d\u0001\u001a\u00030\u008e\u0001H\u0096\u0080\u0004R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0016\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0017j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0018`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001d8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0010\u0010$\u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010/\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0013\u00101\u001a\u0004\u0018\u0001028F\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0010\u00105\u001a\u0004\u0018\u000106X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00107\u001a\u00020\u0015X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00100\"\u0004\b9\u0010:\u00a8\u0006\u0090\u0001"}, d2={"Lcom/jetbrains/rdserver/lux/adapter/LuxComponentAdapter;", "", "outerLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "model", "Lcom/jetbrains/rd/ide/model/LxPanel;", "window", "Ljava/awt/Window;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/ide/model/LxPanel;Ljava/awt/Window;)V", "getModel", "()Lcom/jetbrains/rd/ide/model/LxPanel;", "getWindow", "()Ljava/awt/Window;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "paranoidLogger", "getParanoidLogger", "isInLayout", "", "afterLayoutActions", "Ljava/util/ArrayList;", "Lkotlin/Function0;", "", "Lkotlin/collections/ArrayList;", "reenterLock", "contentPane", "Ljava/awt/Container;", "getContentPane", "()Ljava/awt/Container;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "bindingLifetime", "disposable", "Lcom/intellij/openapi/Disposable;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "luxId", "", "getLuxId", "()I", "graphicsAdapter", "Lcom/jetbrains/rdserver/lux/adapter/LuxGraphicsAdapter;", "isBound", "()Z", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "lastMousePressedEvent", "Ljava/awt/event/MouseEvent;", "modalBlocked", "getModalBlocked$intellij_platform_backend_split", "setModalBlocked$intellij_platform_backend_split", "(Z)V", "receiveVisibilityChange", "v", "runWithKeyEventCatching", "action", "receiveEvent", "event", "Lcom/jetbrains/rd/ide/model/LxEvent;", "receivePosition", "p", "Ljava/awt/Point;", "receiveSize", "width", "height", "sendPositionToClientIfNeeded", "sendSizeToClientIfNeeded", "initialSize", "Ljava/awt/Dimension;", "bindTo", "connection", "Lcom/jetbrains/rdserver/lux/services/LuxHostConnection;", "unbind", "getImageProxy", "Ljava/awt/Image;", "getGraphicsConfiguration", "Ljava/awt/GraphicsConfiguration;", "kotlin.jvm.PlatformType", "getColorModel", "Ljava/awt/image/ColorModel;", "getGraphics", "Ljava/awt/Graphics2D;", "getFontMetrics", "Ljava/awt/FontMetrics;", "font", "Ljava/awt/Font;", "setForeground", "c", "Ljava/awt/Color;", "setBackground", "setFont", "f", "dispose", "restoreFocus", "guessInitialGraphicsConfiguration", "setGraphicsConfiguration", "gc", "setVisible", "requestFocus", "lightweightChild", "Ljava/awt/Component;", "temporary", "focusedWindowChangeAllowed", "time", "", "cause", "Ljava/awt/event/FocusEvent$Cause;", "flush", "repaint", "updateCursor", "paint", "g", "Ljava/awt/Graphics;", "print", "getLocationOnScreen", "getMinimumSize", "notifyLayoutStarts", "notifyLayoutFinish", "runOrQueueAfterLayout", "runnable", "addLocalComponent", "Lcom/jetbrains/rd/ide/model/LxLocalComponentId;", "localComponentModel", "Lcom/jetbrains/rd/ide/model/LxLocalComponent;", "trackInputLocation", "trackFocusedComponentInWindow", "listener", "Ljava/util/function/Consumer;", "drawOperationsCollected", "clearDrawOperations", "()Lkotlin/Unit;", "createMockBuffer", "Ljava/awt/image/BufferedImage;", "Lorg/jetbrains/annotations/NotNull;", "toString", "", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nLuxComponentAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuxComponentAdapter.kt\ncom/jetbrains/rdserver/lux/adapter/LuxComponentAdapter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 util.kt\ncom/jetbrains/rd/platform/codeWithMe/lux/UtilKt\n+ 4 Reenterability.kt\ncom/jetbrains/rd/platform/util/ReenterabilityKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,488:1\n23#2:489\n67#2,4:491\n74#2,4:495\n67#2,4:533\n74#2,4:537\n67#2,4:549\n74#2,4:553\n67#2,4:559\n74#2,4:563\n67#2,4:567\n67#2,4:571\n67#2,4:577\n74#2,4:581\n67#2,4:585\n74#2,4:589\n67#2,4:604\n67#2,4:608\n67#2,4:612\n67#2,4:616\n67#2,4:620\n67#2,4:624\n201#3:490\n19#4,9:499\n19#4,9:508\n19#4,9:517\n19#4,7:526\n26#4,2:541\n19#4,4:543\n25#4:548\n26#4,2:557\n19#4,9:593\n1#5:547\n1276#6,2:575\n1915#7,2:602\n*S KotlinDebug\n*F\n+ 1 LuxComponentAdapter.kt\ncom/jetbrains/rdserver/lux/adapter/LuxComponentAdapter\n*L\n66#1:489\n92#1:491,4\n93#1:495,4\n203#1:533,4\n204#1:537,4\n219#1:549,4\n220#1:553,4\n226#1:559,4\n227#1:563,4\n254#1:567,4\n282#1:571,4\n316#1:577,4\n317#1:581,4\n337#1:585,4\n338#1:589,4\n403#1:604,4\n100#1:608,4\n105#1:612,4\n110#1:616,4\n115#1:620,4\n124#1:624,4\n67#1:490\n132#1:499,9\n175#1:508,9\n190#1:517,9\n200#1:526,7\n200#1:541,2\n210#1:543,4\n210#1:548\n210#1:557,2\n340#1:593,9\n293#1:575,2\n385#1:602,2\n*E\n"})
public abstract class LuxComponentAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LxPanel model;
    @NotNull
    private final Window window;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Logger paranoidLogger;
    private boolean isInLayout;
    @NotNull
    private final ArrayList<Function0<Unit>> afterLayoutActions;
    private boolean reenterLock;
    @NotNull
    private final LifetimeDefinition lifetime;
    @Nullable
    private LifetimeDefinition bindingLifetime;
    @NotNull
    private final Disposable disposable;
    private final int luxId;
    @Nullable
    private LuxGraphicsAdapter graphicsAdapter;
    @Nullable
    private MouseEvent lastMousePressedEvent;
    private boolean modalBlocked;
    private static int localComponentCounter;

    protected LuxComponentAdapter(@NotNull Lifetime outerLifetime, @NotNull LxPanel model2, @NotNull Window window) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)outerLifetime, (String)"outerLifetime");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        this.model = model2;
        this.window = window;
        LuxComponentAdapter $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger2 = Logger.getInstance(LuxComponentAdapter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        this.logger = logger2;
        LuxComponentAdapter $this$paranoidLogger$iv = this;
        boolean $i$f$paranoidLogger = false;
        Logger logger3 = Logger.getInstance((String)("paranoid#" + LuxComponentAdapter.class.getName()));
        Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
        this.paranoidLogger = logger3;
        this.afterLayoutActions = new ArrayList();
        this.lifetime = outerLifetime.createNested();
        this.disposable = LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)((Lifetime)this.lifetime), null, (int)1, null);
        this.luxId = LuxHostService.Companion.getInstance().register((Lifetime)this.lifetime, this);
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("INIT " + this);
        }
        Logger $this$traceThrowable$iv = this.paranoidLogger;
        boolean $i$f$traceThrowable = false;
        if ($this$traceThrowable$iv.isTraceEnabled()) {
            logger = $this$traceThrowable$iv;
            boolean bl = false;
            logger.trace(new Throwable());
        }
        this.lifetime.onTermination(() -> LuxComponentAdapter._init_$lambda$2(this));
        this.model.getPosition().advise((Lifetime)this.lifetime, arg_0 -> LuxComponentAdapter._init_$lambda$3(this, arg_0));
        this.model.getSize().advise((Lifetime)this.lifetime, arg_0 -> LuxComponentAdapter._init_$lambda$4(this, arg_0));
        this.model.getEvents().advise((Lifetime)this.lifetime, arg_0 -> LuxComponentAdapter._init_$lambda$5(this, arg_0));
        this.model.getVisible().advise((Lifetime)this.lifetime, arg_0 -> LuxComponentAdapter._init_$lambda$6(this, arg_0));
        this.model.getGraphicsConfiguration().advise((Lifetime)this.lifetime, arg_0 -> LuxComponentAdapter._init_$lambda$7(this, arg_0));
        IRdEndpoint.DefaultImpls.set$default((IRdEndpoint)((IRdEndpoint)this.model.getRequestRepaint()), null, null, arg_0 -> LuxComponentAdapter._init_$lambda$8(this, arg_0), (int)3, null);
        this.trackInputLocation();
    }

    @NotNull
    protected final LxPanel getModel() {
        return this.model;
    }

    @NotNull
    public final Window getWindow() {
        return this.window;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    protected final Logger getParanoidLogger() {
        return this.paranoidLogger;
    }

    @NotNull
    protected final Container getContentPane() {
        Window window = this.window;
        Object object = window instanceof RootPaneContainer ? (RootPaneContainer)((Object)window) : null;
        if (object == null || (object = object.getContentPane()) == null) {
            object = this.window;
        }
        return object;
    }

    @NotNull
    public final LifetimeDefinition getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final Disposable getDisposable() {
        return this.disposable;
    }

    public final int getLuxId() {
        return this.luxId;
    }

    public final boolean isBound() {
        return this.graphicsAdapter != null;
    }

    @Nullable
    public final ClientAppSession getSession() {
        Object object = this.graphicsAdapter;
        return object != null && (object = ((LuxGraphicsAdapter)object).getConnection()) != null ? ((LuxHostConnection)((Object)object)).getSession() : null;
    }

    public final boolean getModalBlocked$intellij_platform_backend_split() {
        return this.modalBlocked;
    }

    public final void setModalBlocked$intellij_platform_backend_split(boolean bl) {
        this.modalBlocked = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void receiveVisibilityChange(boolean v) {
        KMutableProperty0 flag$iv = (KMutableProperty0)new MutablePropertyReference0Impl(this){

            public Object get() {
                return LuxComponentAdapter.access$getReenterLock$p((LuxComponentAdapter)this.receiver);
            }

            public void set(Object value) {
                LuxComponentAdapter.access$setReenterLock$p((LuxComponentAdapter)this.receiver, (Boolean)value);
            }
        };
        boolean $i$f$noReenter = false;
        if (!((Boolean)flag$iv.get()).booleanValue()) {
            flag$iv.set((Object)true);
            try {
                boolean bl = false;
                this.window.setVisible(v);
                if (v && this.isBound()) {
                    this.window.repaint();
                }
            }
            finally {
                flag$iv.set((Object)false);
            }
        }
    }

    protected boolean runWithKeyEventCatching(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        action.invoke();
        return false;
    }

    private final void receiveEvent(LxEvent event) {
        ClientAppSession clientAppSession = this.getSession();
        if (clientAppSession == null) {
            LuxComponentAdapter $this$receiveEvent_u24lambda_u240 = this;
            boolean bl = false;
            $this$receiveEvent_u24lambda_u240.logger.error("Receive event " + event + " for unbound component " + $this$receiveEvent_u24lambda_u240);
            return;
        }
        ClientAppSession session = clientAppSession;
        if (this.modalBlocked && event instanceof LxMouseEventBase) {
            this.logger.info("Ignoring " + event + " for modally blocked window " + this.window);
            return;
        }
        boolean sendBack = this.runWithKeyEventCatching((Function0<Unit>)((Function0)() -> LuxComponentAdapter.receiveEvent$lambda$1(event, session, this)));
        if (sendBack && event instanceof LxKeyEvent) {
            this.model.getUnprocessedKeyEvents().fire((Object)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void receivePosition(Point p2) {
        if (this.window.isShowing() && Intrinsics.areEqual((Object)this.window.getLocation(), (Object)p2)) {
            return;
        }
        KMutableProperty0 flag$iv = (KMutableProperty0)new MutablePropertyReference0Impl(this){

            public Object get() {
                return LuxComponentAdapter.access$getReenterLock$p((LuxComponentAdapter)this.receiver);
            }

            public void set(Object value) {
                LuxComponentAdapter.access$setReenterLock$p((LuxComponentAdapter)this.receiver, (Boolean)value);
            }
        };
        boolean $i$f$noReenter = false;
        if (!((Boolean)flag$iv.get()).booleanValue()) {
            flag$iv.set((Object)true);
            try {
                boolean bl = false;
                this.window.setLocation(p2);
                if (this.window.isShowing()) {
                    ComponentEvent moveEvent = new ComponentEvent(this.window, 100);
                    IdeEventQueue.Companion.getInstance().dispatchEvent((AWTEvent)moveEvent);
                    this.window.repaint();
                }
            }
            finally {
                flag$iv.set((Object)false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveSize(int width, int height) {
        Dimension contentSize = new Dimension(width, height);
        if (width <= 0 || height <= 0) {
            return;
        }
        if (Intrinsics.areEqual((Object)this.getContentPane().getSize(), (Object)contentSize)) {
            return;
        }
        KMutableProperty0 flag$iv = (KMutableProperty0)new MutablePropertyReference0Impl(this){

            public Object get() {
                return LuxComponentAdapter.access$getReenterLock$p((LuxComponentAdapter)this.receiver);
            }

            public void set(Object value) {
                LuxComponentAdapter.access$setReenterLock$p((LuxComponentAdapter)this.receiver, (Boolean)value);
            }
        };
        boolean $i$f$noReenter = false;
        if (!((Boolean)flag$iv.get()).booleanValue()) {
            flag$iv.set((Object)true);
            try {
                boolean bl = false;
                this.getContentPane().setPreferredSize(contentSize);
                this.window.setPreferredSize(contentSize);
                this.window.setSize(contentSize);
                this.window.validate();
                this.window.repaint();
            }
            finally {
                flag$iv.set((Object)false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendPositionToClientIfNeeded() {
        KMutableProperty0 flag$iv = (KMutableProperty0)new MutablePropertyReference0Impl(this){

            public Object get() {
                return LuxComponentAdapter.access$getReenterLock$p((LuxComponentAdapter)this.receiver);
            }

            public void set(Object value) {
                LuxComponentAdapter.access$setReenterLock$p((LuxComponentAdapter)this.receiver, (Boolean)value);
            }
        };
        boolean $i$f$noReenter = false;
        if (!((Boolean)flag$iv.get()).booleanValue()) {
            flag$iv.set((Object)true);
            try {
                Logger logger;
                boolean bl = false;
                if (!this.window.isShowing()) {
                    return;
                }
                Point point = this.window.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocation(...)");
                LxPoint paneLocation = com.jetbrains.rd.platform.codeWithMe.lux.UtilKt.toLx((Point2D)point);
                Logger $this$trace$iv = this.logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl2 = false;
                    logger.trace("Set position. Old value: " + this.model.getPosition().getValueOrNull() + ". New value: " + paneLocation + ". Node: " + this.model.getLocation());
                }
                Logger $this$traceThrowable$iv = this.paranoidLogger;
                boolean $i$f$traceThrowable = false;
                if ($this$traceThrowable$iv.isTraceEnabled()) {
                    logger = $this$traceThrowable$iv;
                    boolean bl3 = false;
                    logger.trace(new Throwable());
                }
                this.model.getPosition().set((Object)paneLocation);
            }
            finally {
                flag$iv.set((Object)false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSizeToClientIfNeeded(@Nullable Dimension initialSize) {
        KMutableProperty0 flag$iv = (KMutableProperty0)new MutablePropertyReference0Impl(this){

            public Object get() {
                return LuxComponentAdapter.access$getReenterLock$p((LuxComponentAdapter)this.receiver);
            }

            public void set(Object value) {
                LuxComponentAdapter.access$setReenterLock$p((LuxComponentAdapter)this.receiver, (Boolean)value);
            }
        };
        boolean $i$f$noReenter = false;
        if (!((Boolean)flag$iv.get()).booleanValue()) {
            flag$iv.set((Object)true);
            try {
                Logger logger;
                boolean resized;
                boolean bl;
                boolean bl2 = false;
                LxSize modelSize = (LxSize)this.model.getSize().getValueOrNull();
                Dimension dimension = initialSize;
                if (dimension == null) {
                    dimension = this.getContentPane().getSize();
                }
                Dimension size = dimension;
                LxSize lxSize = modelSize;
                if (lxSize != null) {
                    LxSize it = lxSize;
                    boolean bl3 = false;
                    boolean bl4 = it.getWidth() != size.width || it.getHeight() != size.height;
                    bl = !bl4;
                } else {
                    bl = false;
                }
                boolean bl5 = resized = !bl;
                if (!resized) {
                    return;
                }
                if (this.window.isShowing()) {
                    this.window.revalidate();
                }
                Logger $this$trace$iv = this.logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl6 = false;
                    Object object = this.model.getPreferredSize().getValueOrNull();
                    Intrinsics.checkNotNull((Object)size);
                    logger.trace("Set preferredSize. Old value: " + object + ". New value: " + com.jetbrains.rd.platform.codeWithMe.lux.UtilKt.toLx((Dimension)size) + ". Node: " + this.model.getLocation());
                }
                Logger $this$traceThrowable$iv = this.paranoidLogger;
                boolean $i$f$traceThrowable = false;
                if ($this$traceThrowable$iv.isTraceEnabled()) {
                    logger = $this$traceThrowable$iv;
                    boolean bl7 = false;
                    logger.trace(new Throwable());
                }
                IOptProperty iOptProperty = this.model.getPreferredSize();
                Intrinsics.checkNotNull((Object)size);
                iOptProperty.set((Object)com.jetbrains.rd.platform.codeWithMe.lux.UtilKt.toLx((Dimension)size));
            }
            finally {
                flag$iv.set((Object)false);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void bindTo(@NotNull LuxHostConnection connection) {
        void it;
        LifetimeDefinition lifetimeDefinition;
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)connection), (String)"connection");
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            object = $this$trace$iv;
            boolean bl = false;
            object.trace("Binding " + this + " to " + connection);
        }
        Logger $this$traceThrowable$iv = this.paranoidLogger;
        boolean $i$f$traceThrowable22 = false;
        if ($this$traceThrowable$iv.isTraceEnabled()) {
            object = $this$traceThrowable$iv;
            boolean bl = false;
            object.trace(new Throwable());
        }
        if (this.isBound()) {
            this.logger.warn("Peer is already bound");
            return;
        }
        if (this.window.isShowing()) {
            this.sendPositionToClientIfNeeded();
            this.sendSizeToClientIfNeeded(this.window.getSize());
        }
        LifetimeDefinition $i$f$traceThrowable22 = lifetimeDefinition = new LifetimeDefinition(RLifetimeKt.intersect((Lifetime)((Lifetime)this.lifetime), (Lifetime)connection.getLifetime()));
        object = this;
        boolean bl = false;
        it.bracketIfAlive(() -> LuxComponentAdapter.bindTo$lambda$2$0(this, connection, (LifetimeDefinition)it), () -> LuxComponentAdapter.bindTo$lambda$2$1(this));
        object.bindingLifetime = lifetimeDefinition;
        this.guessInitialGraphicsConfiguration();
        this.repaint();
    }

    public final void unbind() {
        block2: {
            Logger $this$trace$iv = this.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Unbinding " + this);
            }
            if (!this.isBound()) {
                this.logger.warn("Peer is not bound");
                return;
            }
            LifetimeDefinition lifetimeDefinition = this.bindingLifetime;
            if (lifetimeDefinition == null) break block2;
            LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
        }
    }

    @NotNull
    public final Image getImageProxy() {
        Object object = this.graphicsAdapter;
        if (object == null || (object = ((LuxGraphicsAdapter)object).getBackBuffer()) == null) {
            object = this.createMockBuffer();
        }
        return object;
    }

    public final GraphicsConfiguration getGraphicsConfiguration() {
        return this.window.getGraphicsConfiguration();
    }

    @NotNull
    public final ColorModel getColorModel() {
        ColorModel colorModel = this.window.getGraphicsConfiguration().getColorModel();
        Intrinsics.checkNotNullExpressionValue((Object)colorModel, (String)"getColorModel(...)");
        return colorModel;
    }

    @NotNull
    public final Graphics2D getGraphics() {
        Object object = this.graphicsAdapter;
        if (object == null || (object = ((LuxGraphicsAdapter)object).createGraphics()) == null) {
            Graphics2D graphics2D = this.createMockBuffer().createGraphics();
            object = graphics2D;
            Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"createGraphics(...)");
        }
        return object;
    }

    @Nullable
    public final FontMetrics getFontMetrics(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        LuxGraphicsAdapter luxGraphicsAdapter = this.graphicsAdapter;
        return luxGraphicsAdapter != null ? luxGraphicsAdapter.getFontMetrics(font) : null;
    }

    public final void setForeground(@NotNull Color c) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            LuxGraphicsAdapter luxGraphicsAdapter = this.graphicsAdapter;
            if (luxGraphicsAdapter == null) break block0;
            luxGraphicsAdapter.setColor(c);
        }
    }

    public final void setBackground(@NotNull Color c) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            LuxGraphicsAdapter luxGraphicsAdapter = this.graphicsAdapter;
            if (luxGraphicsAdapter == null) break block0;
            luxGraphicsAdapter.setBackground(c);
        }
    }

    public final void setFont(@NotNull Font f) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)f, (String)"f");
            LuxGraphicsAdapter luxGraphicsAdapter = this.graphicsAdapter;
            if (luxGraphicsAdapter == null) break block0;
            luxGraphicsAdapter.setFont(f);
        }
    }

    public final void dispose() {
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Disposing " + this);
        }
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.lifetime, (boolean)false, (int)1, null);
        this.restoreFocus();
    }

    private final void restoreFocus() {
        block9: {
            IdeFocusManager focusManager;
            block8: {
                boolean bl;
                IdeFocusManager ideFocusManager = IdeFocusManager.getGlobalInstance();
                Intrinsics.checkNotNullExpressionValue((Object)ideFocusManager, (String)"getGlobalInstance(...)");
                focusManager = ideFocusManager;
                if (this.window.isFocusOwner()) break block8;
                Component component = focusManager.getFocusOwner();
                if (component != null && (component = SwingTreeUtilsKt.pathToRoot$default((Component)component, null, (int)1, null)) != null) {
                    boolean bl2;
                    block7: {
                        Component $this$any$iv = component;
                        boolean $i$f$any = false;
                        Iterator iterator = $this$any$iv.iterator();
                        while (iterator.hasNext()) {
                            Object element$iv = iterator.next();
                            Component it = (Component)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it, (Object)this.window)) continue;
                            bl2 = true;
                            break block7;
                        }
                        bl2 = false;
                    }
                    bl = bl2;
                } else {
                    bl = false;
                }
                if (!bl) break block9;
            }
            focusManager.requestDefaultFocus(false);
        }
    }

    private final void guessInitialGraphicsConfiguration() {
        Rectangle boundsOnScreen = this.window.getBounds();
        boundsOnScreen.setLocation(this.getLocationOnScreen());
        IdeGraphicsEnvironment ideGraphicsEnvironment = IdeGraphicsEnvironment.Companion.getInstance();
        Intrinsics.checkNotNull((Object)boundsOnScreen);
        GraphicsConfiguration gc = ideGraphicsEnvironment.findGraphicsConfigurationFor(boundsOnScreen);
        this.setGraphicsConfiguration(gc);
    }

    public final boolean setGraphicsConfiguration(@Nullable GraphicsConfiguration gc) {
        Logger logger;
        LuxGraphicsAdapter luxGraphicsAdapter = this.graphicsAdapter;
        if (luxGraphicsAdapter == null) {
            return false;
        }
        LuxGraphicsAdapter graphicsAdapter = luxGraphicsAdapter;
        if (gc == null || !(gc instanceof LuxGraphicsConfiguration)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)gc, (Object)this.window.getGraphicsConfiguration())) {
            return false;
        }
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Setting graphics configuration for " + this + " to " + gc);
        }
        Logger $this$traceThrowable$iv = this.paranoidLogger;
        boolean $i$f$traceThrowable = false;
        if ($this$traceThrowable$iv.isTraceEnabled()) {
            logger = $this$traceThrowable$iv;
            boolean bl = false;
            logger.trace(new Throwable());
        }
        AWTAccessor.getComponentAccessor().setGraphicsConfiguration(this.window, gc);
        graphicsAdapter.setGraphicsConfiguration(gc);
        if (this.window.isVisible()) {
            this.window.repaint();
        }
        this.repaint();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setVisible(boolean v) {
        Logger logger;
        if (v && !this.isBound()) {
            LuxHostService.Companion.getInstance().bindIfPossible(this);
        }
        if (v == this.window.isVisible() && v == (Boolean)InterfacesKt.valueOrDefault((IOptProperty)this.model.getVisible(), (Object)false)) {
            return;
        }
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Set visibility. Old value: " + this.model.getVisible().getValueOrNull() + ". New value: " + v + ". Node: " + this.model.getLocation());
        }
        Logger $this$traceThrowable$iv = this.paranoidLogger;
        boolean $i$f$traceThrowable = false;
        if ($this$traceThrowable$iv.isTraceEnabled()) {
            logger = $this$traceThrowable$iv;
            boolean bl = false;
            logger.trace(new Throwable());
        }
        this.window.setVisible(v);
        KMutableProperty0 flag$iv = (KMutableProperty0)new MutablePropertyReference0Impl(this){

            public Object get() {
                return LuxComponentAdapter.access$getReenterLock$p((LuxComponentAdapter)this.receiver);
            }

            public void set(Object value) {
                LuxComponentAdapter.access$setReenterLock$p((LuxComponentAdapter)this.receiver, (Boolean)value);
            }
        };
        boolean $i$f$noReenter = false;
        if (!((Boolean)flag$iv.get()).booleanValue()) {
            flag$iv.set((Object)true);
            try {
                boolean bl = false;
                this.model.getVisible().set((Object)v);
            }
            finally {
                flag$iv.set((Object)false);
            }
        }
        if (v) {
            this.repaint();
        }
    }

    public final boolean requestFocus(@NotNull Component lightweightChild, boolean temporary, boolean focusedWindowChangeAllowed, long time, @NotNull FocusEvent.Cause cause) {
        Intrinsics.checkNotNullParameter((Object)lightweightChild, (String)"lightweightChild");
        Intrinsics.checkNotNullParameter((Object)((Object)cause), (String)"cause");
        Component current = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (Intrinsics.areEqual((Object)current, (Object)lightweightChild)) {
            return true;
        }
        return IdeKeyboardFocusManagerPeer.INSTANCE.deliverFocus(current, lightweightChild, (Component)this.window, temporary, focusedWindowChangeAllowed, time, cause);
    }

    public final void flush() {
        block0: {
            LuxGraphicsAdapter luxGraphicsAdapter = this.graphicsAdapter;
            if (luxGraphicsAdapter == null) break block0;
            luxGraphicsAdapter.flush();
        }
    }

    public final void repaint() {
        block2: {
            if (this.isInLayout) {
                return;
            }
            if (!this.isBound()) {
                return;
            }
            LuxGraphicsAdapter luxGraphicsAdapter = this.graphicsAdapter;
            this.paint(luxGraphicsAdapter != null ? luxGraphicsAdapter.createGraphics() : null);
            LuxGraphicsAdapter luxGraphicsAdapter2 = this.graphicsAdapter;
            if (luxGraphicsAdapter2 == null) break block2;
            luxGraphicsAdapter2.flush();
        }
    }

    public final void updateCursor() {
        Serializable serializable = IdeMouseInfoPeer.INSTANCE.getComponentUnderCursor();
        if (serializable == null || (serializable = serializable.getCursor()) == null) {
            serializable = Cursor.getDefaultCursor();
        }
        Serializable cursor = serializable;
        IOptProperty iOptProperty = this.model.getCursor();
        Intrinsics.checkNotNull((Object)cursor);
        iOptProperty.set((Object)com.jetbrains.rd.platform.codeWithMe.lux.UtilKt.toLx((Cursor)cursor));
    }

    public final void paint(@Nullable Graphics g) {
        this.window.paint(g);
    }

    public final void print(@Nullable Graphics g) {
        this.window.print(g);
    }

    public final Point getLocationOnScreen() {
        return this.window.getLocation();
    }

    public final Dimension getMinimumSize() {
        return this.window.getSize();
    }

    public final void notifyLayoutStarts() {
        this.isInLayout = true;
    }

    public final void notifyLayoutFinish() {
        this.isInLayout = false;
        Iterable $this$forEach$iv = this.afterLayoutActions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
        this.afterLayoutActions.clear();
        if (this.window.isVisible()) {
            this.window.repaint();
        }
    }

    public final void runOrQueueAfterLayout(@NotNull Function0<Unit> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        if (this.isInLayout) {
            this.afterLayoutActions.add(runnable);
        } else {
            runnable.invoke();
        }
    }

    @NotNull
    public final LxLocalComponentId addLocalComponent(@NotNull Lifetime lifetime, @NotNull LxLocalComponent localComponentModel) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)localComponentModel, (String)"localComponentModel");
        int n = localComponentCounter;
        localComponentCounter = n + 1;
        LxLocalComponentId localId = new LxLocalComponentId(n);
        CollectionExKt.addUnique((Map)((Map)this.model.getLocalComponents()), (Lifetime)lifetime, (Object)localId, (Object)localComponentModel);
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Add local component: " + localComponentModel.getClass().getName() + ", id = " + localId + " to " + this);
        }
        return localId;
    }

    private final void trackInputLocation() {
        this.trackFocusedComponentInWindow(this.window, (Lifetime)this.lifetime, new Consumer<Component>(this){
            private JTextComponent currentInputMethodTarget;
            private final AtomicBoolean inputLocationUpdateScheduled;
            final /* synthetic */ LuxComponentAdapter this$0;
            {
                this.this$0 = $receiver;
                this.inputLocationUpdateScheduled = new AtomicBoolean();
            }

            public void accept(Component focusedComponent) {
                JTextComponent inputMethodTarget;
                JTextComponent jTextComponent = focusedComponent instanceof JTextComponent ? (JTextComponent)focusedComponent : null;
                if (jTextComponent != null) {
                    JTextComponent jTextComponent2;
                    JTextComponent it = jTextComponent2 = jTextComponent;
                    boolean bl = false;
                    v1 = it.isEditable() && !(it instanceof JPasswordField) ? jTextComponent2 : null;
                } else {
                    v1 = inputMethodTarget = null;
                }
                if (this.currentInputMethodTarget != inputMethodTarget) {
                    JTextComponent jTextComponent3 = this.currentInputMethodTarget;
                    if (jTextComponent3 != null) {
                        jTextComponent3.removeCaretListener(this);
                    }
                    JTextComponent jTextComponent4 = inputMethodTarget;
                    if (jTextComponent4 != null) {
                        jTextComponent4.addCaretListener(this);
                    }
                    this.currentInputMethodTarget = inputMethodTarget;
                    this.caretUpdate(null);
                }
            }

            public void caretUpdate(CaretEvent e) {
                if (!this.inputLocationUpdateScheduled.compareAndSet(false, true)) {
                    return;
                }
                SwingUtilities.invokeLater(() -> trackInputLocation.1.caretUpdate$lambda$1(this.this$0, this));
            }

            /*
             * WARNING - void declaration
             */
            private static final void caretUpdate$lambda$1(LuxComponentAdapter this$0, trackInputLocation.1 this$1) {
                LxRect lxRect;
                if (RLifetimeKt.isNotAlive((Lifetime)((Lifetime)this$0.getLifetime()))) {
                    return;
                }
                this$1.inputLocationUpdateScheduled.set(false);
                IProperty iProperty = this$0.getModel().getInputLocation();
                JTextComponent jTextComponent = this$1.currentInputMethodTarget;
                if (jTextComponent != null) {
                    Cloneable cloneable;
                    Rectangle screenRect;
                    void it;
                    JTextComponent jTextComponent2 = jTextComponent;
                    IProperty iProperty2 = iProperty;
                    boolean bl = false;
                    InputMethodRequests inputMethodRequests = it.getInputMethodRequests();
                    Rectangle rectangle = screenRect = inputMethodRequests != null ? inputMethodRequests.getTextLocation(TextHitInfo.beforeOffset(0)) : null;
                    if (screenRect == null) {
                        Cloneable $this$caretUpdate_u24lambda_u241_u240_u240 = var5_6 = new Rectangle(0, it.getHeight(), 0, 0);
                        boolean bl2 = false;
                        SwingUtilities.convertRectangle((Component)it, (Rectangle)$this$caretUpdate_u24lambda_u241_u240_u240, this$0.getWindow());
                        cloneable = var5_6;
                    } else {
                        Point $this$caretUpdate_u24lambda_u241_u240_u241 = var5_6 = screenRect.getLocation();
                        boolean bl3 = false;
                        SwingUtilities.convertPointFromScreen($this$caretUpdate_u24lambda_u241_u240_u241, this$0.getWindow());
                        Dimension dimension = screenRect.getSize();
                        Cloneable cloneable2 = var5_6;
                        cloneable = new Rectangle((Point)cloneable2, dimension);
                    }
                    Cloneable windowRect = cloneable;
                    lxRect = com.jetbrains.rd.platform.codeWithMe.lux.UtilKt.toLx((Rectangle)windowRect);
                    iProperty = iProperty2;
                } else {
                    lxRect = null;
                }
                iProperty.set(lxRect);
            }
        });
    }

    private final void trackFocusedComponentInWindow(Window window, Lifetime lifetime, Consumer<Component> listener2) {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        PropertyChangeListener kfmListener2 = new PropertyChangeListener(kfm, window, listener2){
            private Component currentFocusOwner;
            final /* synthetic */ KeyboardFocusManager $kfm;
            final /* synthetic */ Window $window;
            final /* synthetic */ Consumer<Component> $listener;
            {
                this.$kfm = $kfm;
                this.$window = $window;
                this.$listener = $listener;
            }

            public void propertyChange(PropertyChangeEvent evt) {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                String propName = evt.getPropertyName();
                if (Intrinsics.areEqual((Object)propName, (Object)"focusOwner") || Intrinsics.areEqual((Object)propName, (Object)"focusedWindow")) {
                    Component focusOwner;
                    Component component = focusOwner = this.$kfm.getFocusedWindow() == this.$window ? this.$kfm.getFocusOwner() : null;
                    if (focusOwner != this.currentFocusOwner) {
                        this.currentFocusOwner = focusOwner;
                        WriteIntentReadAction.run(() -> trackFocusedComponentInWindow.kfmListener.1.propertyChange$lambda$0(this.$listener, focusOwner));
                    }
                }
            }

            private static final void propertyChange$lambda$0(Consumer $listener, Component $focusOwner) {
                $listener.accept($focusOwner);
            }
        };
        lifetime.bracketIfAlive(() -> LuxComponentAdapter.trackFocusedComponentInWindow$lambda$0(kfm, kfmListener2), () -> LuxComponentAdapter.trackFocusedComponentInWindow$lambda$1(kfm, kfmListener2, listener2));
    }

    public final int drawOperationsCollected() {
        LuxGraphicsAdapter luxGraphicsAdapter = this.graphicsAdapter;
        return luxGraphicsAdapter != null ? luxGraphicsAdapter.drawOperationsCollected() : 0;
    }

    @Nullable
    public final Unit clearDrawOperations() {
        Unit unit;
        LuxGraphicsAdapter luxGraphicsAdapter = this.graphicsAdapter;
        if (luxGraphicsAdapter != null) {
            luxGraphicsAdapter.clear();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final BufferedImage createMockBuffer() {
        BufferedImage bufferedImage = ImageUtil.createImage((GraphicsConfiguration)this.getGraphicsConfiguration(), (int)1, (int)1, (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
        return bufferedImage;
    }

    @NotNull
    public String toString() {
        String bound = this.isBound() ? "bound" : "unbound";
        return this.getClass().getSimpleName() + "(" + bound + ", id=" + this.luxId + ", window=" + this.window.getClass().getSimpleName() + ")";
    }

    private static final Unit _init_$lambda$2(LuxComponentAdapter this$0) {
        this$0.dispose();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(LuxComponentAdapter this$0, LxPoint it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger $this$trace$iv = this$0.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Received position: " + it + ". Node: " + this$0.model.getLocation());
        }
        this$0.receivePosition(com.jetbrains.rd.platform.codeWithMe.lux.UtilKt.fromLxInt((LxPoint)it));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(LuxComponentAdapter this$0, LxSize it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger $this$trace$iv = this$0.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Received size: " + it + ". Node: " + this$0.model.getLocation());
        }
        this$0.receiveSize(it.getWidth(), it.getHeight());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(LuxComponentAdapter this$0, LxEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger $this$trace$iv = this$0.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Received event: " + it + ". Node: " + this$0.model.getLocation());
        }
        this$0.receiveEvent(it);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$6(LuxComponentAdapter this$0, boolean it) {
        Logger $this$trace$iv = this$0.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Received visibility: " + it + ". Node: " + this$0.model.getLocation());
        }
        this$0.receiveVisibilityChange(it);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$7(LuxComponentAdapter this$0, RemoteGraphicsConfigurationModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.setGraphicsConfiguration(UtilKt.fromModel(it));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$8(LuxComponentAdapter this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger $this$trace$iv = this$0.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Request repaint");
        }
        this$0.repaint();
        return Unit.INSTANCE;
    }

    private static final AWTEvent receiveEvent$lambda$1$0(ClientAppSession $session, LxEvent $event, LuxComponentAdapter this$0, boolean $isDragEvent) {
        return UnattendedHostEventHelper.INSTANCE.convertAndDispatchLxEvent($session, $event, this$0.window, $isDragEvent ? this$0.lastMousePressedEvent : null);
    }

    private static final Unit receiveEvent$lambda$1(LxEvent $event, ClientAppSession $session, LuxComponentAdapter this$0) {
        boolean isDragEvent = $event instanceof LxMouseEvent && ((LxMouseEvent)$event).getType() == LxMouseEventType.Dragged;
        Object object = ClientId.Companion.withClientId($session.getClientId(), () -> LuxComponentAdapter.receiveEvent$lambda$1$0($session, $event, this$0, isDragEvent));
        AWTEvent it = (AWTEvent)object;
        boolean bl = false;
        AWTEvent aWTEvent = it;
        boolean bl2 = aWTEvent != null ? aWTEvent.getID() == 501 : false;
        if (bl2) {
            AWTEvent aWTEvent2 = it;
            Intrinsics.checkNotNull((Object)aWTEvent2, (String)"null cannot be cast to non-null type java.awt.event.MouseEvent");
            this$0.lastMousePressedEvent = (MouseEvent)aWTEvent2;
        }
        return Unit.INSTANCE;
    }

    private static final Unit bindTo$lambda$2$0(LuxComponentAdapter this$0, LuxHostConnection $connection, LifetimeDefinition $it) {
        this$0.graphicsAdapter = $connection.bindAdapter((Lifetime)$it, this$0, (LxAbstractComponent)this$0.model);
        LuxBackendLocalBindingManager.INSTANCE.bindLocalComponentsIfNeeded((Lifetime)$it, this$0);
        return Unit.INSTANCE;
    }

    private static final Unit bindTo$lambda$2$1(LuxComponentAdapter this$0) {
        LuxGraphicsAdapter luxGraphicsAdapter = this$0.graphicsAdapter;
        if (luxGraphicsAdapter != null) {
            luxGraphicsAdapter.dispose();
        }
        this$0.graphicsAdapter = null;
        this$0.bindingLifetime = null;
        return Unit.INSTANCE;
    }

    private static final Unit trackFocusedComponentInWindow$lambda$0(KeyboardFocusManager $kfm, trackFocusedComponentInWindow.kfmListener.1 $kfmListener) {
        $kfm.addPropertyChangeListener($kfmListener);
        return Unit.INSTANCE;
    }

    private static final Unit trackFocusedComponentInWindow$lambda$1(KeyboardFocusManager $kfm, trackFocusedComponentInWindow.kfmListener.1 $kfmListener, Consumer $listener) {
        $kfm.removePropertyChangeListener($kfmListener);
        $listener.accept(null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$getReenterLock$p(LuxComponentAdapter $this) {
        return $this.reenterLock;
    }

    public static final /* synthetic */ void access$setReenterLock$p(LuxComponentAdapter $this, boolean bl) {
        $this.reenterLock = bl;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/lux/adapter/LuxComponentAdapter$Companion;", "", "<init>", "()V", "localComponentCounter", "", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

