/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.options;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ConfigurableWithId;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.ex.ConfigurableExtensionPointUtil;
import com.intellij.openapi.options.ex.ConfigurableGroupEP;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.ex.HierarchicalConfigurable;
import com.intellij.openapi.options.ex.Weighted;
import com.intellij.openapi.options.newEditor.SettingsTreeView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.NaturalComparator;
import com.jetbrains.codeWithMe.model.ConfigurableChild;
import com.jetbrains.codeWithMe.model.ConfigurableGroupInfo;
import com.jetbrains.codeWithMe.model.ConfigurableInfo;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rdserver.options.BackendSettingsUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\bJ\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0014J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0002J4\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u0007H\u0002J4\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u0007H\u0002J\f\u0010 \u001a\u00020!*\u00020\tH\u0002J\u000e\u0010\"\u001a\u0004\u0018\u00010\b*\u00020\tH\u0002J \u0010#\u001a\u00020\u0017*\u00020\t2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00170%H\u0002J\u000e\u0010&\u001a\u0004\u0018\u00010\b*\u00020\u001aH\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/jetbrains/rdserver/options/BackendConfigurablesStorage;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "idsToConfigurablesCache", "", "", "Lcom/intellij/openapi/options/Configurable;", "configurablesInfos", "", "Lcom/jetbrains/codeWithMe/model/ConfigurableInfo;", "groupInfos", "Lcom/jetbrains/codeWithMe/model/ConfigurableGroupInfo;", "getConfigurable", "id", "getAllConfigurables", "", "getConfigurablesInfos", "", "getGroupInfos", "filterConfigurables", "", "processParentChildDepRecursively", "configurable", "Lcom/intellij/openapi/options/ConfigurableWithId;", "parentId", "parentToChild", "", "Lcom/jetbrains/codeWithMe/model/ConfigurableChild;", "addRecursively", "getWeight", "", "getParentId", "processChildren", "action", "Lkotlin/Function1;", "getIdSafe", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendConfigurablesStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendConfigurablesStorage.kt\ncom/jetbrains/rdserver/options/BackendConfigurablesStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,163:1\n812#2,12:164\n1915#2,2:196\n383#3,7:176\n1#4:183\n4253#5,12:184\n13#6:198\n*S KotlinDebug\n*F\n+ 1 BackendConfigurablesStorage.kt\ncom/jetbrains/rdserver/options/BackendConfigurablesStorage\n*L\n26#1:164,12\n143#1:196,2\n83#1:176,7\n142#1:184,12\n157#1:198\n*E\n"})
public final class BackendConfigurablesStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Configurable> idsToConfigurablesCache = new LinkedHashMap();
    @NotNull
    private final List<ConfigurableInfo> configurablesInfos = new ArrayList();
    @NotNull
    private final Map<String, ConfigurableGroupInfo> groupInfos = new LinkedHashMap();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Comparator<ConfigurableChild> configurableChildComparator;

    /*
     * WARNING - void declaration
     */
    public BackendConfigurablesStorage(@Nullable Project project) {
        void $this$filterIsInstanceTo$iv$iv;
        List list = ConfigurableExtensionPointUtil.getConfigurables((Project)project, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getConfigurables(...)");
        Iterable $this$filterIsInstance$iv = list;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ConfigurableWithId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List configurables = (List)destination$iv$iv;
        Map parentToChild = new LinkedHashMap();
        for (ConfigurableWithId it : configurables) {
            this.processParentChildDepRecursively(it, this.getParentId((Configurable)it), parentToChild);
        }
        for (ConfigurableWithId it : configurables) {
            this.addRecursively(it, this.getParentId((Configurable)it), parentToChild);
        }
        this.filterConfigurables();
    }

    @Nullable
    public final Configurable getConfigurable(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.idsToConfigurablesCache.get(id);
    }

    @NotNull
    public final Collection<Configurable> getAllConfigurables() {
        return this.idsToConfigurablesCache.values();
    }

    @NotNull
    public final List<ConfigurableInfo> getConfigurablesInfos() {
        return this.configurablesInfos;
    }

    @NotNull
    public final List<ConfigurableGroupInfo> getGroupInfos() {
        return CollectionsKt.toList((Iterable)this.groupInfos.values());
    }

    private final void filterConfigurables() {
        HashSet idsToFilterOut = new HashSet();
        ColorSettingsPage.EP_NAME.forEachExtensionSafe(arg_0 -> BackendConfigurablesStorage.filterConfigurables$lambda$1(arg_0 -> BackendConfigurablesStorage.filterConfigurables$lambda$0(idsToFilterOut, arg_0), arg_0));
        this.configurablesInfos.removeIf(arg_0 -> BackendConfigurablesStorage.filterConfigurables$lambda$3(arg_0 -> BackendConfigurablesStorage.filterConfigurables$lambda$2(idsToFilterOut, arg_0), arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void processParentChildDepRecursively(ConfigurableWithId configurable, String parentId, Map<String, Set<ConfigurableChild>> parentToChild) {
        String string = this.getIdSafe(configurable);
        if (string == null) {
            return;
        }
        String id = string;
        if (parentId != null) {
            Object object;
            void $this$getOrPut$iv;
            Map<String, Set<ConfigurableChild>> map2 = parentToChild;
            String key$iv = parentId;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Set set = (Set)object;
            String string2 = configurable.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
            set.add(new ConfigurableChild(id, string2, this.getWeight((Configurable)configurable)));
            ConfigurableGroupEP configurableGroupEP = ConfigurableGroupEP.find((String)parentId);
            if (configurableGroupEP != null) {
                ConfigurableGroupEP group2 = configurableGroupEP;
                boolean bl = false;
                String string3 = group2.id;
                String string4 = group2.id;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"id");
                String string5 = group2.parentId;
                int n = group2.weight;
                String string6 = group2.getDisplayName();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getDisplayName(...)");
                String string7 = group2.getDescription();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getDescription(...)");
                this.groupInfos.putIfAbsent(string3, new ConfigurableGroupInfo(string4, string5, n, string6, string7));
            }
        }
        this.processChildren((Configurable)configurable, (Function1<? super ConfigurableWithId, Unit>)((Function1)arg_0 -> BackendConfigurablesStorage.processParentChildDepRecursively$lambda$2(this, id, parentToChild, arg_0)));
    }

    private final void addRecursively(ConfigurableWithId configurable, String parentId, Map<String, Set<ConfigurableChild>> parentToChild) {
        String string = this.getIdSafe(configurable);
        if (string == null) {
            return;
        }
        String id = string;
        if (this.idsToConfigurablesCache.putIfAbsent(id, (Configurable)configurable) != null) {
            return;
        }
        this.processChildren((Configurable)configurable, (Function1<? super ConfigurableWithId, Unit>)((Function1)arg_0 -> BackendConfigurablesStorage.addRecursively$lambda$0(this, id, parentToChild, arg_0)));
        String string2 = configurable.getDisplayName();
        if (string2 == null) {
            String string3;
            String it = string3 = id;
            boolean bl = false;
            LOG.error("can't get displayName for configurable with id=" + id);
            string2 = string3;
        }
        String displayName = string2;
        Project project = SettingsTreeView.prepareProject(null, (Configurable)((Configurable)configurable));
        RdProjectId projectId = project != null ? ProjectUtilKt.getRdProjectId((Project)project) : null;
        Set<ConfigurableChild> set = parentToChild.get(id);
        List children = set != null ? CollectionsKt.sortedWith((Iterable)set, configurableChildComparator) : null;
        ConfigurableGroup configurableGroup = BackendSettingsUtilKt.asConfigurableGroup((Configurable)configurable);
        String string4 = configurableGroup != null ? configurableGroup.getDescription() : null;
        int n = this.getWeight((Configurable)configurable);
        boolean bl = BackendSettingsUtilKt.asTopComponentProvider((Configurable)configurable) != null;
        String string5 = configurable.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
        ConfigurableInfo info2 = new ConfigurableInfo(id, parentId, displayName, string4, children, n, bl, projectId, string5);
        this.configurablesInfos.add(info2);
    }

    private final int getWeight(Configurable $this$getWeight) {
        Weighted weighted = $this$getWeight instanceof Weighted ? (Weighted)$this$getWeight : null;
        return weighted != null ? weighted.getWeight() : 0;
    }

    private final String getParentId(Configurable $this$getParentId) {
        Object object = $this$getParentId instanceof HierarchicalConfigurable ? (HierarchicalConfigurable)$this$getParentId : null;
        if (object == null || (object = object.getParentId()) == null) {
            ConfigurableWrapper configurableWrapper = $this$getParentId instanceof ConfigurableWrapper ? (ConfigurableWrapper)$this$getParentId : null;
            object = configurableWrapper != null && (configurableWrapper = configurableWrapper.getExtensionPoint()) != null ? configurableWrapper.groupId : null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final void processChildren(Configurable $this$processChildren, Function1<? super ConfigurableWithId, Unit> action) {
        Configurable[] configurableArray;
        Configurable.Composite composite2;
        Configurable.Composite composite3 = composite2 = $this$processChildren instanceof Configurable.Composite ? (Configurable.Composite)$this$processChildren : null;
        if (composite2 != null && (configurableArray = composite2.getConfigurables()) != null) {
            void $this$forEach$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            Configurable[] configurableArray2 = configurableArray;
            boolean $i$f$filterIsInstance = false;
            Iterator iterator = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ConfigurableWithId)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ConfigurableWithId it = (ConfigurableWithId)element$iv;
                boolean bl = false;
                action.invoke((Object)it);
            }
        }
    }

    private final String getIdSafe(ConfigurableWithId $this$getIdSafe) {
        String string;
        try {
            string = $this$getIdSafe.getId();
        }
        catch (Exception ex) {
            LOG.error("Can't retrieve configurable id for " + $this$getIdSafe, (Throwable)ex);
            return null;
        }
        return string;
    }

    private static final Unit filterConfigurables$lambda$0(HashSet $idsToFilterOut, ColorSettingsPage page) {
        String id = "reference.settingsdialog.IDE.editor.colors." + page.getId();
        $idsToFilterOut.add(id);
        return Unit.INSTANCE;
    }

    private static final void filterConfigurables$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean filterConfigurables$lambda$2(HashSet $idsToFilterOut, ConfigurableInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $idsToFilterOut.contains(it.getId());
    }

    private static final boolean filterConfigurables$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit processParentChildDepRecursively$lambda$2(BackendConfigurablesStorage this$0, String $id, Map $parentToChild, ConfigurableWithId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.processParentChildDepRecursively(it, $id, $parentToChild);
        return Unit.INSTANCE;
    }

    private static final Unit addRecursively$lambda$0(BackendConfigurablesStorage this$0, String $id, Map $parentToChild, ConfigurableWithId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.addRecursively(it, $id, $parentToChild);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BackendConfigurablesStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                ConfigurableChild p0 = (ConfigurableChild)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(p0.getWeight());
                p0 = (ConfigurableChild)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(p0.getWeight()));
            }
        };
        Comparator comparator2 = NaturalComparator.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)comparator2, (String)"INSTANCE");
        Comparator comparator3 = comparator2;
        configurableChildComparator = new Comparator(comparator, comparator3){
            final /* synthetic */ Comparator $this_thenBy;
            final /* synthetic */ Comparator $comparator;
            {
                this.$this_thenBy = $receiver;
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    ConfigurableChild configurableChild = (ConfigurableChild)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    ConfigurableChild p0 = (ConfigurableChild)b;
                    String string = p0.getDisplayName();
                    bl = false;
                    String string2 = p0.getDisplayName();
                    n = comparator.compare(string, string2);
                }
                return n;
            }
        };
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdserver/options/BackendConfigurablesStorage$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "configurableChildComparator", "Ljava/util/Comparator;", "Lcom/jetbrains/codeWithMe/model/ConfigurableChild;", "Lkotlin/Comparator;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

