/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.portForwarding.internal;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ForwardedPort;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortConfiguration;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortConfigurationKt;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortDirectionType;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortForwardingResult;
import com.jetbrains.rdserver.portForwarding.PortForwardingConfiguration;
import com.jetbrains.rdserver.portForwarding.internal.ForwardedPortsFilter;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\nJ\u0010\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u000f\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0010\u001a\u00020\nH\u0002J \u0010\u0011\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u0015\u001a\u00020\u00142\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u0016\u001a\u00020\u00142\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rdserver/portForwarding/internal/ForwardedPortValidator;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "validatePort", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortForwardingResult;", "ports", "", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ForwardedPort;", "port", "validatePortInRange", "portNumber", "", "validateDirectPort", "forwardedPort", "validateReversePort", "validateExposedPort", "isCyclicForwarding", "", "isBackendCyclicForwarding", "isFrontendCyclicForwarding", "isPortsCauseCyclicForwarding", "directPort", "reversePort", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nForwardedPortValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForwardedPortValidator.kt\ncom/jetbrains/rdserver/portForwarding/internal/ForwardedPortValidator\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,181:1\n60#2,5:182\n23#2:200\n1#3:187\n1807#4,2:188\n1807#4,3:190\n1809#4:193\n1807#4,2:194\n1807#4,3:196\n1809#4:199\n*S KotlinDebug\n*F\n+ 1 ForwardedPortValidator.kt\ncom/jetbrains/rdserver/portForwarding/internal/ForwardedPortValidator\n*L\n45#1:182,5\n21#1:200\n141#1:188,2\n142#1:190,3\n141#1:193\n167#1:194,2\n168#1:196,3\n167#1:199\n*E\n"})
public final class ForwardedPortValidator {
    @NotNull
    public static final ForwardedPortValidator INSTANCE;
    @NotNull
    private static final Logger logger;

    private ForwardedPortValidator() {
    }

    @Nullable
    public final PortForwardingResult validatePort(@NotNull List<? extends ForwardedPort> ports, @NotNull ForwardedPort port) {
        PortForwardingResult portForwardingResult;
        Intrinsics.checkNotNullParameter(ports, (String)"ports");
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        PortConfiguration portConfiguration = port.getConfiguration();
        if (PortConfigurationKt.isGlobalForwardedPort((PortConfiguration)portConfiguration) || PortConfigurationKt.isPerClientDirectForwardedPort((PortConfiguration)portConfiguration)) {
            portForwardingResult = this.validateDirectPort(ports, port);
        } else if (PortConfigurationKt.isPerClientReversedForwardedPort((PortConfiguration)portConfiguration)) {
            portForwardingResult = this.validateReversePort(ports, port);
        } else if (PortConfigurationKt.isExposedPort((PortConfiguration)portConfiguration)) {
            portForwardingResult = this.validateExposedPort(port);
        } else {
            throw new IllegalStateException(("Unable to validate forwarded port. Unexpected port type: " + Reflection.getOrCreateKotlinClass(portConfiguration.getClass()).getSimpleName()).toString());
        }
        PortForwardingResult forwardingResult = portForwardingResult;
        Logger $this$debug_u24default$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Forwarded port validation has finished with result: " + forwardingResult, t$iv);
        }
        return forwardingResult;
    }

    @Nullable
    public final PortForwardingResult validatePortInRange(int portNumber) {
        IntRange intRange = PortForwardingConfiguration.INSTANCE.getValidPortsRange();
        int n = intRange.getFirst();
        if (!(portNumber <= intRange.getLast() ? n <= portNumber : false)) {
            return (PortForwardingResult)new PortForwardingResult.PortOutOfValidRange(portNumber, PortForwardingConfiguration.INSTANCE.getValidPortsRange());
        }
        return null;
    }

    private final PortForwardingResult validateDirectPort(List<? extends ForwardedPort> ports, ForwardedPort forwardedPort) {
        if (!(PortConfigurationKt.isGlobalForwardedPort((PortConfiguration)forwardedPort.getConfiguration()) || PortConfigurationKt.isPerClientDirectForwardedPort((PortConfiguration)forwardedPort.getConfiguration()))) {
            boolean $i$a$-require-ForwardedPortValidator$validateDirectPort$22 = false;
            String $i$a$-require-ForwardedPortValidator$validateDirectPort$22 = "Direct forwarding validation error. Unexpected port configuration type: " + forwardedPort.getConfiguration().getClass().getSimpleName();
            throw new IllegalArgumentException($i$a$-require-ForwardedPortValidator$validateDirectPort$22.toString());
        }
        int portNumber = forwardedPort.getTargetPortNumber();
        PortForwardingResult $i$a$-require-ForwardedPortValidator$validateDirectPort$22 = this.validatePortInRange(portNumber);
        if ($i$a$-require-ForwardedPortValidator$validateDirectPort$22 != null) {
            PortForwardingResult result = $i$a$-require-ForwardedPortValidator$validateDirectPort$22;
            boolean bl = false;
            return result;
        }
        List<ForwardedPort> directPorts = ForwardedPortsFilter.INSTANCE.filterBackendForwardedPorts(ports, portNumber);
        if (!((Collection)directPorts).isEmpty()) {
            return (PortForwardingResult)new PortForwardingResult.PortAlreadyForwarded(portNumber);
        }
        if (this.isBackendCyclicForwarding(ports, portNumber)) {
            return (PortForwardingResult)new PortForwardingResult.CyclicForwardingError(portNumber);
        }
        return null;
    }

    private final PortForwardingResult validateReversePort(List<? extends ForwardedPort> ports, ForwardedPort forwardedPort) {
        if (!PortConfigurationKt.isPerClientReversedForwardedPort((PortConfiguration)forwardedPort.getConfiguration())) {
            boolean $i$a$-require-ForwardedPortValidator$validateReversePort$22 = false;
            String $i$a$-require-ForwardedPortValidator$validateReversePort$22 = "Reverse forwarding validation error. Unexpected port configuration type: " + forwardedPort.getConfiguration().getClass().getSimpleName();
            throw new IllegalArgumentException($i$a$-require-ForwardedPortValidator$validateReversePort$22.toString());
        }
        int portNumber = forwardedPort.getTargetPortNumber();
        PortForwardingResult $i$a$-require-ForwardedPortValidator$validateReversePort$22 = this.validatePortInRange(portNumber);
        if ($i$a$-require-ForwardedPortValidator$validateReversePort$22 != null) {
            PortForwardingResult result = $i$a$-require-ForwardedPortValidator$validateReversePort$22;
            boolean bl = false;
            return result;
        }
        List<ForwardedPort> reversePorts = ForwardedPortsFilter.INSTANCE.filterFrontendForwardedPorts(ports, portNumber);
        if (!((Collection)reversePorts).isEmpty()) {
            return (PortForwardingResult)new PortForwardingResult.PortAlreadyForwarded(portNumber);
        }
        if (this.isFrontendCyclicForwarding(ports, portNumber)) {
            return (PortForwardingResult)new PortForwardingResult.CyclicForwardingError(portNumber);
        }
        return null;
    }

    private final PortForwardingResult validateExposedPort(ForwardedPort forwardedPort) {
        if (!PortConfigurationKt.isExposedPort((PortConfiguration)forwardedPort.getConfiguration())) {
            boolean bl = false;
            String string = "Exposed port validation error. Unexpected port configuration type: " + Reflection.getOrCreateKotlinClass(forwardedPort.getConfiguration().getClass()).getSimpleName();
            throw new IllegalArgumentException(string.toString());
        }
        int portNumber = forwardedPort.getTargetPortNumber();
        return this.validatePortInRange(portNumber);
    }

    private final boolean isCyclicForwarding(List<? extends ForwardedPort> ports, int portNumber) {
        return this.isBackendCyclicForwarding(ports, portNumber) || this.isFrontendCyclicForwarding(ports, portNumber);
    }

    private final boolean isBackendCyclicForwarding(List<? extends ForwardedPort> ports, int portNumber) {
        boolean bl;
        block9: {
            List<ForwardedPort> directPorts = ForwardedPortsFilter.INSTANCE.filterForwardedPortsByTargetPortNumber(ports, PortDirectionType.DIRECT, portNumber);
            if (directPorts.isEmpty()) {
                return false;
            }
            List<ForwardedPort> reversePorts = ForwardedPortsFilter.INSTANCE.filterForwardedPortsByCounterpartPortNumber(ports, PortDirectionType.REVERSED, portNumber);
            if (reversePorts.isEmpty()) {
                return false;
            }
            Iterable $this$any$iv = directPorts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block8: {
                        ForwardedPort directPort = (ForwardedPort)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = reversePorts;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                ForwardedPort reversePort = (ForwardedPort)element$iv2;
                                boolean bl4 = false;
                                if (!INSTANCE.isPortsCauseCyclicForwarding(directPort, reversePort)) continue;
                                bl2 = true;
                                break block8;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isFrontendCyclicForwarding(List<? extends ForwardedPort> ports, int portNumber) {
        boolean bl;
        block9: {
            List<ForwardedPort> directPorts = ForwardedPortsFilter.INSTANCE.filterForwardedPortsByCounterpartPortNumber(ports, PortDirectionType.DIRECT, portNumber);
            if (directPorts.isEmpty()) {
                return false;
            }
            List<ForwardedPort> reversePorts = ForwardedPortsFilter.INSTANCE.filterForwardedPortsByTargetPortNumber(ports, PortDirectionType.REVERSED, portNumber);
            if (reversePorts.isEmpty()) {
                return false;
            }
            Iterable $this$any$iv = directPorts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block8: {
                        ForwardedPort directPort = (ForwardedPort)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = reversePorts;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                ForwardedPort reversePort = (ForwardedPort)element$iv2;
                                boolean bl4 = false;
                                if (!INSTANCE.isPortsCauseCyclicForwarding(directPort, reversePort)) continue;
                                bl2 = true;
                                break block8;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isPortsCauseCyclicForwarding(ForwardedPort directPort, ForwardedPort reversePort) {
        return directPort.getTargetPortNumber() == reversePort.getTargetPortNumber() && directPort.getCounterpartPortNumber() == reversePort.getCounterpartPortNumber();
    }

    static {
        ForwardedPortValidator $this$thisLogger$iv = INSTANCE = new ForwardedPortValidator();
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(ForwardedPortValidator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ForwardedPortValidator.logger = logger;
    }
}

