/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.portForwarding.internal;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ForwardedPort;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortConfiguration;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortConfigurationKt;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortDirectionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\b0\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\b0\u0007J&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0010J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0014\u001a\u00020\u0010J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0014\u001a\u00020\u0010J \u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0012\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rdserver/portForwarding/internal/ForwardedPortsFilter;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "filterPortsByDirection", "", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ForwardedPort;", "direction", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortDirectionType;", "filterDirectForwardedPorts", "filterReverseForwardedPorts", "filterForwardedPortsByTargetPortNumber", "portDirectionType", "targetPortNumber", "", "filterForwardedPortsByCounterpartPortNumber", "counterpartPortNumber", "filterBackendForwardedPorts", "portNumber", "filterFrontendForwardedPorts", "filterDirectPortsByTargetPortNumber", "filterDirectPortsByCounterpartPortNumber", "filterReversePortsByTargetPortNumber", "filterReversePortsByCounterpartPortNumber", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nForwardedPortsFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForwardedPortsFilter.kt\ncom/jetbrains/rdserver/portForwarding/internal/ForwardedPortsFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,107:1\n777#2:108\n873#2,2:109\n777#2:111\n873#2,2:112\n777#2:114\n873#2,2:115\n777#2:117\n873#2,2:118\n777#2:120\n873#2,2:121\n777#2:123\n873#2,2:124\n23#3:126\n*S KotlinDebug\n*F\n+ 1 ForwardedPortsFilter.kt\ncom/jetbrains/rdserver/portForwarding/internal/ForwardedPortsFilter\n*L\n23#1:108\n23#1:109,2\n30#1:111\n30#1:112,2\n78#1:114\n78#1:115,2\n85#1:117\n85#1:118,2\n92#1:120\n92#1:121,2\n99#1:123\n99#1:124,2\n13#1:126\n*E\n"})
public final class ForwardedPortsFilter {
    @NotNull
    public static final ForwardedPortsFilter INSTANCE;
    @NotNull
    private static final Logger logger;

    private ForwardedPortsFilter() {
    }

    @NotNull
    public final List<ForwardedPort> filterPortsByDirection(@NotNull List<? extends ForwardedPort> $this$filterPortsByDirection, @NotNull PortDirectionType direction) {
        Intrinsics.checkNotNullParameter($this$filterPortsByDirection, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> this.filterDirectForwardedPorts($this$filterPortsByDirection);
            case 2 -> this.filterReverseForwardedPorts($this$filterPortsByDirection);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ForwardedPort> filterDirectForwardedPorts(@NotNull List<? extends ForwardedPort> $this$filterDirectForwardedPorts) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$filterDirectForwardedPorts, (String)"<this>");
        Iterable $this$filter$iv = $this$filterDirectForwardedPorts;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ForwardedPort port = (ForwardedPort)element$iv$iv;
            boolean bl = false;
            if (!(PortConfigurationKt.isGlobalForwardedPort((PortConfiguration)port.getConfiguration()) || PortConfigurationKt.isPerClientDirectForwardedPort((PortConfiguration)port.getConfiguration()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ForwardedPort> filterReverseForwardedPorts(@NotNull List<? extends ForwardedPort> $this$filterReverseForwardedPorts) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$filterReverseForwardedPorts, (String)"<this>");
        Iterable $this$filter$iv = $this$filterReverseForwardedPorts;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ForwardedPort port = (ForwardedPort)element$iv$iv;
            boolean bl = false;
            if (!PortConfigurationKt.isPerClientReversedForwardedPort((PortConfiguration)port.getConfiguration())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<ForwardedPort> filterForwardedPortsByTargetPortNumber(@NotNull List<? extends ForwardedPort> $this$filterForwardedPortsByTargetPortNumber, @NotNull PortDirectionType portDirectionType, int targetPortNumber) {
        Intrinsics.checkNotNullParameter($this$filterForwardedPortsByTargetPortNumber, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)portDirectionType, (String)"portDirectionType");
        return switch (WhenMappings.$EnumSwitchMapping$0[portDirectionType.ordinal()]) {
            case 1 -> this.filterDirectPortsByTargetPortNumber($this$filterForwardedPortsByTargetPortNumber, targetPortNumber);
            case 2 -> this.filterReversePortsByTargetPortNumber($this$filterForwardedPortsByTargetPortNumber, targetPortNumber);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final List<ForwardedPort> filterForwardedPortsByCounterpartPortNumber(@NotNull List<? extends ForwardedPort> $this$filterForwardedPortsByCounterpartPortNumber, @NotNull PortDirectionType portDirectionType, int counterpartPortNumber) {
        Intrinsics.checkNotNullParameter($this$filterForwardedPortsByCounterpartPortNumber, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)portDirectionType, (String)"portDirectionType");
        return switch (WhenMappings.$EnumSwitchMapping$0[portDirectionType.ordinal()]) {
            case 1 -> this.filterDirectPortsByCounterpartPortNumber($this$filterForwardedPortsByCounterpartPortNumber, counterpartPortNumber);
            case 2 -> this.filterReversePortsByCounterpartPortNumber($this$filterForwardedPortsByCounterpartPortNumber, counterpartPortNumber);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final List<ForwardedPort> filterBackendForwardedPorts(@NotNull List<? extends ForwardedPort> $this$filterBackendForwardedPorts, int portNumber) {
        Intrinsics.checkNotNullParameter($this$filterBackendForwardedPorts, (String)"<this>");
        return CollectionsKt.plus((Collection)this.filterDirectPortsByTargetPortNumber($this$filterBackendForwardedPorts, portNumber), (Iterable)this.filterReversePortsByCounterpartPortNumber($this$filterBackendForwardedPorts, portNumber));
    }

    @NotNull
    public final List<ForwardedPort> filterFrontendForwardedPorts(@NotNull List<? extends ForwardedPort> $this$filterFrontendForwardedPorts, int portNumber) {
        Intrinsics.checkNotNullParameter($this$filterFrontendForwardedPorts, (String)"<this>");
        return CollectionsKt.plus((Collection)this.filterDirectPortsByCounterpartPortNumber($this$filterFrontendForwardedPorts, portNumber), (Iterable)this.filterReversePortsByTargetPortNumber($this$filterFrontendForwardedPorts, portNumber));
    }

    /*
     * WARNING - void declaration
     */
    private final List<ForwardedPort> filterDirectPortsByTargetPortNumber(List<? extends ForwardedPort> $this$filterDirectPortsByTargetPortNumber, int targetPortNumber) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$filterDirectPortsByTargetPortNumber;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ForwardedPort port = (ForwardedPort)element$iv$iv;
            boolean bl = false;
            if (!(PortConfigurationKt.isGlobalForwardedPort((PortConfiguration)port.getConfiguration()) && port.getTargetPortNumber() == targetPortNumber || PortConfigurationKt.isPerClientDirectForwardedPort((PortConfiguration)port.getConfiguration()) && port.getTargetPortNumber() == targetPortNumber)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ForwardedPort> filterDirectPortsByCounterpartPortNumber(List<? extends ForwardedPort> $this$filterDirectPortsByCounterpartPortNumber, int counterpartPortNumber) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$filterDirectPortsByCounterpartPortNumber;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ForwardedPort port = (ForwardedPort)element$iv$iv;
            boolean bl = false;
            if (!(PortConfigurationKt.isGlobalForwardedPort((PortConfiguration)port.getConfiguration()) && port.getCounterpartPortNumber() == counterpartPortNumber || PortConfigurationKt.isPerClientDirectForwardedPort((PortConfiguration)port.getConfiguration()) && port.getCounterpartPortNumber() == counterpartPortNumber)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ForwardedPort> filterReversePortsByTargetPortNumber(List<? extends ForwardedPort> $this$filterReversePortsByTargetPortNumber, int targetPortNumber) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$filterReversePortsByTargetPortNumber;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ForwardedPort port = (ForwardedPort)element$iv$iv;
            boolean bl = false;
            if (!(PortConfigurationKt.isPerClientReversedForwardedPort((PortConfiguration)port.getConfiguration()) && port.getTargetPortNumber() == targetPortNumber)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ForwardedPort> filterReversePortsByCounterpartPortNumber(List<? extends ForwardedPort> $this$filterReversePortsByCounterpartPortNumber, int counterpartPortNumber) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$filterReversePortsByCounterpartPortNumber;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ForwardedPort port = (ForwardedPort)element$iv$iv;
            boolean bl = false;
            if (!(PortConfigurationKt.isPerClientReversedForwardedPort((PortConfiguration)port.getConfiguration()) && port.getCounterpartPortNumber() == counterpartPortNumber)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static {
        ForwardedPortsFilter $this$thisLogger$iv = INSTANCE = new ForwardedPortsFilter();
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(ForwardedPortsFilter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ForwardedPortsFilter.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PortDirectionType.values().length];
            try {
                nArray[PortDirectionType.DIRECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PortDirectionType.REVERSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

