/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.projectView;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.jetbrains.codeWithMe.model.RdProjectScope;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdserver/projectView/ProjectScopeUtils;", "", "<init>", "()V", "getScope", "Lcom/jetbrains/codeWithMe/model/RdProjectScope;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.backend.split"})
public final class ProjectScopeUtils {
    @NotNull
    public static final ProjectScopeUtils INSTANCE = new ProjectScopeUtils();

    private ProjectScopeUtils() {
    }

    @Nullable
    public final RdProjectScope getScope(@NotNull Project project, @Nullable VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (file2 == null) {
            return null;
        }
        NamedScopesHolder[] namedScopesHolderArray = NamedScopesHolder.getAllNamedScopeHolders((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)namedScopesHolderArray, (String)"getAllNamedScopeHolders(...)");
        for (NamedScopesHolder holder : namedScopesHolderArray) {
            NamedScope[] namedScopeArray;
            Intrinsics.checkNotNullExpressionValue((Object)holder.getScopes(), (String)"getScopes(...)");
            for (NamedScope scope : namedScopeArray) {
                PackageSetBase packageSet;
                PackageSet packageSet2 = scope.getValue();
                PackageSetBase packageSetBase = packageSet = packageSet2 instanceof PackageSetBase ? (PackageSetBase)packageSet2 : null;
                if (packageSet == null || !packageSet.contains(file2, project, holder)) continue;
                Color color = FileColorManager.getInstance((Project)project).getScopeColor(scope.getScopeId());
                if (color == null) continue;
                Color color2 = color;
                String colorName = FileColorManagerImpl.getColorID((Color)color2);
                String string = scope.getScopeId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getScopeId(...)");
                return new RdProjectScope(string, colorName, Integer.valueOf(color2.getRGB()));
            }
        }
        return null;
    }
}

