/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.screenForwarding;

import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.idea.AppMode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.rdserver.SplitBackendBundle;
import com.jetbrains.rdserver.screenForwarding.ScreenForwardingUtilKt;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u001a&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0001\u001a\u0006\u0010\r\u001a\u00020\u0004\u001a\b\u0010\u000e\u001a\u00020\u000fH\u0000\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "toolStartTimeout", "", "startProcessAndWaitForInitializationOutput", "Lcom/intellij/execution/process/KillableProcessHandler;", "cmd", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "initMarker", "", "timeoutMs", "processOutLogger", "findFreeDisplay", "isScreenForwardingAvailable", "", "intellij.platform.backend.split"})
public final class ScreenForwardingUtilKt {
    @NotNull
    private static final Logger logger;
    public static final int toolStartTimeout = 10000;

    @NotNull
    public static final KillableProcessHandler startProcessAndWaitForInitializationOutput(@NotNull GeneralCommandLine cmd, @NotNull String initMarker, int timeoutMs, @NotNull Logger processOutLogger) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)initMarker, (String)"initMarker");
        Intrinsics.checkNotNullParameter((Object)processOutLogger, (String)"processOutLogger");
        KillableProcessHandler process2 = new KillableProcessHandler(cmd){

            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
                Intrinsics.checkNotNullExpressionValue((Object)options, (String)"forMostlySilentProcess(...)");
                return options;
            }
        };
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        process2.addProcessListener(new ProcessListener(processOutLogger, initMarker, process2, completableFuture){
            final /* synthetic */ Logger $processOutLogger;
            final /* synthetic */ String $initMarker;
            final /* synthetic */ startProcessAndWaitForInitializationOutput.process.1 $process;
            final /* synthetic */ CompletableFuture<Void> $completableFuture;
            {
                this.$processOutLogger = $processOutLogger;
                this.$initMarker = $initMarker;
                this.$process = $process;
                this.$completableFuture = $completableFuture;
            }

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                String string = event.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                this.$processOutLogger.info(((Object)StringsKt.trim((CharSequence)string)).toString());
                String string2 = event.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                if (StringsKt.contains$default((CharSequence)string2, (CharSequence)this.$initMarker, (boolean)false, (int)2, null)) {
                    ScreenForwardingUtilKt.access$getLogger$p().info(this.$process.getCommandLineForLog() + " initialized");
                    this.$completableFuture.complete(null);
                }
            }
        });
        process2.startNotify();
        long currentTimeMillis = System.currentTimeMillis();
        while (!completableFuture.isDone()) {
            if (process2.isProcessTerminated()) {
                Object[] objectArray = new Object[2];
                Intrinsics.checkNotNullExpressionValue((Object)process2.getCommandLineForLog(), (String)"getCommandLineForLog(...)");
                Object object = process2.getExitCode();
                if (object == null) {
                    object = "<no error code>";
                }
                objectArray[1] = object;
                throw new CantRunException(SplitBackendBundle.INSTANCE.message("screen.forwarding.process.exited.unexpectedly", objectArray));
            }
            if (System.currentTimeMillis() - currentTimeMillis > (long)timeoutMs) {
                process2.killProcess();
                Object[] objectArray = new Object[]{10000};
                throw new CantRunException(SplitBackendBundle.INSTANCE.message("screen.forwarding.xpra.was.not.initialized.within.ms", objectArray));
            }
            Thread.sleep(100L);
        }
        return process2;
    }

    public static final int findFreeDisplay() {
        for (int display = 10; display < 100; ++display) {
            if (new File("/tmp/.X11-unix/X" + display).exists()) continue;
            return display;
        }
        return -1;
    }

    public static final boolean isScreenForwardingAvailable() {
        return AppMode.isRemoteDevHost();
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    static {
        Logger logger = Logger.getInstance((String)"com.jetbrains.rdserver.screenForwarding");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ScreenForwardingUtilKt.logger = logger;
    }
}

