/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.toolWindow;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.ui.viewModel.extraction.ToolWindowExtractorEP;
import com.intellij.ui.viewModel.extraction.ToolWindowExtractorMode;
import com.intellij.ui.viewModel.extraction.ToolWindowViewModelExtractor;
import com.intellij.ui.viewModel.extraction.ViewModelToolWindowFactory;
import com.intellij.util.PlatformUtils;
import com.jetbrains.rdserver.SplitBackendBundle;
import com.jetbrains.rdserver.debugger.BackendDebuggerHost;
import com.jetbrains.rdserver.toolWindow.BackendToolWindowHostKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000b\u0010\u000e\u001a\u00070\u0007\u00a2\u0006\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rdserver/toolWindow/BackendToolWindowModeProvider;", "", "<init>", "()V", "getBackendToolWindowMode", "Lcom/intellij/ui/viewModel/extraction/ToolWindowExtractorMode;", "id", "", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "getDefaultMode", "isSafeToolWindow", "", "getForcedMode", "getSupportedToolWindowsList", "Lcom/intellij/openapi/util/NlsContexts$Tooltip;", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendToolWindowHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendToolWindowHost.kt\ncom/jetbrains/rdserver/toolWindow/BackendToolWindowModeProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,1090:1\n13#2:1091\n*S KotlinDebug\n*F\n+ 1 BackendToolWindowHost.kt\ncom/jetbrains/rdserver/toolWindow/BackendToolWindowModeProvider\n*L\n806#1:1091\n*E\n"})
public final class BackendToolWindowModeProvider {
    @NotNull
    public static final BackendToolWindowModeProvider INSTANCE = new BackendToolWindowModeProvider();

    private BackendToolWindowModeProvider() {
    }

    @NotNull
    public final ToolWindowExtractorMode getBackendToolWindowMode(@Nullable String id, @NotNull ClientProjectSession session) {
        ToolWindowExtractorMode toolWindowExtractorMode;
        ToolWindowExtractorMode toolWindowExtractorMode2;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        BackendToolWindowModeProvider $this$getBackendToolWindowMode_u24lambda_u240 = this;
        boolean bl = false;
        if (id == null) {
            toolWindowExtractorMode2 = ToolWindowExtractorMode.DISABLE;
        } else {
            ToolWindowExtractorMode forcedMode = $this$getBackendToolWindowMode_u24lambda_u240.getForcedMode(id);
            toolWindowExtractorMode2 = forcedMode;
            if (toolWindowExtractorMode2 == null) {
                ToolWindowViewModelExtractor extractor;
                ToolWindowViewModelExtractor toolWindowViewModelExtractor = extractor = BackendToolWindowHostKt.access$findViewModelExtractor(id, session);
                if (toolWindowViewModelExtractor != null) {
                    toolWindowExtractorMode2 = toolWindowViewModelExtractor.getMode();
                } else {
                    ToolWindowFactory factory;
                    ToolWindowExtractorEP ep;
                    ToolWindowExtractorEP toolWindowExtractorEP = ep = (ToolWindowExtractorEP)ToolWindowExtractorEP.EP_NAME.findFirstSafe(arg_0 -> BackendToolWindowModeProvider.getBackendToolWindowMode$lambda$0$1(arg_0 -> BackendToolWindowModeProvider.getBackendToolWindowMode$lambda$0$0(id, arg_0), arg_0));
                    toolWindowExtractorMode2 = toolWindowExtractorEP != null ? toolWindowExtractorEP.mode : ((factory = BackendToolWindowHostKt.access$findToolWindowFactory(id)) instanceof ViewModelToolWindowFactory ? ToolWindowExtractorMode.PER_CLIENT : $this$getBackendToolWindowMode_u24lambda_u240.getDefaultMode(id, session));
                }
            }
        }
        ToolWindowExtractorMode mode = toolWindowExtractorMode2;
        if (session.isController() && mode.isUnsupported()) {
            toolWindowExtractorMode = ToolWindowExtractorMode.DISABLE;
        } else {
            ToolWindowExtractorMode toolWindowExtractorMode3 = mode;
            Intrinsics.checkNotNull((Object)toolWindowExtractorMode3);
            toolWindowExtractorMode = toolWindowExtractorMode3;
        }
        return toolWindowExtractorMode;
    }

    private final ToolWindowExtractorMode getDefaultMode(String id, ClientProjectSession session) {
        if (Intrinsics.areEqual((Object)"Messages", (Object)id)) {
            return ToolWindowExtractorMode.MIRROR;
        }
        if (Intrinsics.areEqual((Object)"make", (Object)id)) {
            return ToolWindowExtractorMode.MIRROR;
        }
        if (Intrinsics.areEqual((Object)"sbt", (Object)id)) {
            return ToolWindowExtractorMode.MIRROR;
        }
        if (Intrinsics.areEqual((Object)"sbt-shell-toolwindow", (Object)id)) {
            return ToolWindowExtractorMode.MIRROR;
        }
        if (Intrinsics.areEqual((Object)"Commit", (Object)id)) {
            return ToolWindowExtractorMode.FALLBACK;
        }
        if (Intrinsics.areEqual((Object)"Meet New UI", (Object)id)) {
            return ToolWindowExtractorMode.DISABLE;
        }
        ClientAppSession appSession = session.getAppSession();
        if (appSession.isController()) {
            return Intrinsics.areEqual((Object)"Problems View", (Object)id) ? (Registry.Companion.is("remoteDev.toolwindow.problems.lux.enabled") ? ToolWindowExtractorMode.PROJECTOR_INSTANCING : ToolWindowExtractorMode.PER_CLIENT) : (Intrinsics.areEqual((Object)"Run", (Object)id) && !Registry.Companion.is("remoteDev.toolwindow.run.lux.enabled") ? ToolWindowExtractorMode.MIRROR : (Intrinsics.areEqual((Object)"Debug", (Object)id) && !BackendDebuggerHost.Companion.useLuxDebugger(appSession) ? ToolWindowExtractorMode.FALLBACK : (Intrinsics.areEqual((Object)"TODO", (Object)id) ? (Registry.Companion.is("todo.toolwindow.split") ? ToolWindowExtractorMode.FALLBACK : ToolWindowExtractorMode.PER_CLIENT) : (Intrinsics.areEqual((Object)"Structure", (Object)id) ? (Registry.Companion.is("remoteDev.toolwindow.structure.lux.enabled") ? ToolWindowExtractorMode.PROJECTOR_INSTANCING : ToolWindowExtractorMode.FALLBACK) : ToolWindowExtractorMode.PROJECTOR_STEALING))));
        }
        if (Intrinsics.areEqual((Object)"Services", (Object)id) && Registry.Companion.is("codeWithMe.toolwindow.services.enabled")) {
            return ToolWindowExtractorMode.MIRROR;
        }
        if (Intrinsics.areEqual((Object)"Run", (Object)id)) {
            return ToolWindowExtractorMode.MIRROR;
        }
        if (Intrinsics.areEqual((Object)"Problems View", (Object)id)) {
            return ToolWindowExtractorMode.PER_CLIENT;
        }
        if (Intrinsics.areEqual((Object)"Structure", (Object)id)) {
            return ToolWindowExtractorMode.PER_CLIENT;
        }
        if (Intrinsics.areEqual((Object)"TODO", (Object)id)) {
            return ToolWindowExtractorMode.PER_CLIENT;
        }
        return ToolWindowExtractorMode.UNSUPPORTED;
    }

    public final boolean isSafeToolWindow(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return Intrinsics.areEqual((Object)"Problems View", (Object)id) || Intrinsics.areEqual((Object)"TODO", (Object)id);
    }

    private final ToolWindowExtractorMode getForcedMode(String id) {
        String value = Registry.Companion.stringValue("codeWithMe.toolwindow.force.extractor.mode");
        if (((CharSequence)value).length() == 0) {
            return null;
        }
        char[] cArray = new char[]{';'};
        for (String pattern : StringsKt.split$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null)) {
            char[] cArray2;
            List list = StringsKt.split$default((CharSequence)pattern, (char[])(cArray2 = new char[]{'='}), (boolean)false, (int)2, (int)2, null);
            if (list.size() != 2) continue;
            String patternId = ((Object)StringsKt.trim((CharSequence)((String)list.get(0)))).toString();
            String patternValue = ((Object)StringsKt.trim((CharSequence)((String)list.get(1)))).toString();
            if (!Intrinsics.areEqual((Object)id, (Object)patternId)) continue;
            try {
                return ToolWindowExtractorMode.valueOf((String)patternValue);
            }
            catch (IllegalArgumentException e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(BackendToolWindowModeProvider.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn((Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    public final String getSupportedToolWindowsList() {
        if (PlatformUtils.isCLion() || PlatformUtils.isAppCode()) {
            return SplitBackendBundle.INSTANCE.message("permission.dialog.toolWindow.access.tooltip.clion", new Object[0]);
        }
        return SplitBackendBundle.INSTANCE.message("permission.dialog.toolWindow.access.tooltip", new Object[0]);
    }

    private static final boolean getBackendToolWindowMode$lambda$0$0(String $id, ToolWindowExtractorEP it) {
        return Intrinsics.areEqual((Object)it.id, (Object)$id);
    }

    private static final boolean getBackendToolWindowMode$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

