/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.toolWindow;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.jetbrains.ide.model.uiautomation.BeTab;
import com.jetbrains.rd.ide.model.BeIdeaToolWindow;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rdserver.toolWindow.BackendServerToolWindowManager;
import com.jetbrains.rdserver.toolWindow.BackendToolWindow;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0001.B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u0019J\u0006\u0010&\u001a\u00020'J\u0014\u0010(\u001a\u00020'2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020'0*J\u000e\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020\u0019J\u0006\u0010-\u001a\u00020'R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001f\u0010\u0012\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001bR\u001e\u0010!\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001b\u00a8\u0006/"}, d2={"Lcom/jetbrains/rdserver/toolWindow/RemoteToolWindowEntry;", "", "model", "Lcom/jetbrains/rd/ide/model/BeIdeaToolWindow;", "toolWindow", "Lcom/intellij/openapi/wm/ex/ToolWindowEx;", "<init>", "(Lcom/jetbrains/rd/ide/model/BeIdeaToolWindow;Lcom/intellij/openapi/wm/ex/ToolWindowEx;)V", "getModel", "()Lcom/jetbrains/rd/ide/model/BeIdeaToolWindow;", "getToolWindow", "()Lcom/intellij/openapi/wm/ex/ToolWindowEx;", "lifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "contentToModel", "", "Lcom/intellij/ui/content/Content;", "Lcom/jetbrains/rdserver/toolWindow/RemoteToolWindowEntry$TabEntry;", "getContentToModel", "()Ljava/util/Map;", "showing", "", "getShowing", "()Z", "setShowing", "(Z)V", "value", "tabsUpdateScheduled", "getTabsUpdateScheduled", "selectedIndexUpdateScheduled", "getSelectedIndexUpdateScheduled", "scheduleTabUpdates", "updateTabs", "updateSelectedIndex", "tabUpdatesPerformed", "", "performInBatch", "action", "Lkotlin/Function0;", "updateShowingState", "state", "destroy", "TabEntry", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendToolWindowHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendToolWindowHost.kt\ncom/jetbrains/rdserver/toolWindow/RemoteToolWindowEntry\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,1090:1\n221#2,2:1091\n*S KotlinDebug\n*F\n+ 1 BackendToolWindowHost.kt\ncom/jetbrains/rdserver/toolWindow/RemoteToolWindowEntry\n*L\n705#1:1091,2\n*E\n"})
final class RemoteToolWindowEntry {
    @NotNull
    private final BeIdeaToolWindow model;
    @NotNull
    private final ToolWindowEx toolWindow;
    @NotNull
    private final LifetimeDefinition lifetimeDefinition;
    @NotNull
    private final Map<Content, TabEntry> contentToModel;
    private boolean showing;
    private boolean tabsUpdateScheduled;
    private boolean selectedIndexUpdateScheduled;

    public RemoteToolWindowEntry(@NotNull BeIdeaToolWindow model2, @NotNull ToolWindowEx toolWindow) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        this.model = model2;
        this.toolWindow = toolWindow;
        this.lifetimeDefinition = new LifetimeDefinition();
        this.contentToModel = new LinkedHashMap();
    }

    @NotNull
    public final BeIdeaToolWindow getModel() {
        return this.model;
    }

    @NotNull
    public final ToolWindowEx getToolWindow() {
        return this.toolWindow;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetimeDefinition.getLifetime();
    }

    @NotNull
    public final Map<Content, TabEntry> getContentToModel() {
        return this.contentToModel;
    }

    public final boolean getShowing() {
        return this.showing;
    }

    public final void setShowing(boolean bl) {
        this.showing = bl;
    }

    public final boolean getTabsUpdateScheduled() {
        return this.tabsUpdateScheduled;
    }

    public final boolean getSelectedIndexUpdateScheduled() {
        return this.selectedIndexUpdateScheduled;
    }

    public final boolean scheduleTabUpdates(boolean updateTabs, boolean updateSelectedIndex) {
        boolean wasScheduled = this.tabsUpdateScheduled || this.selectedIndexUpdateScheduled;
        this.tabsUpdateScheduled = this.tabsUpdateScheduled || updateTabs;
        this.selectedIndexUpdateScheduled = this.selectedIndexUpdateScheduled || updateSelectedIndex;
        boolean nowScheduled = this.tabsUpdateScheduled || this.selectedIndexUpdateScheduled;
        return !wasScheduled && nowScheduled;
    }

    public final void tabUpdatesPerformed() {
        this.tabsUpdateScheduled = false;
        this.selectedIndexUpdateScheduled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void performInBatch(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        IProperty $this$performInBatch_u24lambda_u240 = this.model.getToolWindow().getContent().getBatchUpdate();
        boolean bl = false;
        boolean oldValue = (Boolean)$this$performInBatch_u24lambda_u240.getValue();
        $this$performInBatch_u24lambda_u240.setValue((Object)true);
        try {
            action.invoke();
        }
        finally {
            $this$performInBatch_u24lambda_u240.setValue((Object)oldValue);
        }
    }

    public final void updateShowingState(boolean state) {
        if (state != this.showing) {
            this.showing = state;
            Project project = this.toolWindow.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            BackendServerToolWindowManager.Companion.getInstance(project).forceShowing((ToolWindow)this.toolWindow, state);
        }
    }

    public final void destroy() {
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.lifetimeDefinition, (boolean)false, (int)1, null);
        ToolWindowEx window = this.toolWindow;
        if (window instanceof BackendToolWindow) {
            Disposer.dispose((Disposable)((BackendToolWindow)window).getDisposable());
        }
        Map<Content, TabEntry> $this$forEach$iv = this.contentToModel;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Content, TabEntry>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Content, TabEntry> element$iv;
            Map.Entry<Content, TabEntry> entry = element$iv = iterator.next();
            boolean bl = false;
            TabEntry tabEntry = entry.getValue();
            LifetimeDefinition.terminate$default((LifetimeDefinition)tabEntry.getLifetimeDefinition(), (boolean)false, (int)1, null);
        }
        this.contentToModel.clear();
        this.updateShowingState(false);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdserver/toolWindow/RemoteToolWindowEntry$TabEntry;", "", "tab", "Lcom/jetbrains/ide/model/uiautomation/BeTab;", "lifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "<init>", "(Lcom/jetbrains/ide/model/uiautomation/BeTab;Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;)V", "getTab", "()Lcom/jetbrains/ide/model/uiautomation/BeTab;", "getLifetimeDefinition", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "intellij.platform.backend.split"})
    public static final class TabEntry {
        @NotNull
        private final BeTab tab;
        @NotNull
        private final LifetimeDefinition lifetimeDefinition;

        public TabEntry(@NotNull BeTab tab, @NotNull LifetimeDefinition lifetimeDefinition) {
            Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
            Intrinsics.checkNotNullParameter((Object)lifetimeDefinition, (String)"lifetimeDefinition");
            this.tab = tab;
            this.lifetimeDefinition = lifetimeDefinition;
        }

        @NotNull
        public final BeTab getTab() {
            return this.tab;
        }

        @NotNull
        public final LifetimeDefinition getLifetimeDefinition() {
            return this.lifetimeDefinition;
        }
    }
}

