/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.ui.ClientColorChooserService;
import com.intellij.ui.ColorPickerListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.picker.ColorListener;
import com.intellij.ui.picker.ColorPickerPopupCloseListener;
import com.intellij.util.concurrency.FutureResult;
import com.jetbrains.rd.actions.AccessLevelMarker;
import com.jetbrains.rd.actions.AccessRequirements;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.Protocol;
import com.jetbrains.rd.framework.base.RdExtBase;
import com.jetbrains.rd.ide.model.AbstractColor;
import com.jetbrains.rd.ide.model.ColorChooserModel;
import com.jetbrains.rd.ide.model.ColorChooserModel_GeneratedKt;
import com.jetbrains.rd.ide.model.ColorChooserParam;
import com.jetbrains.rd.ide.model.ColorChooserSession;
import com.jetbrains.rd.ide.model.ColorPickerType;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.platform.codeWithMe.permissions.FileAccessLevel;
import com.jetbrains.rd.platform.colors.ColorHostKt;
import com.jetbrains.rd.protocol.PermittedModalityProtocolEntities;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rdserver.SplitBackendBundle;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import com.jetbrains.rdserver.permissions.ClientPermissionManager;
import com.jetbrains.rdserver.permissions.PermissionInteractionManager;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006JN\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0013H\u0016JH\u0010\u0018\u001a\u00020\u00192\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00132\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016JH\u0010\u0018\u001a\u00020\u00192\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\n2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00132\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J>\u0010%\u001a\u00020\u00192\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\n2\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0012\u0010'\u001a\u00020\u00192\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\b\u0010(\u001a\u00020\u0013H\u0002J\b\u0010)\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/jetbrains/rdserver/ui/RemoteColorChooserService;", "Lcom/intellij/ui/ClientColorChooserService;", "Lcom/intellij/openapi/Disposable;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "protocol", "Lcom/jetbrains/rd/framework/Protocol;", "showDialog", "Ljava/awt/Color;", "project", "Lcom/intellij/openapi/project/Project;", "parent", "Ljava/awt/Component;", "caption", "", "preselectedColor", "enableOpacity", "", "listeners", "", "Lcom/intellij/ui/ColorPickerListener;", "opacityInPercent", "showPopup", "", "currentColor", "listener", "Lcom/intellij/ui/picker/ColorListener;", "location", "Lcom/intellij/ui/awt/RelativePoint;", "showAlpha", "showAlphaAsPercent", "popupCloseListener", "Lcom/intellij/ui/picker/ColorPickerPopupCloseListener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "showPopupInternal", "colorListener", "notifyNotPermitted", "colorChooserIsForbidden", "dispose", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nRemoteColorChooserService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteColorChooserService.kt\ncom/jetbrains/rdserver/ui/RemoteColorChooserService\n+ 2 RLifetime.kt\ncom/jetbrains/rd/util/lifetime/Lifetime$Companion\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n39#2,5:139\n1#3:144\n1915#4,2:145\n1915#4,2:147\n*S KotlinDebug\n*F\n+ 1 RemoteColorChooserService.kt\ncom/jetbrains/rdserver/ui/RemoteColorChooserService\n*L\n68#1:139,5\n54#1:145,2\n61#1:147,2\n*E\n"})
public final class RemoteColorChooserService
implements ClientColorChooserService,
Disposable {
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final Protocol protocol;

    public RemoteColorChooserService(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.protocol = RemoteSessionKt.getProtocol(this.session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Color showDialog(@Nullable Project project, @NotNull Component parent, @Nullable String caption, @Nullable Color preselectedColor, boolean enableOpacity, @NotNull List<? extends ColorPickerListener> listeners, boolean opacityInPercent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(listeners, (String)"listeners");
        ColorChooserModel colorChooserModel = ColorChooserModel_GeneratedKt.getColorChooserModel((IProtocol)((IProtocol)this.protocol));
        Color color = preselectedColor;
        ColorChooserParam param = new ColorChooserParam(caption, (AbstractColor)(color != null ? ColorHostKt.toModel((Color)color) : null), enableOpacity, opacityInPercent, ColorPickerType.DIALOG);
        ColorChooserSession colorChooserSession = new ColorChooserSession(null, param);
        Lifetime lifetime = LifetimeDisposableExKt.createLifetime((Disposable)this);
        colorChooserSession.getColorChanged().advise(lifetime, arg_0 -> RemoteColorChooserService.showDialog$lambda$0(listeners, arg_0));
        FutureResult result = new FutureResult();
        colorChooserSession.getClosed().advise(lifetime, arg_0 -> RemoteColorChooserService.showDialog$lambda$1(listeners, result, arg_0));
        colorChooserModel.getColorChooserSessions().add((Object)colorChooserSession);
        Lifetime.Companion this_$iv = Lifetime.Companion;
        boolean $i$f$using = false;
        LifetimeDefinition def$iv = new LifetimeDefinition();
        try {
            Lifetime modalityPumpingLifetime = def$iv.getLifetime();
            boolean bl = false;
            PermittedModalityProtocolEntities.Companion.getInstance().allowAnyModalityPumpingUnder(modalityPumpingLifetime, (RdExtBase)colorChooserModel);
            while (!result.isDone()) {
                this.protocol.getScheduler().flush();
                Thread.sleep(0L);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            LifetimeDefinition.terminate$default((LifetimeDefinition)def$iv, (boolean)false, (int)1, null);
        }
        colorChooserModel.getColorChooserSessions().remove((Object)colorChooserSession);
        return (Color)result.get();
    }

    public void showPopup(@Nullable Project project, @Nullable Color currentColor, @NotNull ColorListener listener2, @Nullable RelativePoint location, boolean showAlpha, boolean showAlphaAsPercent, @Nullable ColorPickerPopupCloseListener popupCloseListener) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.showPopupInternal(project, currentColor, listener2, showAlpha, false, popupCloseListener);
    }

    public void showPopup(@Nullable Project project, @Nullable Color currentColor, @Nullable Editor editor, @NotNull ColorListener listener2, boolean showAlpha, boolean showAlphaAsPercent, @Nullable ColorPickerPopupCloseListener popupCloseListener) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.showPopupInternal(project, currentColor, listener2, showAlpha, showAlphaAsPercent, popupCloseListener);
    }

    private final void showPopupInternal(Project project, Color currentColor, ColorListener colorListener, boolean enableOpacity, boolean opacityInPercent, ColorPickerPopupCloseListener popupCloseListener) {
        ColorChooserSession colorChooserSession;
        if (this.colorChooserIsForbidden()) {
            this.notifyNotPermitted(project);
            return;
        }
        Color color = currentColor;
        ColorChooserParam params = new ColorChooserParam(null, (AbstractColor)(color != null ? ColorHostKt.toModel((Color)color) : null), enableOpacity, opacityInPercent, ColorPickerType.POPUP);
        Lifetime lifetime = LifetimeDisposableExKt.createLifetime((Disposable)this);
        ColorChooserModel model2 = ColorChooserModel_GeneratedKt.getColorChooserModel((IProtocol)((IProtocol)this.protocol));
        Project project2 = project;
        ColorChooserSession $this$showPopupInternal_u24lambda_u240 = colorChooserSession = new ColorChooserSession((RdProjectId)(project2 != null ? ProjectUtilKt.getRdProjectId((Project)project2) : null), params);
        boolean bl = false;
        $this$showPopupInternal_u24lambda_u240.getColorChanged().advise(lifetime, arg_0 -> RemoteColorChooserService.showPopupInternal$lambda$0$0(colorListener, arg_0));
        $this$showPopupInternal_u24lambda_u240.getClosed().advise(lifetime, arg_0 -> RemoteColorChooserService.showPopupInternal$lambda$0$1(popupCloseListener, model2, $this$showPopupInternal_u24lambda_u240, arg_0));
        model2.getColorChooserSessions().add((Object)$this$showPopupInternal_u24lambda_u240);
    }

    private final void notifyNotPermitted(Project project) {
        Project project2;
        block3: {
            block2: {
                project2 = project;
                if (project2 == null) break block2;
                Project it = project2;
                boolean bl = false;
                ClientProjectSession clientProjectSession = this.session.getProjectSession(it);
                project2 = clientProjectSession;
                if (clientProjectSession != null) break block3;
            }
            return;
        }
        Project projectSession = project2;
        AccessLevelMarker[] accessLevelMarkerArray = new AccessLevelMarker[]{FileAccessLevel.FullAccess};
        AccessRequirements.Listed requirements = AccessRequirements.Companion.of(accessLevelMarkerArray);
        PermissionInteractionManager.Companion.notifyNotPermitted((ClientSession)projectSession, SplitBackendBundle.INSTANCE.message("action.show.color.picker.text", new Object[0]), (AccessRequirements)requirements);
    }

    private final boolean colorChooserIsForbidden() {
        return !ClientPermissionManager.Companion.getInstance(this.session).hasFileWriteAccess();
    }

    public void dispose() {
    }

    private static final Unit showDialog$lambda$0(List $listeners, AbstractColor rgbaColor) {
        AbstractColor abstractColor = rgbaColor;
        Color color = abstractColor != null ? ColorHostKt.toColor((AbstractColor)abstractColor) : null;
        Iterable $this$forEach$iv = $listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ColorPickerListener it = (ColorPickerListener)element$iv;
            boolean bl = false;
            it.colorChanged(color);
        }
        return Unit.INSTANCE;
    }

    private static final Unit showDialog$lambda$1(List $listeners, FutureResult $result, AbstractColor rgbaColor) {
        AbstractColor abstractColor = rgbaColor;
        Color color = abstractColor != null ? ColorHostKt.toColor((AbstractColor)abstractColor) : null;
        Iterable $this$forEach$iv = $listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ColorPickerListener it = (ColorPickerListener)element$iv;
            boolean bl = false;
            it.closed(color);
        }
        $result.set((Object)color);
        return Unit.INSTANCE;
    }

    private static final Unit showPopupInternal$lambda$0$0(ColorListener $colorListener, AbstractColor rgbaColor) {
        AbstractColor abstractColor = rgbaColor;
        $colorListener.colorChanged(abstractColor != null ? ColorHostKt.toColor((AbstractColor)abstractColor) : null, null);
        return Unit.INSTANCE;
    }

    private static final Unit showPopupInternal$lambda$0$1(ColorPickerPopupCloseListener $popupCloseListener, ColorChooserModel $model, ColorChooserSession $this_apply, AbstractColor abstractColor) {
        ColorPickerPopupCloseListener colorPickerPopupCloseListener = $popupCloseListener;
        if (colorPickerPopupCloseListener != null) {
            colorPickerPopupCloseListener.onPopupClosed();
        }
        $model.getColorChooserSessions().remove((Object)$this_apply);
        return Unit.INSTANCE;
    }
}

