/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui.converters;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.ui.converters.BeEditorHandler;
import com.jetbrains.rdserver.ui.converters.EditorImplHandler;
import com.jetbrains.rdserver.ui.converters.RdConverter;
import com.jetbrains.rdserver.ui.converters.TrackOptions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rdserver/ui/converters/EditorComponentImplConverter;", "Lcom/jetbrains/rdserver/ui/converters/RdConverter;", "Lcom/intellij/openapi/editor/impl/EditorComponentImpl;", "<init>", "()V", "convert", "Lcom/jetbrains/ide/model/uiautomation/BeControl;", "component", "trackOptions", "Lcom/jetbrains/rdserver/ui/converters/TrackOptions;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "convertEditor", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nEditorComponentImplConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorComponentImplConverter.kt\ncom/jetbrains/rdserver/ui/converters/EditorComponentImplConverter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,399:1\n23#2:400\n*S KotlinDebug\n*F\n+ 1 EditorComponentImplConverter.kt\ncom/jetbrains/rdserver/ui/converters/EditorComponentImplConverter\n*L\n53#1:400\n*E\n"})
public final class EditorComponentImplConverter
implements RdConverter<EditorComponentImpl> {
    @Override
    @NotNull
    public BeControl convert(@NotNull EditorComponentImpl component, @NotNull TrackOptions trackOptions, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)trackOptions, (String)"trackOptions");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        EditorImpl editorImpl = component.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editorImpl, (String)"getEditor(...)");
        return this.convertEditor((EditorEx)editorImpl, trackOptions, lifetime);
    }

    @NotNull
    public final BeControl convertEditor(@NotNull EditorEx editor, @NotNull TrackOptions trackOptions, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)trackOptions, (String)"trackOptions");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        ClientAppSession session = trackOptions.getSession();
        if (!session.isLocal()) {
            return new EditorImplHandler(trackOptions, lifetime).bind(session, editor);
        }
        EditorComponentImplConverter $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(EditorComponentImplConverter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("Cannot editor for local session=" + session, new Throwable());
        return new BeEditorHandler(trackOptions, lifetime).bind(editor);
    }
}

