/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui.converters;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016J(\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rdserver/ui/converters/EditorMarkupSynchronizer;", "Lcom/intellij/openapi/editor/impl/event/MarkupModelListener;", "from", "Lcom/intellij/openapi/editor/ex/EditorEx;", "to", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getTo", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "map", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "afterAdded", "", "highlighter", "afterRemoved", "attributesChanged", "renderersChanged", "", "fontStyleChanged", "foregroundColorChanged", "copy", "intellij.platform.backend.split"})
final class EditorMarkupSynchronizer
implements MarkupModelListener {
    @NotNull
    private final EditorEx to;
    @NotNull
    private final ConcurrentHashMap<RangeHighlighterEx, RangeHighlighterEx> map;

    public EditorMarkupSynchronizer(@NotNull EditorEx from, @NotNull EditorEx to, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.to = to;
        this.map = new ConcurrentHashMap();
        from.getMarkupModel().addMarkupModelListener(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null), (MarkupModelListener)this);
        from.getMarkupModel().processRangeHighlightersOverlappingWith(0, from.getDocument().getTextLength(), arg_0 -> EditorMarkupSynchronizer._init_$lambda$1(arg_0 -> EditorMarkupSynchronizer._init_$lambda$0(this, arg_0), arg_0));
    }

    @NotNull
    public final EditorEx getTo() {
        return this.to;
    }

    public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        this.copy(highlighter);
    }

    public void afterRemoved(@NotNull RangeHighlighterEx highlighter) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            RangeHighlighterEx rangeHighlighterEx = this.map.remove(highlighter);
            if (rangeHighlighterEx == null) break block0;
            rangeHighlighterEx.dispose();
        }
    }

    public void attributesChanged(@NotNull RangeHighlighterEx highlighter, boolean renderersChanged, boolean fontStyleChanged, boolean foregroundColorChanged) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        this.beforeRemoved(highlighter);
        this.afterAdded(highlighter);
    }

    private final void copy(RangeHighlighterEx highlighter) {
        if (!highlighter.isValid()) {
            return;
        }
        RangeHighlighter rangeHighlighter = this.to.getMarkupModel().addRangeHighlighter(highlighter.getTextAttributesKey(), highlighter.getStartOffset(), highlighter.getEndOffset(), highlighter.getLayer(), highlighter.getTargetArea());
        Intrinsics.checkNotNull((Object)rangeHighlighter, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.RangeHighlighterEx");
        RangeHighlighterEx copy = (RangeHighlighterEx)rangeHighlighter;
        copy.copyFrom(highlighter);
        HyperlinkInfo hyperlinkInfo = EditorHyperlinkSupport.getHyperlinkInfo((RangeHighlighter)((RangeHighlighter)highlighter));
        if (hyperlinkInfo != null) {
            HyperlinkInfo it = hyperlinkInfo;
            boolean bl = false;
            EditorHyperlinkSupport.get((Editor)((Editor)this.to)).createHyperlink((RangeHighlighter)copy, it);
        }
        ((Map)this.map).put(highlighter, copy);
    }

    private static final boolean _init_$lambda$0(EditorMarkupSynchronizer this$0, RangeHighlighterEx it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.copy(it);
        return true;
    }

    private static final boolean _init_$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

