/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui.converters;

import com.intellij.execution.console.ConsolePromptDecorator;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.ide.model.uiautomation.BeConsole;
import com.jetbrains.ide.model.uiautomation.BeConsolePrompt;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.ui.converters.ConverterRegistryKt;
import com.jetbrains.rdserver.ui.converters.RdConverter;
import com.jetbrains.rdserver.ui.converters.TrackOptions;
import com.jetbrains.rdserver.ui.converters.utils.ActionConverterUtil;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u0015\u001a\u00020\u0006*\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rdserver/ui/converters/LanguageConsoleViewImplConverter;", "Lcom/jetbrains/rdserver/ui/converters/RdConverter;", "Lcom/intellij/execution/console/LanguageConsoleImpl$ConsoleEditorsPanel;", "<init>", "()V", "convert", "Lcom/jetbrains/ide/model/uiautomation/BeControl;", "component", "trackOptions", "Lcom/jetbrains/rdserver/ui/converters/TrackOptions;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "bindPrompt", "", "Lcom/jetbrains/ide/model/uiautomation/BeConsole;", "console", "Lcom/intellij/execution/console/LanguageConsoleImpl;", "createPromptModel", "Lcom/jetbrains/ide/model/uiautomation/BeConsolePrompt;", "decorator", "Lcom/intellij/execution/console/ConsolePromptDecorator;", "toBeEditor", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.backend.split"})
public final class LanguageConsoleViewImplConverter
implements RdConverter<LanguageConsoleImpl.ConsoleEditorsPanel> {
    @Override
    @NotNull
    public BeControl convert(@NotNull LanguageConsoleImpl.ConsoleEditorsPanel component, @NotNull TrackOptions trackOptions, @NotNull Lifetime lifetime) {
        BeConsole beConsole;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)trackOptions, (String)"trackOptions");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        LanguageConsoleImpl console = component.getConsole();
        Editor editor = console.getEditor();
        EditorEx commandEditor = console.getConsoleEditor();
        UIUtil.markAsShowing((JComponent)((JComponent)component), (boolean)true);
        Editor editor2 = editor;
        Intrinsics.checkNotNull((Object)editor2);
        BeControl editorModel = this.toBeEditor(editor2, trackOptions, lifetime);
        BeControl commandEditorModel = this.toBeEditor((Editor)commandEditor, trackOptions, lifetime);
        JComponent jComponent = editor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        editorModel = ActionConverterUtil.Companion.wrapWithActionBehaviors(trackOptions, jComponent, editorModel, lifetime);
        JComponent jComponent2 = commandEditor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"getComponent(...)");
        commandEditorModel = ActionConverterUtil.Companion.wrapWithActionBehaviors(trackOptions, jComponent2, commandEditorModel, lifetime);
        BeConsole $this$convert_u24lambda_u240 = beConsole = new BeConsole(editorModel, commandEditorModel);
        boolean bl = false;
        this.bindPrompt($this$convert_u24lambda_u240, lifetime, console);
        return (BeControl)beConsole;
    }

    private final void bindPrompt(BeConsole $this$bindPrompt, Lifetime lifetime, LanguageConsoleImpl console) {
        ConsolePromptDecorator decorator = console.getConsolePromptDecorator();
        $this$bindPrompt.getPrompt().set((Object)this.createPromptModel(decorator));
        decorator.addChangeListener(arg_0 -> LanguageConsoleViewImplConverter.bindPrompt$lambda$0($this$bindPrompt, this, decorator, arg_0), LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null));
    }

    private final BeConsolePrompt createPromptModel(ConsolePromptDecorator decorator) {
        String mainPrompt = decorator.getMainPrompt();
        String innerPrompt = decorator.getIndentPrompt();
        TextAttributesKey textAttributesKey = decorator.getPromptAttributes().getAttributesKey();
        String attributes = textAttributesKey != null ? textAttributesKey.getExternalName() : null;
        return new BeConsolePrompt(mainPrompt, innerPrompt, attributes);
    }

    private final BeControl toBeEditor(Editor $this$toBeEditor, TrackOptions trackOptions, Lifetime lifetime) {
        JComponent jComponent = $this$toBeEditor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        return ConverterRegistryKt.toBeModel(jComponent, trackOptions, lifetime);
    }

    private static final void bindPrompt$lambda$0(BeConsole $this_bindPrompt, LanguageConsoleViewImplConverter this$0, ConsolePromptDecorator $decorator, ConsolePromptDecorator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this_bindPrompt.getPrompt().set((Object)this$0.createPromptModel($decorator));
    }
}

