/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui.dialogs;

import com.intellij.codeWithMe.ClientId;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.impl.DialogWrapperPeerFactoryImpl;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rdserver.ui.dialogs.BackendDialogWrapperPeerFactoryKt;
import com.jetbrains.rdserver.ui.dialogs.RdDialogWrapperPeer;
import java.awt.Component;
import java.awt.Window;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0005H\u0016J*\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0005H\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J*\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J*\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rdserver/ui/dialogs/BackendDialogWrapperPeerFactory;", "Lcom/intellij/openapi/ui/impl/DialogWrapperPeerFactoryImpl;", "<init>", "()V", "isLocalOrRemoteDevHost", "", "createPeer", "Lcom/intellij/openapi/ui/DialogWrapperPeer;", "wrapper", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "canBeParent", "ideModalityType", "Lcom/intellij/openapi/ui/DialogWrapper$IdeModalityType;", "parent", "Ljava/awt/Component;", "owner", "Ljava/awt/Window;", "createPeerForGuest", "intellij.platform.backend.split"})
public final class BackendDialogWrapperPeerFactory
extends DialogWrapperPeerFactoryImpl {
    private final boolean isLocalOrRemoteDevHost() {
        return ClientId.Companion.isCurrentlyUnderLocalId() || AppMode.isRemoteDevHost();
    }

    @NotNull
    public DialogWrapperPeer createPeer(@NotNull DialogWrapper wrapper, @Nullable Project project, boolean canBeParent) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        if (this.isLocalOrRemoteDevHost()) {
            DialogWrapperPeer dialogWrapperPeer = super.createPeer(wrapper, project, canBeParent);
            Intrinsics.checkNotNullExpressionValue((Object)dialogWrapperPeer, (String)"createPeer(...)");
            return dialogWrapperPeer;
        }
        return this.createPeerForGuest(wrapper, project, canBeParent, DialogWrapper.IdeModalityType.IDE);
    }

    @NotNull
    public DialogWrapperPeer createPeer(@NotNull DialogWrapper wrapper, boolean canBeParent) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        if (this.isLocalOrRemoteDevHost()) {
            DialogWrapperPeer dialogWrapperPeer = super.createPeer(wrapper, canBeParent);
            Intrinsics.checkNotNullExpressionValue((Object)dialogWrapperPeer, (String)"createPeer(...)");
            return dialogWrapperPeer;
        }
        return this.createPeerForGuest(wrapper, null, canBeParent, DialogWrapper.IdeModalityType.IDE);
    }

    @NotNull
    public DialogWrapperPeer createPeer(@NotNull DialogWrapper wrapper, @Nullable Project project, boolean canBeParent, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        Intrinsics.checkNotNullParameter((Object)ideModalityType, (String)"ideModalityType");
        if (this.isLocalOrRemoteDevHost()) {
            DialogWrapperPeer dialogWrapperPeer = super.createPeer(wrapper, project, canBeParent, ideModalityType);
            Intrinsics.checkNotNullExpressionValue((Object)dialogWrapperPeer, (String)"createPeer(...)");
            return dialogWrapperPeer;
        }
        return this.createPeerForGuest(wrapper, project, canBeParent, ideModalityType);
    }

    @NotNull
    public DialogWrapperPeer createPeer(@NotNull DialogWrapper wrapper, @NotNull Component parent, boolean canBeParent) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (this.isLocalOrRemoteDevHost()) {
            DialogWrapperPeer dialogWrapperPeer = super.createPeer(wrapper, parent, canBeParent);
            Intrinsics.checkNotNullExpressionValue((Object)dialogWrapperPeer, (String)"createPeer(...)");
            return dialogWrapperPeer;
        }
        return this.createPeerForGuest(wrapper, null, canBeParent, DialogWrapper.IdeModalityType.IDE);
    }

    @NotNull
    public DialogWrapperPeer createPeer(@NotNull DialogWrapper wrapper, boolean canBeParent, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        Intrinsics.checkNotNullParameter((Object)ideModalityType, (String)"ideModalityType");
        if (this.isLocalOrRemoteDevHost()) {
            DialogWrapperPeer dialogWrapperPeer = super.createPeer(wrapper, canBeParent, ideModalityType);
            Intrinsics.checkNotNullExpressionValue((Object)dialogWrapperPeer, (String)"createPeer(...)");
            return dialogWrapperPeer;
        }
        return this.createPeerForGuest(wrapper, null, canBeParent, ideModalityType);
    }

    @NotNull
    public DialogWrapperPeer createPeer(@NotNull DialogWrapper wrapper, @Nullable Window owner, boolean canBeParent, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        Intrinsics.checkNotNullParameter((Object)ideModalityType, (String)"ideModalityType");
        if (this.isLocalOrRemoteDevHost()) {
            DialogWrapperPeer dialogWrapperPeer = super.createPeer(wrapper, owner, canBeParent, ideModalityType);
            Intrinsics.checkNotNullExpressionValue((Object)dialogWrapperPeer, (String)"createPeer(...)");
            return dialogWrapperPeer;
        }
        return this.createPeerForGuest(wrapper, null, canBeParent, ideModalityType);
    }

    private final DialogWrapperPeer createPeerForGuest(DialogWrapper wrapper, Project project, boolean canBeParent, DialogWrapper.IdeModalityType ideModalityType) {
        ClientAppSession session = ClientSessionsUtil.getCurrentSessionOrNull((Application)ApplicationKt.getApplication());
        if (session == null) {
            BackendDialogWrapperPeerFactoryKt.access$getLogger$p().error("Cannot create dialog peer for guest " + ClientId.Companion.getCurrent() + ", falling back to default");
            DialogWrapperPeer dialogWrapperPeer = super.createPeer(wrapper, project, canBeParent, ideModalityType);
            Intrinsics.checkNotNullExpressionValue((Object)dialogWrapperPeer, (String)"createPeer(...)");
            return dialogWrapperPeer;
        }
        Project project2 = project;
        return new RdDialogWrapperPeer(session, (RdProjectId)(project2 != null ? ProjectUtilKt.getRdProjectId((Project)project2) : null), wrapper, ideModalityType);
    }
}

