/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui.dialogs;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.util.ClassExtension;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.ide.model.uiautomation.BeDialog;
import com.jetbrains.ide.model.uiautomation.ComponentId;
import com.jetbrains.ide.model.uiautomation.DialogComponentId;
import com.jetbrains.ide.model.uiautomation.UIAutomationInteractionModel;
import com.jetbrains.ide.model.uiautomation.UIAutomationInteractionModel_GeneratedKt;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.ide.model.ChangeReason;
import com.jetbrains.rd.ide.model.RdModalDialogStep;
import com.jetbrains.rd.ide.model.RdPatchItem;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.requests.ChangeScope;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchEngine;
import com.jetbrains.rd.platform.client.SessionUtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewableList;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rd.util.threading.SpinWait;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import com.jetbrains.rdserver.requests.BackendPatchEngineKt;
import com.jetbrains.rdserver.ui.dialogs.RdModalDialogAction;
import com.jetbrains.rdserver.ui.feelLuckUi.BackendFeelLuckyUiHelper;
import com.jetbrains.rdserver.ui.feelLuckUi.ModalDialogSilentOption;
import com.jetbrains.rdserver.ui.modalDialogs.DialogConverter;
import com.jetbrains.rdserver.ui.notification.BackendNotificationsHost;
import java.awt.Container;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001:\u0001\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J.\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJB\u0010\u0016\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00180\u0017*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0013H\u0002RV\u0010\u000f\u001aJ\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00130\u0013 \u0012*#\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00130\u00130\u0015\u00a2\u0006\u0002\b\u00140\u0010\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rdserver/ui/dialogs/HostDialogsRegistry;", "Lcom/intellij/openapi/util/ClassExtension;", "Lcom/jetbrains/rdserver/ui/dialogs/RdModalDialogAction;", "<init>", "()V", "show", "Ljava/util/concurrent/CompletableFuture;", "peer", "Lcom/intellij/openapi/ui/DialogWrapperPeer;", "dialogWrapper", "Lcom/intellij/openapi/ui/DialogWrapper;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "projectId", "Lcom/jetbrains/rd/ide/model/RdProjectId;", "beModalDialogs", "", "", "kotlin.jvm.PlatformType", "Lcom/jetbrains/ide/model/uiautomation/BeDialog;", "Lorg/jetbrains/annotations/NotNull;", "", "tryProcessModalDialog", "Lkotlin/Pair;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "dialog", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nHostDialogRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HostDialogRegistry.kt\ncom/jetbrains/rdserver/ui/dialogs/HostDialogsRegistry\n+ 2 SpinWait.kt\ncom/jetbrains/rd/util/threading/SpinWait$Companion\n+ 3 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,151:1\n14#2,7:152\n45#3,8:159\n13#4:167\n*S KotlinDebug\n*F\n+ 1 HostDialogRegistry.kt\ncom/jetbrains/rdserver/ui/dialogs/HostDialogsRegistry\n*L\n81#1:152,7\n133#1:159,8\n35#1:167\n*E\n"})
public final class HostDialogsRegistry
extends ClassExtension<RdModalDialogAction<?>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, BeDialog> beModalDialogs;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final HostDialogsRegistry instance;

    private HostDialogsRegistry() {
        super("com.intellij.rdserver.modalDialogAction");
        Map map2 = CollectionFactory.createSmallMemoryFootprintMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createSmallMemoryFootprintMap(...)");
        this.beModalDialogs = map2;
    }

    @Nullable
    public final CompletableFuture<?> show(@NotNull DialogWrapperPeer peer, @NotNull DialogWrapper dialogWrapper, @NotNull ClientAppSession session, @Nullable RdProjectId projectId) {
        Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
        Intrinsics.checkNotNullParameter((Object)dialogWrapper, (String)"dialogWrapper");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Container container = peer.getContentPane();
        if (container == null) {
            return CompletableFuture.completedFuture(null);
        }
        Container content = container;
        Disposable disposable = dialogWrapper.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        LifetimeDefinition lifetime = LifetimeDisposableExKt.defineNestedLifetime((Disposable)disposable);
        CompletableFuture actionCallback = new CompletableFuture();
        DialogConverter converter = new DialogConverter(session);
        BeDialog dialog = converter.tryGetDialogModel(peer, dialogWrapper, content instanceof JComponent ? (JComponent)content : null, lifetime, projectId, actionCallback);
        if (peer.isModal() && !session.isController()) {
            Pair<CompletableFuture<?>, Boolean> pair = this.tryProcessModalDialog(dialogWrapper, session, projectId, (Lifetime)lifetime, dialog);
            CompletableFuture future = (CompletableFuture)pair.component1();
            boolean success = (Boolean)pair.component2();
            if (!success) {
                dialogWrapper.disposeIfNeeded();
            }
            return future;
        }
        if (dialog == null) {
            dialogWrapper.disposeIfNeeded();
            BackendNotificationsHost.Companion.showNotImplementedNotification((ClientSession)session, "Dialog can not be converted to model");
            return CompletableFuture.completedFuture(null);
        }
        UIAutomationInteractionModel uiInteractionModel = UIAutomationInteractionModel_GeneratedKt.getUIAutomationInteractionModel((IProtocol)((IProtocol)RemoteSessionKt.getProtocol(session)));
        uiInteractionModel.getActiveDialogs().add((Object)dialog);
        SourceExKt.adviseUntil((ISource)((ISource)uiInteractionModel.getActiveDialogs()), (Lifetime)((Lifetime)lifetime), arg_0 -> HostDialogsRegistry.show$lambda$0(dialog, lifetime, actionCallback, arg_0));
        SpinWait.Companion this_$iv = SpinWait.Companion;
        boolean $i$f$spinUntil = false;
        long spins$iv = 0L;
        while (true) {
            boolean bl = false;
            IdeEventQueue.Companion.getInstance().flushQueue();
            if (actionCallback.isDone()) break;
            long l = spins$iv;
            spins$iv = l + 1L;
            if (l < 100L) {
                Thread.yield();
                continue;
            }
            Thread.sleep(spins$iv / (long)100);
        }
        return actionCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Pair<CompletableFuture<?>, Boolean> tryProcessModalDialog(DialogWrapper $this$tryProcessModalDialog, ClientAppSession session, RdProjectId projectId, Lifetime lifetime, BeDialog dialog) {
        ClientProjectSession clientProjectSession = SessionUtilKt.getProjectSession((ClientAppSession)session, (RdProjectId)projectId);
        ClientSession sessionForNotification = clientProjectSession != null ? (ClientSession)clientProjectSession : (ClientSession)session;
        ModalDialogSilentOption canClickOk = BackendFeelLuckyUiHelper.Companion.getInstance(session).maySkipModalDialog($this$tryProcessModalDialog);
        boolean success = false;
        success = true;
        switch (WhenMappings.$EnumSwitchMapping$0[canClickOk.ordinal()]) {
            case 1: {
                if ($this$tryProcessModalDialog.isOKActionEnabled()) {
                    RdModalDialogAction<?> modalDialogConverter = Companion.getModalDialogConverter($this$tryProcessModalDialog.getClass());
                    LOG.debug("Trying to show a modal dialog to a remote client, pressing ok");
                    modalDialogConverter.execute(lifetime, session, $this$tryProcessModalDialog);
                    $this$tryProcessModalDialog.clickDefaultButton();
                    if ($this$tryProcessModalDialog.isOK()) return TuplesKt.to(CompletableFuture.completedFuture(null), (Object)success);
                    $this$tryProcessModalDialog.close(1);
                    return TuplesKt.to(CompletableFuture.completedFuture(null), (Object)success);
                }
                success = false;
                BackendNotificationsHost.Companion.showNotImplementedNotification(sessionForNotification, "OK Action disabled in dialog, no silent apply");
                return TuplesKt.to(CompletableFuture.completedFuture(null), (Object)success);
            }
            case 2: {
                LOG.debug("Trying to show a modal dialog to a remote client, pressing cancel");
                $this$tryProcessModalDialog.doCancelAction();
                return TuplesKt.to(CompletableFuture.completedFuture(null), (Object)success);
            }
            case 3: {
                success = false;
                BackendNotificationsHost.Companion.showNotImplementedNotification(sessionForNotification, "Modal dialog is forbidden to execute");
                return TuplesKt.to(CompletableFuture.completedFuture(null), (Object)success);
            }
            case 4: {
                void $this$sendAccumulated_u24default$iv;
                String key;
                if (dialog == null) {
                    success = false;
                    BackendNotificationsHost.Companion.showNotImplementedNotification(sessionForNotification, "Dialog can not be converted to model");
                    return TuplesKt.to(CompletableFuture.completedFuture(null), (Object)success);
                }
                CharSequence modalDialogConverter = (CharSequence)dialog.getControlId().getValue();
                if (modalDialogConverter.length() == 0) {
                    boolean bl = false;
                    success = false;
                    BackendNotificationsHost.Companion.showNotImplementedNotification(sessionForNotification, "Dialog id is empty");
                }
                if (this.beModalDialogs.containsKey(key = (String)dialog.getControlId().getValue())) {
                    BeDialog beDialog = this.beModalDialogs.get(key);
                    Intrinsics.checkNotNull((Object)beDialog);
                    DialogConverter.Companion.applyModel(dialog, beDialog);
                    this.beModalDialogs.remove(key);
                    return TuplesKt.to(CompletableFuture.completedFuture(null), (Object)success);
                }
                RdModalDialogStep change = new RdModalDialogStep((ComponentId)new DialogComponentId(key));
                PatchEngine patchEngine = BackendPatchEngineKt.getEngine(session);
                String description$iv = "tryShowModal";
                ChangeReason changeReason$iv = ChangeReason.UNKNOWN;
                Class changeProducer$iv = null;
                boolean $i$f$sendAccumulated = false;
                AutoCloseable autoCloseable = (AutoCloseable)PatchEngine.openAccumulatingSession$default((PatchEngine)$this$sendAccumulated_u24default$iv, (boolean)true, (String)description$iv, (ChangeReason)changeReason$iv, changeProducer$iv, null, (int)16, null);
                Throwable throwable = null;
                try {
                    RdPatchEngine.ChangeAccumulatingSessionToken it$iv = (RdPatchEngine.ChangeAccumulatingSessionToken)autoCloseable;
                    boolean bl = false;
                    ChangeScope $this$tryProcessModalDialog_u24lambda_u241 = it$iv.getSession().getChangeScope();
                    boolean bl2 = false;
                    $this$tryProcessModalDialog_u24lambda_u241.pushFeature((RdPatchItem)change);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                UIAutomationInteractionModel_GeneratedKt.getUIAutomationInteractionModel((IProtocol)((IProtocol)RemoteSessionKt.getProtocol(session))).getModalCWMDialogs().add((Object)dialog);
                this.beModalDialogs.put(key, dialog);
                return TuplesKt.to(CompletableFuture.completedFuture(null), (Object)success);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    static /* synthetic */ Pair tryProcessModalDialog$default(HostDialogsRegistry hostDialogsRegistry, DialogWrapper dialogWrapper, ClientAppSession clientAppSession, RdProjectId rdProjectId, Lifetime lifetime, BeDialog beDialog, int n, Object object) {
        if ((n & 4) != 0) {
            lifetime = Lifetime.Companion.getEternal();
        }
        return hostDialogsRegistry.tryProcessModalDialog(dialogWrapper, clientAppSession, rdProjectId, lifetime, beDialog);
    }

    private static final boolean show$lambda$0(BeDialog $dialog, LifetimeDefinition $lifetime, CompletableFuture $actionCallback, IViewableList.Event it) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof IViewableList.Event.Remove && Intrinsics.areEqual((Object)((IViewableList.Event.Remove)it).getOldValue(), (Object)$dialog)) {
            LifetimeDefinition.terminate$default((LifetimeDefinition)$lifetime, (boolean)false, (int)1, null);
            $actionCallback.complete(null);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(HostDialogsRegistry.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        instance = new HostDialogsRegistry();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\f0\u000b\"\b\b\u0000\u0010\f*\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000fJ\u0006\u0010\u0010\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rdserver/ui/dialogs/HostDialogsRegistry$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "instance", "Lcom/jetbrains/rdserver/ui/dialogs/HostDialogsRegistry;", "getModalDialogConverter", "Lcom/jetbrains/rdserver/ui/dialogs/RdModalDialogAction;", "T", "Lcom/intellij/openapi/ui/DialogWrapper;", "clazz", "Ljava/lang/Class;", "getInstance", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final <T extends DialogWrapper> RdModalDialogAction<T> getModalDialogConverter(@NotNull Class<T> clazz) {
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Object object = instance.forClass(clazz);
            RdModalDialogAction rdModalDialogAction = object instanceof RdModalDialogAction ? (RdModalDialogAction)object : null;
            if (rdModalDialogAction == null) {
                throw new RuntimeException("Cannot find action for class " + clazz);
            }
            return rdModalDialogAction;
        }

        @NotNull
        public final HostDialogsRegistry getInstance() {
            return instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ModalDialogSilentOption.values().length];
            try {
                nArray[ModalDialogSilentOption.Accept.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModalDialogSilentOption.Cancel.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModalDialogSilentOption.SilentForbidden.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModalDialogSilentOption.Show.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

