/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui.idProviders;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.viewModel.extraction.ToolWindowExtractorMode;
import com.jetbrains.ide.model.uiautomation.ComponentId;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.ToolWindowComponentId;
import com.jetbrains.rd.platform.client.SessionUtilKt;
import com.jetbrains.rd.ui.ComponentIdProvider;
import com.jetbrains.rdserver.toolWindow.BackendToolWindowModeProvider;
import java.awt.Component;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J$\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdserver/ui/idProviders/ToolWindowComponentIdProvider;", "Lcom/jetbrains/rd/ui/ComponentIdProvider;", "Lcom/jetbrains/rd/ide/model/ToolWindowComponentId;", "<init>", "()V", "tryGetComponent", "Ljava/awt/Component;", "componentId", "Lcom/jetbrains/ide/model/uiautomation/ComponentId;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "parentComponent", "intellij.platform.backend.split"})
public final class ToolWindowComponentIdProvider
implements ComponentIdProvider<ToolWindowComponentId> {
    @Nullable
    public Component tryGetComponent(@NotNull ComponentId componentId, @NotNull ClientAppSession session, @Nullable Component parentComponent) {
        Component component;
        Intrinsics.checkNotNullParameter((Object)componentId, (String)"componentId");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (!(componentId instanceof ToolWindowComponentId)) {
            return null;
        }
        ClientProjectSession clientProjectSession = SessionUtilKt.getProjectSession((ClientAppSession)session, (RdProjectId)((ToolWindowComponentId)componentId).getProjectId());
        if (clientProjectSession == null) {
            return null;
        }
        ClientProjectSession projectSession = clientProjectSession;
        ToolWindowExtractorMode mode = BackendToolWindowModeProvider.INSTANCE.getBackendToolWindowMode(((ToolWindowComponentId)componentId).getId(), projectSession);
        if (mode == ToolWindowExtractorMode.FALLBACK && !Intrinsics.areEqual((Object)((ToolWindowComponentId)componentId).getId(), (Object)"Project")) {
            return null;
        }
        if (Intrinsics.areEqual((Object)((ToolWindowComponentId)componentId).getId(), (Object)"Services") && Registry.Companion.is("services.view.split.enabled")) {
            return null;
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(projectSession.getProject());
        ToolWindow toolWindow = toolWindowManager.getToolWindow(((ToolWindowComponentId)componentId).getId());
        if (toolWindow == null) {
            return null;
        }
        ToolWindow toolWindow2 = toolWindow;
        Object object = toolWindow2.getContentManager().getSelectedContent();
        if (object != null && (object = object.getComponent()) != null) {
            component = (Component)object;
        } else {
            JComponent jComponent = toolWindow2.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            component = jComponent;
        }
        return component;
    }
}

