/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lvcs.impl.ui;

import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.platform.lvcs.impl.ui.ActivityToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\"\u0010\u0006\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J9\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u000eH\u0000\u00a2\u0006\u0002\b\u0018J1\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u000eH\u0000\u00a2\u0006\u0002\b\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/platform/lvcs/impl/ui/ActivityToolWindow;", "", "<init>", "()V", "TOOLWINDOW_ID", "", "showTab", "", "project", "Lcom/intellij/openapi/project/Project;", "content", "Lcom/intellij/ui/content/Content;", "", "condition", "Lkotlin/Function1;", "getToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "registerToolWindow", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "onContentVisibilityChanged", "disposable", "Lcom/intellij/openapi/Disposable;", "onVisibilityChanged", "onContentVisibilityChanged$intellij_platform_lvcs_impl", "onOrientationChanged", "onOrientationChanged$intellij_platform_lvcs_impl", "intellij.platform.lvcs.impl"})
@SourceDebugExtension(value={"SMAP\nActivityToolWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActivityToolWindow.kt\ncom/intellij/platform/lvcs/impl/ui/ActivityToolWindow\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,90:1\n1401#2,2:91\n*S KotlinDebug\n*F\n+ 1 ActivityToolWindow.kt\ncom/intellij/platform/lvcs/impl/ui/ActivityToolWindow\n*L\n33#1:91,2\n*E\n"})
public final class ActivityToolWindow {
    @NotNull
    public static final ActivityToolWindow INSTANCE = new ActivityToolWindow();
    @NotNull
    private static final String TOOLWINDOW_ID = "Activity";

    private ActivityToolWindow() {
    }

    @JvmStatic
    public static final void showTab(@NotNull Project project, @NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        content.putUserData(Content.SIMPLIFIED_TAB_RENDERING_KEY, (Object)true);
        ToolWindow toolWindow = INSTANCE.getToolWindow(project);
        toolWindow.getContentManager().addContent(content);
        toolWindow.activate(() -> ActivityToolWindow.showTab$lambda$0(toolWindow, content));
    }

    public final boolean showTab(@NotNull Project project, @NotNull Function1<? super Content, Boolean> condition) {
        Object object;
        ToolWindow toolWindow;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(condition, (String)"condition");
            ToolWindow toolWindow2 = ToolWindowManager.Companion.getInstance(project).getToolWindow(TOOLWINDOW_ID);
            if (toolWindow2 == null) {
                return false;
            }
            toolWindow = toolWindow2;
            Content[] contentArray = toolWindow.getContentManager().getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
            Object[] $this$firstOrNull$iv = contentArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                if (!((Boolean)condition.invoke(element$iv)).booleanValue()) continue;
                object = element$iv;
                break block3;
            }
            object = null;
        }
        Content content = (Content)object;
        if (content == null) {
            return false;
        }
        Content content2 = content;
        toolWindow.activate(() -> ActivityToolWindow.showTab$lambda$1(toolWindow, content2));
        return true;
    }

    private final ToolWindow getToolWindow(Project project) {
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(TOOLWINDOW_ID);
        if (toolWindow == null) {
            toolWindow = this.registerToolWindow(toolWindowManager);
        }
        return toolWindow;
    }

    private final ToolWindow registerToolWindow(ToolWindowManager toolWindowManager) {
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.LEFT;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"LEFT");
        ToolWindowAnchor toolWindowAnchor2 = toolWindowAnchor;
        Supplier<String> supplier = LocalHistoryBundle.messagePointer("activity.toolwindow.title", new Object[0]);
        Icon icon = AllIcons.Vcs.History;
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(new RegisterToolWindowTask(TOOLWINDOW_ID, toolWindowAnchor2, null, false, true, false, false, null, icon, supplier, 236, null));
        ContentManagerWatcher.watchContentManager((ToolWindow)toolWindow, (ContentManager)toolWindow.getContentManager());
        return toolWindow;
    }

    public final void onContentVisibilityChanged$intellij_platform_lvcs_impl(@NotNull Project project, @NotNull Content content, @NotNull Disposable disposable, @NotNull Function1<? super Boolean, Unit> onVisibilityChanged) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(onVisibilityChanged, (String)"onVisibilityChanged");
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow(TOOLWINDOW_ID);
        if (toolWindow == null) {
            return;
        }
        ToolWindow activityToolWindow = toolWindow;
        Function0 isVisiblePredicate = () -> ActivityToolWindow.onContentVisibilityChanged$lambda$0(activityToolWindow, content);
        ContentManagerListener contentManagerListener2 = new ContentManagerListener(onVisibilityChanged, (Function0<Boolean>)isVisiblePredicate){
            final /* synthetic */ Function1<Boolean, Unit> $onVisibilityChanged;
            final /* synthetic */ Function0<Boolean> $isVisiblePredicate;
            {
                this.$onVisibilityChanged = $onVisibilityChanged;
                this.$isVisiblePredicate = $isVisiblePredicate;
            }

            public void selectionChanged(ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$onVisibilityChanged.invoke(this.$isVisiblePredicate.invoke());
            }
        };
        activityToolWindow.addContentManagerListener(contentManagerListener2);
        Disposer.register((Disposable)disposable, () -> ActivityToolWindow.onContentVisibilityChanged$lambda$1(activityToolWindow, contentManagerListener2));
        MessageBusConnection messageBusConnection = project.getMessageBus().connect(disposable);
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ToolWindowManagerListener(activityToolWindow, onVisibilityChanged, (Function0<Boolean>)isVisiblePredicate){
            final /* synthetic */ ToolWindow $activityToolWindow;
            final /* synthetic */ Function1<Boolean, Unit> $onVisibilityChanged;
            final /* synthetic */ Function0<Boolean> $isVisiblePredicate;
            {
                this.$activityToolWindow = $activityToolWindow;
                this.$onVisibilityChanged = $onVisibilityChanged;
                this.$isVisiblePredicate = $isVisiblePredicate;
            }

            public void stateChanged(ToolWindowManager toolWindowManager, ToolWindow toolWindow, ToolWindowManagerListener.ToolWindowManagerEventType changeType) {
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
                Intrinsics.checkNotNullParameter((Object)changeType, (String)"changeType");
                if (Intrinsics.areEqual((Object)toolWindow, (Object)this.$activityToolWindow)) {
                    this.$onVisibilityChanged.invoke(this.$isVisiblePredicate.invoke());
                }
            }
        });
        onVisibilityChanged.invoke(isVisiblePredicate.invoke());
    }

    public final void onOrientationChanged$intellij_platform_lvcs_impl(@NotNull Project project, @NotNull Disposable disposable, @NotNull Function1<? super Boolean, Unit> onOrientationChanged2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(onOrientationChanged2, (String)"onOrientationChanged");
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow(TOOLWINDOW_ID);
        if (toolWindow == null) {
            return;
        }
        ToolWindow activityToolWindow = toolWindow;
        Function0 isVerticalPredicate = () -> ActivityToolWindow.onOrientationChanged$lambda$0(activityToolWindow);
        MessageBusConnection messageBusConnection = project.getMessageBus().connect(disposable);
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ToolWindowManagerListener(onOrientationChanged2, (Function0<Boolean>)isVerticalPredicate){
            final /* synthetic */ Function1<Boolean, Unit> $onOrientationChanged;
            final /* synthetic */ Function0<Boolean> $isVerticalPredicate;
            {
                this.$onOrientationChanged = $onOrientationChanged;
                this.$isVerticalPredicate = $isVerticalPredicate;
            }

            public void stateChanged(ToolWindowManager toolWindowManager) {
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                this.$onOrientationChanged.invoke(this.$isVerticalPredicate.invoke());
            }
        });
        onOrientationChanged2.invoke(isVerticalPredicate.invoke());
    }

    private static final void showTab$lambda$0(ToolWindow $toolWindow, Content $content) {
        $toolWindow.getContentManager().setSelectedContent($content, true);
    }

    private static final void showTab$lambda$1(ToolWindow $toolWindow, Content $content) {
        $toolWindow.getContentManager().setSelectedContent($content, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean onContentVisibilityChanged$lambda$0(ToolWindow $activityToolWindow, Content $content) {
        if (!$activityToolWindow.isVisible()) return false;
        ContentManager contentManager = $activityToolWindow.getContentManagerIfCreated();
        if (!Intrinsics.areEqual((Object)(contentManager != null ? contentManager.getSelectedContent() : null), (Object)$content)) return false;
        return true;
    }

    private static final void onContentVisibilityChanged$lambda$1(ToolWindow $activityToolWindow, onContentVisibilityChanged.contentManagerListener.1 $contentManagerListener) {
        block0: {
            ContentManager contentManager = $activityToolWindow.getContentManagerIfCreated();
            if (contentManager == null) break block0;
            contentManager.removeContentManagerListener((ContentManagerListener)$contentManagerListener);
        }
    }

    private static final boolean onOrientationChanged$lambda$0(ToolWindow $activityToolWindow) {
        return !$activityToolWindow.getAnchor().isHorizontal();
    }
}

