/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.diagnostics;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.platform.diagnostics.IMetricConsumer;
import com.jetbrains.rd.platform.diagnostics.MetricUnit;
import com.jetbrains.rd.platform.diagnostics.StructuredLoggingKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\t\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\f2\b\u0010\u001e\u001a\u0004\u0018\u00010\tH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R#\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\r\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u0012\u0010\u0019\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001a\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rd/platform/diagnostics/AggregateConsumer;", "Lcom/jetbrains/rd/platform/diagnostics/IMetricConsumer;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "unit", "Lcom/jetbrains/rd/platform/diagnostics/MetricUnit;", "watchdogName", "", "aggregateFunc", "Lkotlin/Function2;", "", "metricName", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/diagnostic/Logger;Lcom/jetbrains/rd/platform/diagnostics/MetricUnit;Ljava/lang/String;Lkotlin/jvm/functions/Function2;Ljava/lang/String;)V", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "getUnit", "()Lcom/jetbrains/rd/platform/diagnostics/MetricUnit;", "getWatchdogName", "()Ljava/lang/String;", "getAggregateFunc", "()Lkotlin/jvm/functions/Function2;", "getMetricName", "currentValue", "Ljava/lang/Double;", "consumeValue", "", "value", "comment", "intellij.rd.platform"})
final class AggregateConsumer
implements IMetricConsumer {
    @NotNull
    private final Logger logger;
    @NotNull
    private final MetricUnit unit;
    @NotNull
    private final String watchdogName;
    @NotNull
    private final Function2<Double, Double, Double> aggregateFunc;
    @NotNull
    private final String metricName;
    @Nullable
    private Double currentValue;

    public AggregateConsumer(@NotNull Lifetime lifetime, @NotNull Logger logger, @NotNull MetricUnit unit, @NotNull String watchdogName, @NotNull Function2<? super Double, ? super Double, Double> aggregateFunc, @NotNull String metricName) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Intrinsics.checkNotNullParameter((Object)watchdogName, (String)"watchdogName");
        Intrinsics.checkNotNullParameter(aggregateFunc, (String)"aggregateFunc");
        Intrinsics.checkNotNullParameter((Object)metricName, (String)"metricName");
        this.logger = logger;
        this.unit = unit;
        this.watchdogName = watchdogName;
        this.aggregateFunc = aggregateFunc;
        this.metricName = metricName;
        lifetime.onTermination(() -> AggregateConsumer._init_$lambda$0(this));
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final MetricUnit getUnit() {
        return this.unit;
    }

    @NotNull
    public final String getWatchdogName() {
        return this.watchdogName;
    }

    @NotNull
    public final Function2<Double, Double, Double> getAggregateFunc() {
        return this.aggregateFunc;
    }

    @NotNull
    public final String getMetricName() {
        return this.metricName;
    }

    @Override
    public void consumeValue(double value, @Nullable String comment) {
        Double currentValue = this.currentValue;
        this.currentValue = currentValue == null ? Double.valueOf(value) : (Double)this.aggregateFunc.invoke((Object)currentValue, (Object)value);
    }

    private static final Unit _init_$lambda$0(AggregateConsumer this$0) {
        Double d = this$0.currentValue;
        if (d == null) {
            return Unit.INSTANCE;
        }
        double currentValue = d;
        StructuredLoggingKt.logMeasurement$default(this$0.logger, this$0.watchdogName + "." + this$0.metricName, (long)currentValue, this$0.unit, null, 8, null);
        return Unit.INSTANCE;
    }
}

