/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.llm.nes.events;

import com.intellij.code.provenance.DocumentChangesKind;
import com.intellij.code.provenance.core.ProvenanceEntry;
import com.intellij.code.provenance.core.events.mergeableEvents.DocumentChangesKt;
import com.intellij.code.provenance.core.llm.nes.RecentHistoryDocumentListener;
import com.intellij.code.provenance.core.llm.nes.events.RecentHistoryEntry;
import com.intellij.code.provenance.core.llm.nes.events.RecentHistoryEvent;
import com.intellij.code.provenance.core.llm.nes.events.RecentHistoryUserChanges;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001BL\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000b\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0001H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0018\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0018R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006."}, d2={"Lcom/intellij/code/provenance/core/llm/nes/events/RecentHistoryDocumentChanges;", "Lcom/intellij/code/provenance/core/llm/nes/events/RecentHistoryEvent$Mergeable;", "change", "Lcom/intellij/code/provenance/core/ProvenanceEntry$SingleDocumentChange;", "beforeHash", "", "afterHash", "oldFragment", "", "filePath", "", "Lcom/intellij/openapi/util/NlsSafe;", "time", "context", "Lcom/intellij/code/provenance/core/llm/nes/RecentHistoryDocumentListener$ContextInfo;", "kind", "Lcom/intellij/code/provenance/DocumentChangesKind;", "<init>", "(Lcom/intellij/code/provenance/core/ProvenanceEntry$SingleDocumentChange;JJLjava/lang/CharSequence;Ljava/lang/String;JLcom/intellij/code/provenance/core/llm/nes/RecentHistoryDocumentListener$ContextInfo;Lcom/intellij/code/provenance/DocumentChangesKind;)V", "getChange", "()Lcom/intellij/code/provenance/core/ProvenanceEntry$SingleDocumentChange;", "setChange", "(Lcom/intellij/code/provenance/core/ProvenanceEntry$SingleDocumentChange;)V", "getBeforeHash", "()J", "getAfterHash", "setAfterHash", "(J)V", "getOldFragment", "()Ljava/lang/CharSequence;", "getFilePath", "()Ljava/lang/String;", "getTime", "getContext", "()Lcom/intellij/code/provenance/core/llm/nes/RecentHistoryDocumentListener$ContextInfo;", "getKind", "()Lcom/intellij/code/provenance/DocumentChangesKind;", "entry", "Lcom/intellij/code/provenance/core/llm/nes/events/RecentHistoryEntry;", "getEntry", "()Lcom/intellij/code/provenance/core/llm/nes/events/RecentHistoryEntry;", "checkAfterMerge", "", "merge", "", "other", "intellij.code.provenance.core.llm"})
public final class RecentHistoryDocumentChanges
implements RecentHistoryEvent.Mergeable {
    @NotNull
    private ProvenanceEntry.SingleDocumentChange change;
    private final long beforeHash;
    private long afterHash;
    @NotNull
    private final CharSequence oldFragment;
    @NotNull
    private final String filePath;
    private final long time;
    @NotNull
    private final RecentHistoryDocumentListener.ContextInfo context;
    @NotNull
    private final DocumentChangesKind kind;

    public RecentHistoryDocumentChanges(@NotNull ProvenanceEntry.SingleDocumentChange change, long beforeHash, long afterHash, @NotNull CharSequence oldFragment, @NotNull String filePath, long time, @NotNull RecentHistoryDocumentListener.ContextInfo context, @NotNull DocumentChangesKind kind) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        Intrinsics.checkNotNullParameter((Object)oldFragment, (String)"oldFragment");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        this.change = change;
        this.beforeHash = beforeHash;
        this.afterHash = afterHash;
        this.oldFragment = oldFragment;
        this.filePath = filePath;
        this.time = time;
        this.context = context;
        this.kind = kind;
    }

    @NotNull
    public final ProvenanceEntry.SingleDocumentChange getChange() {
        return this.change;
    }

    public final void setChange(@NotNull ProvenanceEntry.SingleDocumentChange singleDocumentChange) {
        Intrinsics.checkNotNullParameter((Object)singleDocumentChange, (String)"<set-?>");
        this.change = singleDocumentChange;
    }

    public final long getBeforeHash() {
        return this.beforeHash;
    }

    public final long getAfterHash() {
        return this.afterHash;
    }

    public final void setAfterHash(long l) {
        this.afterHash = l;
    }

    @NotNull
    public final CharSequence getOldFragment() {
        return this.oldFragment;
    }

    @NotNull
    public final String getFilePath() {
        return this.filePath;
    }

    public final long getTime() {
        return this.time;
    }

    @NotNull
    public final RecentHistoryDocumentListener.ContextInfo getContext() {
        return this.context;
    }

    @NotNull
    public final DocumentChangesKind getKind() {
        return this.kind;
    }

    @Override
    @NotNull
    public RecentHistoryEntry getEntry() {
        return new RecentHistoryUserChanges(this.filePath, this.change.getOffset(), ((Object)this.oldFragment).toString(), ((Object)this.change.getNewFragment()).toString(), 0L, 0L, this.time, this.context.getContextStartLine(), this.context.getContextStartOffset(), this.context.getContextEndOffset(), ((Object)this.context.getContextBefore()).toString(), ((Object)this.context.getContextAfter()).toString());
    }

    private final void checkAfterMerge() {
        boolean bl;
        boolean bl2 = bl = this.oldFragment.length() == 0 && this.change.getOldLength() == 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @Override
    public boolean merge(@NotNull RecentHistoryEvent.Mergeable other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof RecentHistoryDocumentChanges)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.filePath, (Object)((RecentHistoryDocumentChanges)other).filePath)) {
            return false;
        }
        if (this.kind != DocumentChangesKind.TYPING || ((RecentHistoryDocumentChanges)other).kind != DocumentChangesKind.TYPING) {
            return false;
        }
        if (this.change.getOldLength() > 0 || ((RecentHistoryDocumentChanges)other).change.getOldLength() > 0) {
            return false;
        }
        if (this.change.getOffset() + this.change.getNewFragment().length() != ((RecentHistoryDocumentChanges)other).change.getOffset()) {
            return false;
        }
        if (StringsKt.contains$default((CharSequence)((RecentHistoryDocumentChanges)other).change.getNewFragment(), (char)'\n', (boolean)false, (int)2, null)) {
            return false;
        }
        List newChanges = DocumentChangesKt.addChange((List)CollectionsKt.listOf((Object)this.change), (ProvenanceEntry.SingleDocumentChange)((RecentHistoryDocumentChanges)other).change);
        if (newChanges.size() > 1) {
            return false;
        }
        this.change = (ProvenanceEntry.SingleDocumentChange)CollectionsKt.single((List)newChanges);
        this.afterHash = ((RecentHistoryDocumentChanges)other).afterHash;
        this.checkAfterMerge();
        return true;
    }
}

