/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.UtilKt;
import org.jetbrains.plugins.groovy.annotator.intentions.AddParenthesesToLambdaParameterIntention;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GrRemoveModifierFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GrArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/GroovyAnnotator30;", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "<init>", "(Lcom/intellij/lang/annotation/AnnotationHolder;)V", "visitModifierList", "", "modifierList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/GrModifierList;", "visitArrayInitializer", "arrayInitializer", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrArrayInitializer;", "checkDefaultModifier", "visitLambdaExpression", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrLambdaExpression;", "visitVariableDeclaration", "variableDeclaration", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrVariableDeclaration;", "checkSingleArgumentLambda", "lambda", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nGroovyAnnotator30.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroovyAnnotator30.kt\norg/jetbrains/plugins/groovy/annotator/GroovyAnnotator30\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1915#2,2:94\n*S KotlinDebug\n*F\n+ 1 GroovyAnnotator30.kt\norg/jetbrains/plugins/groovy/annotator/GroovyAnnotator30\n*L\n41#1:94,2\n*E\n"})
public final class GroovyAnnotator30
extends GroovyElementVisitor {
    @NotNull
    private final AnnotationHolder holder;

    public GroovyAnnotator30(@NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    @Override
    public void visitModifierList(@NotNull GrModifierList modifierList) {
        Intrinsics.checkNotNullParameter((Object)modifierList, (String)"modifierList");
        this.checkDefaultModifier(modifierList);
    }

    @Override
    public void visitArrayInitializer(@NotNull GrArrayInitializer arrayInitializer) {
        Intrinsics.checkNotNullParameter((Object)arrayInitializer, (String)"arrayInitializer");
        List<GrExpression> list = arrayInitializer.getExpressions();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getExpressions(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GrExpression it = (GrExpression)element$iv;
            boolean bl = false;
            if (!(it instanceof GrClosableBlock)) continue;
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("closures.are.not.allowed.in.array.initializer", new Object[0])).range((PsiElement)it).create();
        }
    }

    private final void checkDefaultModifier(GrModifierList modifierList) {
        block6: {
            PsiElement modifier;
            block5: {
                PsiElement psiElement = modifierList.getModifier("default");
                if (psiElement == null) {
                    return;
                }
                modifier = psiElement;
                PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)modifier, PsiClass.class);
                if (psiClass == null) {
                    return;
                }
                PsiClass parentClass = psiClass;
                if (!parentClass.isInterface()) break block5;
                GrTypeDefinition grTypeDefinition = parentClass instanceof GrTypeDefinition ? (GrTypeDefinition)parentClass : null;
                boolean bl = grTypeDefinition != null ? grTypeDefinition.isTrait() : false;
                if (!bl) break block6;
            }
            String string = GroovyBundle.message("illegal.default.modifier", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            AnnotationBuilder annotationBuilder = this.holder.newAnnotation(HighlightSeverity.WARNING, message).range(modifier);
            Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder, (String)"range(...)");
            AnnotationBuilder builder = annotationBuilder;
            LocalQuickFix localQuickFix = (LocalQuickFix)new GrRemoveModifierFix("default", GroovyBundle.message("illegal.default.modifier.fix", new Object[0]));
            TextRange textRange = modifier.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            builder = UtilKt.registerLocalFix(builder, localQuickFix, modifier, message, ProblemHighlightType.WARNING, textRange);
            builder.create();
        }
    }

    @Override
    public void visitLambdaExpression(@NotNull GrLambdaExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.checkSingleArgumentLambda(expression);
        super.visitLambdaExpression(expression);
    }

    @Override
    public void visitVariableDeclaration(@NotNull GrVariableDeclaration variableDeclaration) {
        Intrinsics.checkNotNullParameter((Object)variableDeclaration, (String)"variableDeclaration");
        super.visitVariableDeclaration(variableDeclaration);
        String string = GroovyBundle.message("tuple.declaration.should.end.with.def.or.var.modifier", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Object[] objectArray = new IElementType[]{GroovyElementTypes.KW_DEF, GroovyElementTypes.KW_VAR};
        UtilKt.checkTupleVariableIsNotAllowed(variableDeclaration, this.holder, string, SetsKt.setOf((Object[])objectArray));
    }

    private final void checkSingleArgumentLambda(GrLambdaExpression lambda) {
        GrParameterList grParameterList = lambda.getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)grParameterList, (String)"getParameterList(...)");
        GrParameterList parameterList = grParameterList;
        if (parameterList.getLParen() != null) {
            return;
        }
        PsiElement parent = lambda.getParent();
        if (parent instanceof GrAssignmentExpression || parent instanceof GrVariable || parent instanceof GrParenthesizedExpression) {
            return;
        }
        if (parent instanceof GrArgumentList && ((GrArgumentList)parent).getParent() instanceof GrMethodCallExpression) {
            return;
        }
        this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("illegal.single.argument.lambda", new Object[0])).range((PsiElement)parameterList).withFix((CommonIntentionAction)new AddParenthesesToLambdaParameterIntention(lambda)).create();
    }
}

