/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.typing;

import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrSpreadArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0003H\u0014J\u0018\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J\n\u0010\u0018\u001a\u00020\u0011H\u0096\u0080\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/groovy/lang/typing/ListLiteralType;", "Lorg/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType;", "expressions", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "context", "Lcom/intellij/psi/PsiElement;", "<init>", "(Ljava/util/List;Lcom/intellij/psi/PsiElement;)V", "literal", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/GrListOrMap;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/GrListOrMap;)V", "getExpressions", "()Ljava/util/List;", "isValid", "", "getJavaClassName", "", "inferComponents", "Lcom/intellij/psi/PsiType;", "myComponentTypes", "doGetComponentTypes", "", "initializer", "toString", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nListLiteralType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListLiteralType.kt\norg/jetbrains/plugins/groovy/lang/typing/ListLiteralType\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1391#2:52\n1480#2,5:53\n1#3:58\n*S KotlinDebug\n*F\n+ 1 ListLiteralType.kt\norg/jetbrains/plugins/groovy/lang/typing/ListLiteralType\n*L\n33#1:52\n33#1:53,5\n*E\n"})
public class ListLiteralType
extends GrTupleType {
    @NotNull
    private final List<GrExpression> expressions;
    @NotNull
    private final PsiElement context;
    @NotNull
    private final List<PsiType> myComponentTypes;

    /*
     * WARNING - void declaration
     */
    public ListLiteralType(@NotNull List<? extends GrExpression> expressions, @NotNull PsiElement context) {
        List list;
        block2: {
            void $this$flatMapTo$iv$iv;
            void $this$myComponentTypes_u24lambda_u240;
            Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context);
            this.expressions = expressions;
            this.context = context;
            ListLiteralType listLiteralType = this;
            ListLiteralType listLiteralType2 = this;
            boolean bl = false;
            Iterable $this$flatMap$iv = $this$myComponentTypes_u24lambda_u240.expressions;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                GrExpression it = (GrExpression)element$iv$iv;
                boolean bl2 = false;
                Collection<PsiType> collection = super.doGetComponentTypes(it);
                if (collection == null) {
                    list = CollectionsKt.emptyList();
                    break block2;
                }
                Iterable list$iv$iv = collection;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        listLiteralType2.myComponentTypes = list;
    }

    @NotNull
    public final List<GrExpression> getExpressions() {
        return this.expressions;
    }

    public ListLiteralType(@NotNull GrListOrMap literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        GrExpression[] grExpressionArray = literal.getInitializers();
        Intrinsics.checkNotNullExpressionValue((Object)grExpressionArray, (String)"getInitializers(...)");
        this(ArraysKt.toList((Object[])grExpressionArray), (PsiElement)literal);
    }

    public boolean isValid() {
        return this.context.isValid();
    }

    @Override
    @NotNull
    protected String getJavaClassName() {
        return CompileStaticUtil.isCompileStatic(this.context) ? "java.util.List" : "java.util.ArrayList";
    }

    @Override
    @NotNull
    protected List<PsiType> inferComponents() {
        return this.myComponentTypes;
    }

    private final Collection<PsiType> doGetComponentTypes(GrExpression initializer) {
        return (Collection)RecursionManager.doPreventingRecursion((Object)initializer, (boolean)false, () -> ListLiteralType.doGetComponentTypes$lambda$0(initializer));
    }

    @NotNull
    public String toString() {
        String string = this.context.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final List doGetComponentTypes$lambda$0(GrExpression $initializer) {
        List list;
        if ($initializer instanceof GrSpreadArgument) {
            PsiType psiType = ((GrSpreadArgument)$initializer).getArgument().getType();
            GrTupleType grTupleType = psiType instanceof GrTupleType ? (GrTupleType)psiType : null;
            list = grTupleType != null ? grTupleType.getComponentTypes() : null;
        } else {
            PsiType psiType = TypesUtil.boxPrimitiveType($initializer.getType(), $initializer.getManager(), $initializer.getResolveScope());
            if (psiType != null) {
                PsiType it = psiType;
                boolean bl = false;
                list = CollectionsKt.listOf((Object)it);
            } else {
                list = null;
            }
        }
        return list;
    }
}

