/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.springloaded;

import com.intellij.debugger.PositionManager;
import com.intellij.debugger.PositionManagerFactory;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.springloaded.SpringLoadedPositionManager;

public final class SpringLoadedPositionManagerFactory
extends PositionManagerFactory {
    public static final Key<Boolean> FORCE_SPRINGLOADED = Key.create((String)"springloaded.debugger.force");

    public PositionManager createPositionManager(@NotNull DebugProcess process) {
        if (process == null) {
            SpringLoadedPositionManagerFactory.$$$reportNull$$$0(0);
        }
        return SpringLoadedPositionManagerFactory.usesSpringLoaded(process) ? new SpringLoadedPositionManager(process) : null;
    }

    private static boolean usesSpringLoaded(@NotNull DebugProcess process) {
        Boolean force;
        if (process == null) {
            SpringLoadedPositionManagerFactory.$$$reportNull$$$0(1);
        }
        if ((force = (Boolean)process.getProcessHandler().getUserData(FORCE_SPRINGLOADED)) == Boolean.TRUE) {
            return true;
        }
        if (((Boolean)ReadAction.compute(() -> {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)process.getProject());
            if (facade.findPackage("com.springsource.loaded") != null || facade.findPackage("org.springsource.loaded") != null) {
                return true;
            }
            return false;
        })).booleanValue()) {
            return true;
        }
        VirtualMachineProxy proxy = VirtualMachineProxy.getCurrent();
        return !proxy.classesByName("com.springsource.loaded.agent.SpringLoadedAgent").isEmpty() || !proxy.classesByName("org.springsource.loaded.agent.SpringLoadedAgent").isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "process";
        objectArray2[1] = "org/jetbrains/plugins/groovy/springloaded/SpringLoadedPositionManagerFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createPositionManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "usesSpringLoaded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

