/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.remotebrowser;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.util.Alarm;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.MessageTreeNode;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.dnd.MoveCopyPasteSupport;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebServerTreeBuilder
implements Disposable {
    private static final Logger LOG = Logger.getInstance(WebServerTreeBuilder.class);
    private static final Comparator<NodeDescriptor<?>> COMPARATOR = (o1, o2) -> {
        if (o1 instanceof MessageTreeNode) {
            return o2 instanceof MessageTreeNode ? ((MessageTreeNode)((Object)o1)).getMessage().compareTo(((MessageTreeNode)((Object)o2)).getMessage()) : -1;
        }
        if (o2 instanceof MessageTreeNode) {
            return 1;
        }
        ServerTreeNode n1 = (ServerTreeNode)((Object)o1);
        ServerTreeNode n2 = (ServerTreeNode)((Object)o2);
        if (n1.isDirectory() && !n2.isDirectory()) {
            return -1;
        }
        if (!n1.isDirectory() && n2.isDirectory()) {
            return 1;
        }
        return n1.getFileName().compareToIgnoreCase(n2.getFileName());
    };
    public static final int UPDATE_NODES_DELAY_MS = 100;
    private final Alarm myUpdateAlarm;
    private final StructureTreeModel<?> myModel;
    private final JTree myTree;

    public Set<Object> getSelectedElements() {
        return new HashSet<Object>(TreeUtil.collectSelectedUserObjects((JTree)this.myTree));
    }

    public void select(@Nullable ServerTreeNode selection) {
        TreeNode root;
        if (selection == null) {
            return;
        }
        try {
            root = (TreeNode)this.myModel.getInvoker().compute(() -> this.myModel.getRoot()).blockingGet(100);
        }
        catch (ExecutionException | TimeoutException e) {
            return;
        }
        if (root == null) {
            return;
        }
        DefaultMutableTreeNode cached = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)((DefaultMutableTreeNode)root), (Object)((Object)selection));
        if (cached != null) {
            TreeUtil.selectInTree((DefaultMutableTreeNode)cached, (boolean)true, (JTree)this.myTree);
        } else {
            this.myModel.getInvoker().invoke(() -> {
                ArrayDeque<TreeNode> toProcess = new ArrayDeque<TreeNode>();
                toProcess.add(this.myModel.getRoot());
                while (!toProcess.isEmpty()) {
                    TreeNode node = (TreeNode)toProcess.poll();
                    if (Objects.equals(((DefaultMutableTreeNode)node).getUserObject(), (Object)selection)) {
                        this.myModel.select(((DefaultMutableTreeNode)node).getUserObject(), this.myTree, i -> {});
                        continue;
                    }
                    for (TreeNode n : this.myModel.getChildren((Object)node)) {
                        if (!selection.getPath().path.contains(n.toString())) continue;
                        toProcess.add(n);
                    }
                }
            });
        }
    }

    public boolean isDisposed() {
        return false;
    }

    public void queueUpdate() {
        this.myModel.invalidateAsync();
    }

    public static WebServerTreeBuilder createInstance(@NotNull ServerTreeNode root, @NotNull JTree tree, @NotNull Disposable parent) {
        if (root == null) {
            WebServerTreeBuilder.$$$reportNull$$$0(0);
        }
        if (tree == null) {
            WebServerTreeBuilder.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            WebServerTreeBuilder.$$$reportNull$$$0(2);
        }
        StructureTreeModel structureTreeModel = new StructureTreeModel((AbstractTreeStructure)new SimpleTreeStructure.Impl((SimpleNode)root), null, Invoker.forBackgroundThreadWithoutReadAction((Disposable)parent), parent);
        structureTreeModel.setComparator(COMPARATOR);
        AsyncTreeModel model = new AsyncTreeModel((TreeModel)structureTreeModel, parent);
        tree.setModel((TreeModel)model);
        tree.getSelectionModel().setSelectionMode(4);
        return new WebServerTreeBuilder(tree, structureTreeModel, parent);
    }

    public WebServerTreeBuilder(JTree tree, StructureTreeModel structureTreeModel, Disposable parent) {
        this.myModel = structureTreeModel;
        this.myTree = tree;
        CopyPasteManager.getInstance().addContentChangedListener((CopyPasteManager.ContentChangedListener)new MoveCopyPasteSupport.RemoteHostCopyPasteListener(tree, this.myModel), (Disposable)this);
        this.myUpdateAlarm = new Alarm((JComponent)tree, parent);
    }

    public void refreshSubtree(final Collection<WebServerConfig.RemotePath> roots, final boolean resync, final boolean cleanTreeNodesCache, final WebServerConfig.RemotePath selectAfterRefresh) {
        ServerTreeNode root = this.getRoot();
        if (root == null) {
            return;
        }
        new Task.Backgroundable(root.getProject(), WDBundle.message("refreshing.remote.files", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (cleanTreeNodesCache || resync) {
                    try {
                        ServerTreeNode root = WebServerTreeBuilder.this.getRoot();
                        if (root == null) {
                            return;
                        }
                        RemoteConnection connection = root.getOpenRemoteConnection();
                        if (connection == null) {
                            return;
                        }
                        connection.executeServerOperation((ThrowableRunnable<? extends FileSystemException>)((ThrowableRunnable)() -> {
                            for (WebServerConfig.RemotePath root1 : roots) {
                                indicator.checkCanceled();
                                ServerTreeNode node = WebServerTreeBuilder.this.findNode(root1);
                                if (node == null) continue;
                                if (resync && node.getFileObject() != null) {
                                    node.getFileObject().refresh();
                                }
                                if (!cleanTreeNodesCache) continue;
                                Ref objects = new Ref();
                                ApplicationManager.getApplication().invokeAndWait(() -> objects.set((Object)TreeUtil.collectExpandedUserObjects((JTree)WebServerTreeBuilder.this.myTree)));
                                node.reloadNecessaryDescendants(true, true, (List)objects.get());
                            }
                        }), indicator);
                    }
                    catch (FileSystemException e) {
                        LOG.warn((Throwable)e);
                    }
                }
                for (WebServerConfig.RemotePath root : roots) {
                    indicator.checkCanceled();
                    WebServerTreeBuilder.this.myModel.getInvoker().invoke(() -> {
                        ServerTreeNode rootNode = WebServerTreeBuilder.this.getRoot();
                        if (rootNode == null) {
                            return;
                        }
                        ServerTreeNode toUpdate = rootNode.createForSelection(root);
                        if (toUpdate != null) {
                            WebServerTreeBuilder.this.myModel.invalidate((Object)toUpdate, true);
                        }
                    });
                }
                if (selectAfterRefresh != null) {
                    if (ApplicationManager.getApplication().isDispatchThread()) {
                        WebServerTreeBuilder.this.selectPath(selectAfterRefresh);
                    } else {
                        ApplicationManager.getApplication().invokeLater(() -> WebServerTreeBuilder.this.selectPath(selectAfterRefresh));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/WebServerTreeBuilder$1", "run"));
            }
        }.queue();
    }

    @Nullable
    public ServerTreeNode findNode(WebServerConfig.RemotePath path) {
        TreeNode root1;
        ServerTreeNode root = this.getRoot();
        if (root == null) {
            return null;
        }
        ServerTreeNode forSelection = root.createForSelection(path);
        try {
            root1 = (TreeNode)this.myModel.getInvoker().compute(() -> this.myModel.getRoot()).blockingGet(100);
        }
        catch (ExecutionException | TimeoutException e) {
            return null;
        }
        if (root1 == null) {
            return null;
        }
        DefaultMutableTreeNode node = forSelection == null ? null : TreeUtil.findNodeWithObject((DefaultMutableTreeNode)((DefaultMutableTreeNode)root1), (Object)((Object)forSelection));
        return node != null ? (ServerTreeNode)((Object)node.getUserObject()) : null;
    }

    public void selectPath(WebServerConfig.RemotePath path) {
        ServerTreeNode root = this.getRoot();
        if (root == null) {
            return;
        }
        @Nullable ServerTreeNode selection = root.createForSelection(path);
        if (selection != null) {
            root.reloadNecessaryDescendantsAndUpdate(false, false, TreeUtil.collectExpandedUserObjects((JTree)this.myTree), () -> ApplicationManager.getApplication().invokeLater(() -> this.select(selection)));
        }
    }

    @Nullable
    public ServerTreeNode getRoot() {
        Object root;
        if (EDT.isCurrentThreadEdt()) {
            root = this.myTree.getModel().getRoot();
        } else {
            try {
                root = this.myModel.getInvoker().compute(() -> this.myModel.getRoot()).blockingGet(100);
            }
            catch (ExecutionException | TimeoutException e) {
                root = null;
            }
        }
        return (ServerTreeNode)((Object)TreeUtil.getUserObject(ServerTreeNode.class, (Object)root));
    }

    public void refreshWhenIdle(final ServerTreeNode node) {
        Runnable updater = new Runnable(){

            @Override
            public void run() {
                try {
                    WebServerTreeBuilder.this.refreshSubtree(Collections.singletonList(node.getPath()), false, false, null);
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                finally {
                    WebServerTreeBuilder.this.myUpdateAlarm.cancelRequest((Runnable)this);
                }
            }
        };
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myUpdateAlarm.isDisposed()) {
                return;
            }
            this.myUpdateAlarm.addComponentRequest(updater, 100);
        });
    }

    public void dispose() {
        this.myUpdateAlarm.cancelAllRequests();
    }

    public void refreshRoot() {
        ServerTreeNode root = this.getRoot();
        if (root == null) {
            return;
        }
        root.invalidate();
        root.refreshContext();
        root.reloadNecessaryDescendantsAndUpdate(true, true, TreeUtil.collectExpandedUserObjects((JTree)this.myTree), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "root";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "tree";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/plugins/webDeployment/ui/remotebrowser/WebServerTreeBuilder";
        objectArray[2] = "createInstance";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

