/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.bigquery;

import com.intellij.database.console.GridColumnsManager;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.dialects.bigquery.BQTypeNode;
import com.intellij.database.dialects.bigquery.BigQueryGridColumnsManagerKt;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.io.JsonUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ+\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\r2\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0003H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003H\u0016\u00a2\u0006\u0002\u0010\u0018R\u0018\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/dialects/bigquery/BigQueryGridColumnsManager;", "Lcom/intellij/database/console/GridColumnsManager;", "columns", "", "Lcom/intellij/database/datagrid/GridColumn;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "([Lcom/intellij/database/datagrid/GridColumn;Lcom/intellij/openapi/project/Project;)V", "expandedColumns", "[Lcom/intellij/database/datagrid/GridColumn;", "columnToExpandedColumn", "", "", "columnToTypeStructure", "Lcom/intellij/database/dialects/bigquery/BQTypeNode;", "createRows", "", "Lcom/intellij/database/datagrid/GridRow;", "realIdx", "data", "", "(I[Ljava/lang/Object;)Ljava/util/List;", "getColumns", "()[Lcom/intellij/database/datagrid/GridColumn;", "intellij.database.dialects.bigquery.ex"})
@SourceDebugExtension(value={"SMAP\nBigQueryGridColumnsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BigQueryGridColumnsManager.kt\ncom/intellij/database/dialects/bigquery/BigQueryGridColumnsManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,231:1\n14125#2,2:232\n14127#2:237\n14125#2,3:238\n1661#3,3:234\n*S KotlinDebug\n*F\n+ 1 BigQueryGridColumnsManager.kt\ncom/intellij/database/dialects/bigquery/BigQueryGridColumnsManager\n*L\n48#1:232,2\n48#1:237\n71#1:238,3\n59#1:234,3\n*E\n"})
final class BigQueryGridColumnsManager
implements GridColumnsManager {
    @NotNull
    private final GridColumn[] expandedColumns;
    @NotNull
    private final Map<Integer, Integer> columnToExpandedColumn;
    @NotNull
    private final Map<Integer, BQTypeNode> columnToTypeStructure;

    /*
     * WARNING - void declaration
     */
    public BigQueryGridColumnsManager(@NotNull GridColumn[] columns, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.columnToExpandedColumn = new LinkedHashMap();
        this.columnToTypeStructure = new LinkedHashMap();
        List newColumns = new ArrayList();
        GridColumn[] $this$forEachIndexed$iv = columns;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (GridColumn item$iv : $this$forEachIndexed$iv) {
            void $this$mapTo$iv;
            BQTypeNode root;
            void column;
            int n = index$iv++;
            GridColumn gridColumn = item$iv;
            int index = n;
            boolean bl = false;
            this.columnToExpandedColumn.put(index, newColumns.size());
            String typeName = column.getTypeName();
            BQTypeNode bQTypeNode = root = typeName != null && BigQueryGridColumnsManagerKt.access$isStructType(typeName) ? BigQueryGridColumnsManagerKt.access$parseTypeStructure(project, typeName) : null;
            if (root == null) {
                DataConsumer.Column column2 = DataConsumer.Column.copy((GridColumn)column, (int)newColumns.size());
                Intrinsics.checkNotNullExpressionValue((Object)column2, (String)"copy(...)");
                newColumns.add(column2);
                continue;
            }
            this.columnToTypeStructure.put(index, root);
            Object object = BigQueryGridColumnsManagerKt.access$columnDefinitionsTraverser(root).traverse(TreeTraversal.LEAVES_DFS);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"traverse(...)");
            object = (Iterable)object;
            Collection destination$iv = newColumns;
            boolean $i$f$mapTo = false;
            for (Object item$iv2 : $this$mapTo$iv) {
                Pair pair = (Pair)item$iv2;
                Collection collection = destination$iv;
                boolean bl2 = false;
                String name2 = (String)pair.component1();
                BQTypeNode type = (BQTypeNode)pair.component2();
                int n2 = newColumns.size();
                String string = column.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                collection.add(DataConsumer.Column.copy((GridColumn)column, (int)n2, (String)BigQueryGridColumnsManagerKt.appendName(string, name2), (int)column.getType(), (String)type.toString()));
            }
        }
        this.expandedColumns = (GridColumn[])UtilKt.toArray((Collection)newColumns, (Object[])new GridColumn[0]);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<GridRow> createRows(int realIdx, @NotNull Object[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int n = 0;
        int n2 = this.expandedColumns.length;
        Object[] objectArray = new Object[n2];
        while (n < n2) {
            int n3 = n++;
            objectArray[n3] = ReservedCellValue.UNSET;
        }
        Object[] d = objectArray;
        List newRows = new ArrayList();
        DataConsumer.Row row = DataConsumer.Row.create((int)realIdx, (Object[])d);
        Intrinsics.checkNotNullExpressionValue((Object)row, (String)"create(...)");
        newRows.add(row);
        Object[] $this$forEachIndexed$iv = data;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void v;
            int n4 = index$iv++;
            Object object = item$iv;
            int index = n4;
            boolean bl = false;
            BQTypeNode typeStructure = this.columnToTypeStructure.get(index);
            Integer n5 = this.columnToExpandedColumn.get(index);
            Intrinsics.checkNotNull((Object)n5);
            int expandedColumnIndex = ((Number)n5).intValue();
            if (typeStructure != null && v instanceof String) {
                Pair<Integer, Integer> pair;
                try {
                    Object o = null;
                    try {
                        o = JsonUtil.nextObject((JsonReaderEx)new JsonReaderEx((CharSequence)v)).get("v");
                    }
                    catch (Exception e) {
                        o = JsonUtil.nextObject((JsonReaderEx)new JsonReaderEx((CharSequence)StringsKt.replace$default((String)((String)v), (String)"{\"v\":]}", (String)"{\"v\":[]}", (boolean)false, (int)4, null))).get("v");
                    }
                    pair = typeStructure.set(newRows, o, 0, expandedColumnIndex);
                }
                catch (Throwable t) {
                    BigQueryGridColumnsManagerKt.access$getLOG$p().error(t);
                    pair = Unit.INSTANCE;
                }
                continue;
            }
            d[expandedColumnIndex] = v;
        }
        return newRows;
    }

    @NotNull
    public GridColumn[] getColumns() {
        return this.expandedColumns;
    }
}

