/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.bigquery.types;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.types.DasTypeSystemImpl;
import com.intellij.database.dialects.bigquery.types.BigQueryArrayType;
import com.intellij.database.types.DasArrayType;
import com.intellij.database.types.DasTableType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.bigquery.psi.BigQuerySelectPipeExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J.\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/dialects/bigquery/types/BigQueryTypeSystem;", "Lcom/intellij/database/dialects/base/types/DasTypeSystemImpl;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "getTableTypeSpecification", "", "args", "doCreateArrayType", "Lcom/intellij/database/dialects/bigquery/types/BigQueryArrayType;", "componentType", "Lcom/intellij/database/types/DasType;", "getBuiltinFunctionReturnType", "prototype", "Lcom/intellij/sql/dialects/BuiltinFunction$Prototype;", "nameElement", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "params", "Lcom/intellij/psi/PsiElement;", "routineElement", "getUnqualifiedAsteriskType", "element", "getDefaultTypeName", "cat", "Lcom/intellij/database/types/DasTypeCategory;", "intellij.database.dialects.bigquery"})
public final class BigQueryTypeSystem
extends DasTypeSystemImpl {
    public BigQueryTypeSystem(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @NotNull
    public String getTableTypeSpecification(@NotNull String args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "table<" + args + ">";
    }

    @NotNull
    protected BigQueryArrayType doCreateArrayType(@NotNull DasType componentType) {
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        return new BigQueryArrayType(componentType);
    }

    @Nullable
    public DasType getBuiltinFunctionReturnType(@NotNull BuiltinFunction.Prototype prototype, @Nullable SqlReferenceExpression nameElement, @Nullable PsiElement params, @NotNull PsiElement routineElement) {
        Intrinsics.checkNotNullParameter((Object)prototype, (String)"prototype");
        Intrinsics.checkNotNullParameter((Object)routineElement, (String)"routineElement");
        if (!(params instanceof SqlExpressionList) || nameElement == null) {
            return null;
        }
        if (StringsKt.equals((String)nameElement.getName(), (String)"unnest", (boolean)true)) {
            List list = ((SqlExpressionList)params).getExpressionList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExpressionList(...)");
            List expressions = list;
            if (!((Collection)expressions).isEmpty()) {
                DasType dasType = ((SqlExpression)expressions.get(0)).getDasType();
                Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
                DasType argType = dasType;
                if (argType instanceof DasArrayType) {
                    DasType dasType2 = ((DasArrayType)argType).getComponentType();
                    Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"getComponentType(...)");
                    DasType componentType = dasType2;
                    if (componentType instanceof DasTableType) {
                        return componentType;
                    }
                }
            }
        }
        return super.getBuiltinFunctionReturnType(prototype, nameElement, params, routineElement);
    }

    @Nullable
    public DasType getUnqualifiedAsteriskType(@NotNull PsiElement element) {
        BigQuerySelectPipeExpression selectPipe;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element.getParent();
        SqlSelectClause sqlSelectClause = psiElement instanceof SqlSelectClause ? (SqlSelectClause)psiElement : null;
        PsiElement psiElement2 = sqlSelectClause != null ? sqlSelectClause.getParent() : null;
        BigQuerySelectPipeExpression bigQuerySelectPipeExpression = selectPipe = psiElement2 instanceof BigQuerySelectPipeExpression ? (BigQuerySelectPipeExpression)psiElement2 : null;
        if (selectPipe != null) {
            return selectPipe.getSourceExpression().getDasType();
        }
        return super.getUnqualifiedAsteriskType(element);
    }

    @Nullable
    public String getDefaultTypeName(@NotNull DasTypeCategory cat) {
        Intrinsics.checkNotNullParameter((Object)cat, (String)"cat");
        return WhenMappings.$EnumSwitchMapping$0[cat.ordinal()] == 1 ? "string" : super.getDefaultTypeName(cat);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DasTypeCategory.values().length];
            try {
                nArray[DasTypeCategory.STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

