/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.couchbase;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.couchbase.model.CouchbaseIndex;
import com.intellij.database.dialects.couchbase.model.CouchbaseTable;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.couchbase.CouchbaseTypes;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlIdentifierKeywordTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import com.intellij.sql.psi.stubs.elementStubs.SqlDefinitionStub;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002Jj\u0010\u0011\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u0006\u001a\u0002H\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142C\u0010\u0015\u001a?\u0012\u0004\u0012\u0002H\u0012\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0015\u0012\u0013\u0018\u00010\u001b\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u00050\u0016\u00a2\u0006\u0002\b\u001dH\u0002\u00a2\u0006\u0002\u0010\u001e\u00a8\u0006 "}, d2={"Lcom/intellij/database/dialects/couchbase/CouchbaseObjectBuilder;", "Lcom/intellij/database/dialects/base/SqlObjectBuilderImpl;", "<init>", "()V", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "context", "Lcom/intellij/database/model/SqlObjectBuilder$Context;", "buildTable", "Lcom/intellij/database/dialects/couchbase/model/CouchbaseTable;", "buildIndex", "Lcom/intellij/database/dialects/couchbase/model/CouchbaseIndex;", "buildIndexForIntrospector", "processMapLiteral", "T", "el", "Lcom/intellij/psi/PsiElement;", "addOption", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "optionName", "", "value", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/Object;Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function3;)V", "Companion", "intellij.database.dialects.couchbase"})
@SourceDebugExtension(value={"SMAP\nCouchbaseObjectBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CouchbaseObjectBuilder.kt\ncom/intellij/database/dialects/couchbase/CouchbaseObjectBuilder\n+ 2 SqlObjectBuilderImpl.kt\ncom/intellij/database/dialects/base/SqlObjectBuilderImpl\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n714#2:130\n702#2,5:131\n714#2:136\n702#2,5:137\n691#2,10:142\n691#2,7:152\n698#2,3:160\n692#2:163\n1#3:159\n1586#4:164\n1661#4,3:165\n*S KotlinDebug\n*F\n+ 1 CouchbaseObjectBuilder.kt\ncom/intellij/database/dialects/couchbase/CouchbaseObjectBuilder\n*L\n49#1:130\n49#1:131,5\n76#1:136\n76#1:137,5\n77#1:142,10\n90#1:152,7\n90#1:160,3\n90#1:163\n119#1:164\n119#1:165,3\n*E\n"})
public final class CouchbaseObjectBuilder
extends SqlObjectBuilderImpl {
    @NotNull
    private static final Companion Companion;
    @NotNull
    private static final Map<String, Function2<CouchbaseTable, Object, Unit>> TABLE_OPTIONS_MAP;
    @NotNull
    private static final Map<String, Function2<CouchbaseIndex, Object, Unit>> INDEX_OPTIONS_MAP;

    public void build(@NotNull BasicModElement obj, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicModElement basicModElement = obj;
        if (basicModElement instanceof CouchbaseTable) {
            this.buildTable((CouchbaseTable)obj, source, context);
        } else if (basicModElement instanceof CouchbaseIndex) {
            this.buildIndex((CouchbaseIndex)obj, source, context);
        } else {
            super.build(obj, source, context);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildTable(CouchbaseTable obj, DasObject source, SqlObjectBuilder.Context context) {
        BasicElement basicElement;
        void $this$stubbedOrBuild$iv;
        void this_$iv;
        super.buildBasicElement((BasicModElement)obj, source, context);
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject dasObject = source;
        BasicElement tgt$iv = (BasicElement)obj;
        boolean $i$f$stubbedOrBuild = false;
        BasicElement basicElement2 = this_$iv;
        void $this$stubbed$iv$iv = $this$stubbedOrBuild$iv;
        boolean $i$f$stubbed = false;
        void var12_11 = $this$stubbed$iv$iv;
        if (var12_11 instanceof CouchbaseTable) {
            basicElement = (BasicElement)$this$stubbed$iv$iv;
        } else if (var12_11 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv$iv).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof CouchbaseTable)) {
                object = null;
            }
            basicElement = (BasicElement)((CouchbaseTable)object);
        } else {
            basicElement = null;
        }
        BasicElement basicElement3 = basicElement;
        if (basicElement == null) {
            BasicElement basicElement4 = ((BasicObjectNode)tgt$iv).getMetaObject().newDataObject();
            if (basicElement4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dialects.couchbase.model.CouchbaseTable");
            }
            basicElement2 = (BasicElement)((CouchbaseTable)basicElement4);
            CouchbaseTable $this$buildTable_u24lambda_u240 = (CouchbaseTable)basicElement2;
            boolean bl = false;
            PsiElement optionsClause = SqlImplUtil.getChildOfType((PsiElement)(source instanceof PsiElement ? (PsiElement)source : null), (IElementType)CouchbaseTypes.COUCH_BUCKET_OPTIONS_CLAUSE);
            this.processMapLiteral($this$buildTable_u24lambda_u240, optionsClause, CouchbaseObjectBuilder::buildTable$lambda$0$0);
            basicElement3 = basicElement2;
        }
        CouchbaseTable src = (CouchbaseTable)basicElement3;
        obj.setFlushEnabled(src.isFlushEnabled());
        obj.setRamQuotaMB(src.getRamQuotaMB());
        obj.setReplicaNumber(src.getReplicaNumber());
        obj.setReplicaIndexes(src.isReplicaIndexes());
        obj.setMaxTTL(src.getMaxTTL());
        obj.setCompressionMode(src.getCompressionMode());
        obj.setBucketType(src.getBucketType());
        obj.setConflictResolutionType(src.getConflictResolutionType());
        obj.setEvictionPolicy(src.getEvictionPolicy());
    }

    private final void buildIndex(CouchbaseIndex obj, DasObject source, SqlObjectBuilder.Context context) {
        if (context.isIntrospector()) {
            this.buildIndexForIntrospector(obj, source);
        } else {
            super.buildIndex((BasicModIndex)obj, source, context);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildIndexForIntrospector(CouchbaseIndex obj, DasObject source) {
        BasicElement basicElement;
        void $this$stubbedOrBuild$iv;
        void this_$iv;
        if (!(source instanceof SqlCreateIndexStatement)) {
            return;
        }
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject dasObject = source;
        BasicElement tgt$iv = (BasicElement)obj;
        boolean $i$f$stubbedOrBuild = false;
        BasicElement basicElement2 = this_$iv;
        void $this$stubbed$iv$iv = $this$stubbedOrBuild$iv;
        boolean $i$f$stubbed = false;
        void var11_10 = $this$stubbed$iv$iv;
        if (var11_10 instanceof CouchbaseIndex) {
            basicElement = (BasicElement)$this$stubbed$iv$iv;
        } else if (var11_10 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv$iv).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof CouchbaseIndex)) {
                object = null;
            }
            basicElement = (BasicElement)((CouchbaseIndex)object);
        } else {
            basicElement = null;
        }
        BasicElement basicElement3 = basicElement;
        if (basicElement == null) {
            void this_$iv2;
            BasicElement basicElement4 = ((BasicObjectNode)tgt$iv).getMetaObject().newDataObject();
            if (basicElement4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dialects.couchbase.model.CouchbaseIndex");
            }
            basicElement2 = (BasicElement)((CouchbaseIndex)basicElement4);
            CouchbaseIndex $this$buildIndexForIntrospector_u24lambda_u240 = (CouchbaseIndex)basicElement2;
            boolean bl = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl2 = this;
            PsiElement el$iv = (PsiElement)source;
            boolean $i$f$forEachChild = false;
            void var18_17 = this_$iv2;
            PsiElement first$iv$iv = el$iv.getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement el = tmp$iv$iv;
                boolean bl2 = false;
                PsiElement psiElement = el.getFirstChild();
                if (!Intrinsics.areEqual((Object)(psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null), (Object)CouchbaseTypes.COUCH_WITH)) continue;
                this.processMapLiteral($this$buildIndexForIntrospector_u24lambda_u240, el, CouchbaseObjectBuilder::buildIndexForIntrospector$lambda$0$0$0);
            }
            basicElement3 = basicElement2;
        }
        CouchbaseIndex src = (CouchbaseIndex)basicElement3;
        obj.setDeferBuild(src.isDeferBuild());
        obj.setNodes(src.getNodes());
    }

    /*
     * WARNING - void declaration
     */
    private final <T> void processMapLiteral(T obj, PsiElement el, Function3<? super T, ? super String, Object, Unit> addOption) {
        void this_$iv;
        PsiElement mapLiteral = SqlImplUtil.getChildOfType((PsiElement)el, (IElementType)CouchbaseTypes.COUCH_MAP_LITERAL);
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        PsiElement el$iv = mapLiteral;
        boolean $i$f$forEachChild = false;
        void var8_8 = this_$iv;
        PsiElement psiElement = el$iv;
        PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
        boolean $i$f$forEachSibling = false;
        for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
            Object object;
            Object it;
            Object object2;
            PsiElement innerEl;
            block13: {
                block12: {
                    IElementType childType;
                    innerEl = tmp$iv$iv;
                    boolean bl = false;
                    PsiElement psiElement2 = innerEl.getFirstChild();
                    Object object3 = childType = psiElement2 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement2) : null;
                    if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)innerEl), (Object)SqlCompositeElementTypes.SQL_SET_ASSIGNMENT) || !Intrinsics.areEqual((Object)childType, (Object)SqlTokens.SQL_STRING_TOKEN) && !Intrinsics.areEqual((Object)childType, (Object)SqlTokens.SQL_IDENT) && !(childType instanceof SqlIdentifierKeywordTokenType)) continue;
                    object2 = innerEl.getFirstChild();
                    if (object2 == null || (object2 = object2.getText()) == null) break block12;
                    Object object4 = object2;
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    String string = ((String)object4).toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                    object2 = string;
                    if (string == null) break block12;
                    it = object2;
                    boolean bl2 = false;
                    String string2 = StringUtil.unquoteString((String)it);
                    object2 = string2;
                    if (string2 != null) break block13;
                }
                return;
            }
            Object optionName = object2;
            PsiElement optionValueElement = innerEl.getLastChild();
            IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)optionValueElement);
            if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_ARRAY_LITERAL)) {
                object = optionValueElement.getText();
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_STRING_LITERAL)) {
                String string = optionValueElement.getText();
                if (string != null) {
                    it = string;
                    boolean bl = false;
                    object = StringUtil.unquoteString((String)it);
                } else {
                    object = null;
                }
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_NUMERIC_LITERAL)) {
                String string = optionValueElement.getText();
                object = string != null ? StringsKt.toLongOrNull((String)string) : null;
            } else {
                object = Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_BOOLEAN_LITERAL) ? Boolean.valueOf(Boolean.parseBoolean(optionValueElement.getText())) : null;
            }
            String value = object;
            addOption.invoke(obj, optionName, (Object)value);
        }
    }

    private static final Unit buildTable$lambda$0$0(CouchbaseTable $this$processMapLiteral, String optionName, Object value) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$processMapLiteral, (String)"$this$processMapLiteral");
            Intrinsics.checkNotNullParameter((Object)optionName, (String)"optionName");
            Function2<CouchbaseTable, Object, Unit> function2 = TABLE_OPTIONS_MAP.get(optionName);
            if (function2 == null) break block0;
            function2.invoke((Object)$this$processMapLiteral, value);
        }
        return Unit.INSTANCE;
    }

    private static final Unit buildIndexForIntrospector$lambda$0$0$0(CouchbaseIndex $this$processMapLiteral, String optionName, Object value) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$processMapLiteral, (String)"$this$processMapLiteral");
            Intrinsics.checkNotNullParameter((Object)optionName, (String)"optionName");
            Function2<CouchbaseIndex, Object, Unit> function2 = INDEX_OPTIONS_MAP.get(optionName);
            if (function2 == null) break block0;
            function2.invoke((Object)$this$processMapLiteral, value);
        }
        return Unit.INSTANCE;
    }

    private static final Unit TABLE_OPTIONS_MAP$lambda$0(CouchbaseTable t, Object v) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            Boolean bl = v instanceof Boolean ? (Boolean)v : null;
            if (bl == null) break block0;
            boolean it = bl;
            boolean bl2 = false;
            t.setFlushEnabled(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit TABLE_OPTIONS_MAP$lambda$1(CouchbaseTable t, Object v) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            Long l = v instanceof Long ? (Long)v : null;
            if (l == null) break block0;
            long it = ((Number)l).longValue();
            boolean bl = false;
            t.setRamQuotaMB(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit TABLE_OPTIONS_MAP$lambda$2(CouchbaseTable t, Object v) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            Long l = v instanceof Long ? (Long)v : null;
            if (l == null) break block0;
            long it = ((Number)l).longValue();
            boolean bl = false;
            t.setReplicaNumber((int)it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit TABLE_OPTIONS_MAP$lambda$3(CouchbaseTable t, Object v) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            Boolean bl = v instanceof Boolean ? (Boolean)v : null;
            if (bl == null) break block0;
            boolean it = bl;
            boolean bl2 = false;
            t.setReplicaIndexes(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit TABLE_OPTIONS_MAP$lambda$4(CouchbaseTable t, Object v) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            Long l = v instanceof Long ? (Long)v : null;
            if (l == null) break block0;
            long it = ((Number)l).longValue();
            boolean bl = false;
            t.setMaxTTL((int)it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit TABLE_OPTIONS_MAP$lambda$5(CouchbaseTable t, Object v) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            String string = v instanceof String ? (String)v : null;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            t.setCompressionMode(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit TABLE_OPTIONS_MAP$lambda$6(CouchbaseTable t, Object v) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            String string = v instanceof String ? (String)v : null;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            t.setBucketType(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit TABLE_OPTIONS_MAP$lambda$7(CouchbaseTable t, Object v) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            String string = v instanceof String ? (String)v : null;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            t.setConflictResolutionType(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit TABLE_OPTIONS_MAP$lambda$8(CouchbaseTable t, Object v) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            String string = v instanceof String ? (String)v : null;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            t.setEvictionPolicy(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit INDEX_OPTIONS_MAP$lambda$0(CouchbaseIndex i, Object v) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)i, (String)"i");
            Boolean bl = v instanceof Boolean ? (Boolean)v : null;
            if (bl == null) break block0;
            boolean it = bl;
            boolean bl2 = false;
            i.setDeferBuild(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit INDEX_OPTIONS_MAP$lambda$1(CouchbaseIndex i, Object v) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)i, (String)"i");
            String string = v instanceof String ? (String)v : null;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            i.setNodes(it);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        Object[] objectArray = new Pair[]{TuplesKt.to(CouchbaseTable.FLUSH_ENABLED, CouchbaseObjectBuilder::TABLE_OPTIONS_MAP$lambda$0), TuplesKt.to(CouchbaseTable.RAM_QUOTAM_B, CouchbaseObjectBuilder::TABLE_OPTIONS_MAP$lambda$1), TuplesKt.to(CouchbaseTable.REPLICA_NUMBER, CouchbaseObjectBuilder::TABLE_OPTIONS_MAP$lambda$2), TuplesKt.to(CouchbaseTable.REPLICA_INDEXES, CouchbaseObjectBuilder::TABLE_OPTIONS_MAP$lambda$3), TuplesKt.to(CouchbaseTable.MAXTT_L, CouchbaseObjectBuilder::TABLE_OPTIONS_MAP$lambda$4), TuplesKt.to(CouchbaseTable.COMPRESSION_MODE, CouchbaseObjectBuilder::TABLE_OPTIONS_MAP$lambda$5), TuplesKt.to(CouchbaseTable.BUCKET_TYPE, CouchbaseObjectBuilder::TABLE_OPTIONS_MAP$lambda$6), TuplesKt.to(CouchbaseTable.CONFLICT_RESOLUTION_TYPE, CouchbaseObjectBuilder::TABLE_OPTIONS_MAP$lambda$7), TuplesKt.to(CouchbaseTable.EVICTION_POLICY, CouchbaseObjectBuilder::TABLE_OPTIONS_MAP$lambda$8)};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)((BasicMetaPropertyId)it.getFirst()).name, (String)"name");
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            collection.add(TuplesKt.to((Object)string2, (Object)it.getSecond()));
        }
        TABLE_OPTIONS_MAP = MapsKt.toMap((Iterable)((List)var3_3));
        objectArray = new Pair[]{TuplesKt.to((Object)"defer_build", CouchbaseObjectBuilder::INDEX_OPTIONS_MAP$lambda$0), TuplesKt.to((Object)"nodes", CouchbaseObjectBuilder::INDEX_OPTIONS_MAP$lambda$1)};
        INDEX_OPTIONS_MAP = MapsKt.mapOf((Pair[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R.\u0010\u0004\u001a\"\u0012\u0004\u0012\u00020\u0006\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\t0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\n\u001a\"\u0012\u0004\u0012\u00020\u0006\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\t0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/couchbase/CouchbaseObjectBuilder$Companion;", "", "<init>", "()V", "TABLE_OPTIONS_MAP", "", "", "Lkotlin/Function2;", "Lcom/intellij/database/dialects/couchbase/model/CouchbaseTable;", "", "INDEX_OPTIONS_MAP", "Lcom/intellij/database/dialects/couchbase/model/CouchbaseIndex;", "intellij.database.dialects.couchbase"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

