/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hive;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.dialects.base.BasePredicatesHelper;
import com.intellij.database.util.Version;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\u0012\u0010\u000e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/hive/HivePredicatesHelper;", "Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "isText", "", "columnRef", "Lcom/intellij/database/data/types/ColumnRef;", "value", "Lcom/intellij/database/data/types/PredicateValue;", "version", "Lcom/intellij/database/util/Version;", "isContainerType", "typeName", "", "intellij.database.dialects.hive"})
public final class HivePredicatesHelper
extends BasePredicatesHelper {
    public HivePredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    protected boolean isText(@NotNull ColumnRef columnRef, @NotNull PredicateValue value, @Nullable Version version) {
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return super.isText(columnRef, value, version) && !this.isContainerType(columnRef.getTypeName());
    }

    private final boolean isContainerType(String typeName) {
        return typeName != null && (StringsKt.startsWith$default((String)typeName, (String)"array", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)typeName, (String)"map", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)typeName, (String)"struct", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)typeName, (String)"uniontype", (boolean)false, (int)2, null));
    }
}

