/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.snowflake.plan;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.ReusableNoisyStatement;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dialects.base.plan.RawPlanData;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.util.containers.JBTreeTraverser;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\b\u0010\u0013\u001a\u00020\u000bH\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u000bH\u0002R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/snowflake/plan/SFlakeJsonRawPlanData;", "Lcom/intellij/database/dialects/base/plan/RawPlanData;", "<init>", "()V", "root", "Lcom/intellij/database/dialects/snowflake/plan/SFlakeJsonRawPlanData$JsonMetaNode;", "getRoot", "()Lcom/intellij/database/dialects/snowflake/plan/SFlakeJsonRawPlanData$JsonMetaNode;", "setRoot", "(Lcom/intellij/database/dialects/snowflake/plan/SFlakeJsonRawPlanData$JsonMetaNode;)V", "rawJson", "", "load", "", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "statement", "run", "", "dump", "parseJsonToMetaNodes", "jsonString", "JsonMetaNode", "intellij.database.dialects.snowflake"})
@SourceDebugExtension(value={"SMAP\nSFlakeJsonRawPlanData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SFlakeJsonRawPlanData.kt\ncom/intellij/database/dialects/snowflake/plan/SFlakeJsonRawPlanData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,134:1\n1#2:135\n1915#3:136\n1916#3:139\n1021#3,2:140\n14081#4,2:137\n*S KotlinDebug\n*F\n+ 1 SFlakeJsonRawPlanData.kt\ncom/intellij/database/dialects/snowflake/plan/SFlakeJsonRawPlanData\n*L\n112#1:136\n112#1:139\n128#1:140,2\n113#1:137,2\n*E\n"})
public final class SFlakeJsonRawPlanData
extends RawPlanData {
    @Nullable
    private JsonMetaNode root;
    @Nullable
    private String rawJson;

    @Nullable
    public final JsonMetaNode getRoot() {
        return this.root;
    }

    public final void setRoot(@Nullable JsonMetaNode jsonMetaNode) {
        this.root = jsonMetaNode;
    }

    public void load(@NotNull DatabaseConnectionCore connection, @NotNull String statement, boolean run) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        this.root = null;
        this.rawJson = null;
        RawPlanData.useStatementWithPreserved((DatabaseConnectionCore)connection, arg_0 -> SFlakeJsonRawPlanData.load$lambda$1(arg_0 -> SFlakeJsonRawPlanData.load$lambda$0(statement, this, arg_0), arg_0), (RawPlanData.StateSaver[])new RawPlanData.StateSaver[0]);
    }

    public void load(@NotNull String dump) {
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        this.rawJson = dump;
        this.root = this.parseJsonToMetaNodes(dump);
    }

    @NotNull
    public String dump() {
        String string = this.rawJson;
        if (string == null) {
            string = "";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final JsonMetaNode parseJsonToMetaNodes(String jsonString) {
        Int2ObjectMap nodesById = (Int2ObjectMap)new Int2ObjectOpenHashMap();
        try {
            JSONObject data = new JSONObject(jsonString);
            JSONArray operations = data.getJSONArray("Operations");
            if (operations.length() > 0) {
                JSONArray firstGroup = operations.getJSONArray(0);
                int n = firstGroup.length();
                for (int i = 0; i < n; ++i) {
                    Object object;
                    Number number;
                    Object object2;
                    Number number22;
                    Object object3;
                    Object object4;
                    List objects;
                    Object it3;
                    int n2;
                    Object object5;
                    int n3;
                    int n4;
                    int[] parentOperators;
                    int n5;
                    Object object6;
                    int n6;
                    JSONObject op = firstGroup.getJSONObject(i);
                    int id = op.getInt("id");
                    if (op.has("parentOperators")) {
                        JSONArray parentsArray = op.getJSONArray("parentOperators");
                        int n7 = 0;
                        n6 = parentsArray.length();
                        object6 = new int[n6];
                        while (n7 < n6) {
                            n5 = n7++;
                            object6[n5] = parentsArray.getInt(n5);
                        }
                        v0 = object6;
                    } else {
                        v0 = parentOperators = new int[]{};
                    }
                    if (op.has("objects")) {
                        JSONArray objArray = op.getJSONArray("objects");
                        n6 = objArray.length();
                        object6 = new ArrayList(n6);
                        n5 = 0;
                        while (n5 < n6) {
                            void it2;
                            n3 = n4 = n5++;
                            object5 = object6;
                            n2 = 0;
                            ((ArrayList)object5).add(objArray.getString((int)it2));
                        }
                        List list = (List)object6;
                        it3 = list;
                        boolean bl = false;
                        v1 = !((Collection)it3).isEmpty() ? list : null;
                    } else {
                        v1 = objects = null;
                    }
                    if (op.has("expressions")) {
                        JSONArray expArray = op.getJSONArray("expressions");
                        int it3 = expArray.length();
                        ArrayList bl = new ArrayList(it3);
                        n4 = 0;
                        while (n4 < it3) {
                            void it4;
                            n2 = n3 = n4++;
                            object5 = bl;
                            boolean bl2 = false;
                            ((ArrayList)object5).add(expArray.getString((int)it4));
                        }
                        Object it5 = it3 = (List)bl;
                        boolean number22 = false;
                        object4 = !((Collection)it5).isEmpty() ? it3 : null;
                    } else {
                        object4 = null;
                    }
                    Object expressions = object4;
                    Intrinsics.checkNotNullExpressionValue((Object)op.optString("operation", "UNKNOWN"), (String)"optString(...)");
                    String it5 = op.optString("alias", null);
                    Number number3 = op.has("partitionsTotal") ? (Number)((object3 = op.get("partitionsTotal")) instanceof Number ? (Number)((Number)object3) : (Number)null) : (Number)(number22 = null);
                    Number number4 = op.has("partitionsAssigned") ? (Number)((object2 = op.get("partitionsAssigned")) instanceof Number ? (Number)((Number)object2) : (Number)null) : (Number)(number = null);
                    Number number5 = op.has("bytesAssigned") ? (Number)((object = op.get("bytesAssigned")) instanceof Number ? (Number)((Number)object) : (Number)null) : (Number)null;
                    JsonMetaNode node = new JsonMetaNode(id, parentOperators, (String)it3, it5, objects, (List<String>)expressions, number22, number, number5);
                    nodesById.put(id, (Object)node);
                }
            }
        }
        catch (JSONException e) {
            throw new PlanRetrievalException("Failed to parse Snowflake JSON plan structure", (Throwable)e);
        }
        Collection collection = nodesById.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsonMetaNode node = (JsonMetaNode)element$iv;
            boolean bl = false;
            int[] $this$forEach$iv2 = node.getParentOperators();
            boolean $i$f$forEach2 = false;
            int n = $this$forEach$iv2.length;
            for (int i = 0; i < n; ++i) {
                JsonMetaNode parent;
                int element$iv2;
                int parentId = element$iv2 = $this$forEach$iv2[i];
                boolean bl3 = false;
                if (parentId == -1 || (parent = (JsonMetaNode)nodesById.get(parentId)) == null) continue;
                if (parent.getChildren() == null) {
                    parent.setChildren(new ArrayList());
                }
                List<JsonMetaNode> list = parent.getChildren();
                Intrinsics.checkNotNull(list);
                Intrinsics.checkNotNull((Object)node);
                list.add(node);
            }
        }
        JsonMetaNode jsonMetaNode = (JsonMetaNode)nodesById.get(0);
        if (jsonMetaNode == null) {
            throw new PlanRetrievalException("No root node found in plan");
        }
        JsonMetaNode rootNode = jsonMetaNode;
        for (JsonMetaNode node : ((JBTreeTraverser)JBTreeTraverser.from(arg_0 -> SFlakeJsonRawPlanData.parseJsonToMetaNodes$lambda$6(SFlakeJsonRawPlanData::parseJsonToMetaNodes$lambda$5, arg_0)).withRoot((Object)rootNode)).traverse()) {
            List<JsonMetaNode> $this$sortBy$iv;
            if (node.getChildren() == null) continue;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() <= 1) continue;
            CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    JsonMetaNode it = (JsonMetaNode)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getId());
                    it = (JsonMetaNode)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getId()));
                }
            });
        }
        return rootNode;
    }

    private static final Unit load$lambda$0$0(SFlakeJsonRawPlanData this$0, RemoteResultSet rs) {
        if (!rs.next()) {
            RawPlanData.failWithEmptyResultSetError();
        }
        if (rs.getMetaData().getColumnCount() != 1) {
            throw new PlanRetrievalException("Database returned data in unknown format");
        }
        String string = rs.getString(1);
        if (string == null) {
            throw new PlanRetrievalException("Database returned null plan");
        }
        String json = string;
        if (rs.next()) {
            throw new PlanRetrievalException("Database returned too many data");
        }
        this$0.rawJson = json;
        this$0.root = this$0.parseJsonToMetaNodes(json);
        return Unit.INSTANCE;
    }

    private static final void load$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit load$lambda$0(String $statement, SFlakeJsonRawPlanData this$0, ReusableSmartStatement s) {
        ReusableNoisyStatement reusableNoisyStatement = s.noisy();
        String string = "EXPLAIN USING JSON " + $statement;
        ResultsProducer.VoidReadyProcessor voidReadyProcessor = RawPlanData.processing(arg_0 -> SFlakeJsonRawPlanData.load$lambda$0$1(arg_0 -> SFlakeJsonRawPlanData.load$lambda$0$0(this$0, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)voidReadyProcessor, (String)"processing(...)");
        reusableNoisyStatement.execute((Object)string, voidReadyProcessor);
        return Unit.INSTANCE;
    }

    private static final void load$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Iterable parseJsonToMetaNodes$lambda$5(JsonMetaNode it) {
        return it.getChildren();
    }

    private static final Iterable parseJsonToMetaNodes$lambda$6(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0013\n\u0002\u0010!\n\u0002\b\u0004\u0018\u00002\u00020\u0001Bg\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0019\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0019\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001dR\"\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001a\"\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lcom/intellij/database/dialects/snowflake/plan/SFlakeJsonRawPlanData$JsonMetaNode;", "", "id", "", "parentOperators", "", "operation", "", "alias", "objects", "", "expressions", "partitionsTotal", "", "partitionsAssigned", "bytesAssigned", "<init>", "(I[ILjava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "getId", "()I", "getParentOperators", "()[I", "getOperation", "()Ljava/lang/String;", "getAlias", "getObjects", "()Ljava/util/List;", "getExpressions", "getPartitionsTotal", "()Ljava/lang/Number;", "getPartitionsAssigned", "getBytesAssigned", "children", "", "getChildren", "setChildren", "(Ljava/util/List;)V", "intellij.database.dialects.snowflake"})
    public static final class JsonMetaNode {
        private final int id;
        @NotNull
        private final int[] parentOperators;
        @NotNull
        private final String operation;
        @Nullable
        private final String alias;
        @Nullable
        private final List<String> objects;
        @Nullable
        private final List<String> expressions;
        @Nullable
        private final Number partitionsTotal;
        @Nullable
        private final Number partitionsAssigned;
        @Nullable
        private final Number bytesAssigned;
        @Nullable
        private List<JsonMetaNode> children;

        public JsonMetaNode(int id, @NotNull int[] parentOperators, @NotNull String operation, @Nullable String alias, @Nullable List<String> objects, @Nullable List<String> expressions, @Nullable Number partitionsTotal, @Nullable Number partitionsAssigned, @Nullable Number bytesAssigned) {
            Intrinsics.checkNotNullParameter((Object)parentOperators, (String)"parentOperators");
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            this.id = id;
            this.parentOperators = parentOperators;
            this.operation = operation;
            this.alias = alias;
            this.objects = objects;
            this.expressions = expressions;
            this.partitionsTotal = partitionsTotal;
            this.partitionsAssigned = partitionsAssigned;
            this.bytesAssigned = bytesAssigned;
        }

        public final int getId() {
            return this.id;
        }

        @NotNull
        public final int[] getParentOperators() {
            return this.parentOperators;
        }

        @NotNull
        public final String getOperation() {
            return this.operation;
        }

        @Nullable
        public final String getAlias() {
            return this.alias;
        }

        @Nullable
        public final List<String> getObjects() {
            return this.objects;
        }

        @Nullable
        public final List<String> getExpressions() {
            return this.expressions;
        }

        @Nullable
        public final Number getPartitionsTotal() {
            return this.partitionsTotal;
        }

        @Nullable
        public final Number getPartitionsAssigned() {
            return this.partitionsAssigned;
        }

        @Nullable
        public final Number getBytesAssigned() {
            return this.bytesAssigned;
        }

        @Nullable
        public final List<JsonMetaNode> getChildren() {
            return this.children;
        }

        public final void setChildren(@Nullable List<JsonMetaNode> list) {
            this.children = list;
        }
    }
}

