/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.community.wintools;

import com.intellij.community.wintools.Win32Exception;
import com.sun.jna.platform.win32.Kernel32;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u000e\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a&\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0000\u0010\u00072\u000b\u0010\b\u001a\u00070\u0001\u00a2\u0006\u0002\b\tH\u0000\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"kernel32LastError", "", "prettyHRESULT", "lastError", "", "winFailure", "Lkotlin/Result;", "T", "message", "Lcom/intellij/openapi/util/NlsSafe;", "(Ljava/lang/String;)Ljava/lang/Object;", "intellij.community.wintools"})
public final class ErrorToolsKt {
    @NotNull
    public static final String kernel32LastError() {
        int lastError = Kernel32.INSTANCE.GetLastError();
        return ErrorToolsKt.prettyHRESULT(lastError);
    }

    @NotNull
    public static final String prettyHRESULT(int lastError) {
        int hResult = lastError <= 0 ? lastError : lastError & 0xFFFF | 0x70000 | Integer.MIN_VALUE;
        String string = "0x%08X";
        Object[] objectArray = new Object[]{hResult};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @NotNull
    public static final <T> Object winFailure(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Win32Exception(message)));
    }
}

