/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.community.wintools;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.community.wintools.ntdll.NtDllExt;
import com.intellij.community.wintools.ntdll.PEB;
import com.intellij.community.wintools.ntdll.PROCESS_BASIC_INFORMATION;
import com.intellij.community.wintools.ntdll.RTL_USER_PROCESS_PARAMETERS;
import com.intellij.openapi.util.SystemInfoRt;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Result;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B0\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\n\u0010\u0015\u001a\u00020\u0005H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lcom/intellij/community/wintools/WinProcessInfo;", "", "pid", "", "commandLine", "", "Lcom/intellij/openapi/util/NlsSafe;", "executable", "Ljava/nio/file/Path;", "parentId", "<init>", "(JLjava/lang/String;Ljava/nio/file/Path;Ljava/lang/Long;)V", "getPid", "()J", "getCommandLine", "()Ljava/lang/String;", "getExecutable", "()Ljava/nio/file/Path;", "getParentId", "()Ljava/lang/Long;", "Ljava/lang/Long;", "toString", "Companion", "intellij.community.wintools"})
public final class WinProcessInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long pid;
    @NotNull
    private final String commandLine;
    @NotNull
    private final Path executable;
    @Nullable
    private final Long parentId;

    private WinProcessInfo(long pid, String commandLine, Path executable, Long parentId) {
        this.pid = pid;
        this.commandLine = commandLine;
        this.executable = executable;
        this.parentId = parentId;
    }

    public final long getPid() {
        return this.pid;
    }

    @NotNull
    public final String getCommandLine() {
        return this.commandLine;
    }

    @NotNull
    public final Path getExecutable() {
        return this.executable;
    }

    @Nullable
    public final Long getParentId() {
        return this.parentId;
    }

    @NotNull
    public String toString() {
        return "WinProcessInfo(pid=" + this.pid + ", commandLine='" + this.commandLine + "', executable=" + this.executable + ", parentId=" + this.parentId + ")";
    }

    public /* synthetic */ WinProcessInfo(long pid, String commandLine, Path executable, Long parentId, DefaultConstructorMarker $constructor_marker) {
        this(pid, commandLine, executable, parentId);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/community/wintools/WinProcessInfo$Companion;", "", "<init>", "()V", "get", "Lkotlin/Result;", "Lcom/intellij/community/wintools/WinProcessInfo;", "pid", "", "get-IoAF18A", "(J)Ljava/lang/Object;", "intellij.community.wintools"})
    @SourceDebugExtension(value={"SMAP\nWinProcessInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WinProcessInfo.kt\ncom/intellij/community/wintools/WinProcessInfo$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Object get-IoAF18A(long pid) {
            boolean bl = SystemInfoRt.isWindows;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-WinProcessInfo$Companion$get$22 = false;
                String $i$a$-assert-WinProcessInfo$Companion$get$22 = "Do not call on **nix";
                throw new AssertionError((Object)$i$a$-assert-WinProcessInfo$Companion$get$22);
            }
            WinNT.HANDLE hProcess = Kernel32.INSTANCE.OpenProcess(1040, false, (int)pid);
            if (hProcess == null) {
                return ErrorToolsKt.winFailure("Failed to open a process with the PID " + pid);
            }
            try {
                Path executable;
                PROCESS_BASIC_INFORMATION info = new PROCESS_BASIC_INFORMATION();
                if (!Intrinsics.areEqual((Object)NtDllExt.Companion.getINSTANCE().NtQueryInformationProcess(hProcess, 0, info, info.size(), null), (Object)Pointer.NULL)) {
                    Object object = ErrorToolsKt.winFailure("Failed to query the process information from the PID " + pid);
                    return object;
                }
                PEB peb = new PEB();
                if (!Kernel32.INSTANCE.ReadProcessMemory(hProcess, info.PebBaseAddress, peb.getPointer(), peb.size(), null)) {
                    Object object = ErrorToolsKt.winFailure("Failed to read the PEB structure from the PID " + pid);
                    return object;
                }
                peb.read();
                RTL_USER_PROCESS_PARAMETERS rtl = new RTL_USER_PROCESS_PARAMETERS();
                if (!Kernel32.INSTANCE.ReadProcessMemory(hProcess, peb.ProcessParameters, rtl.getPointer(), rtl.size(), null)) {
                    Object object = ErrorToolsKt.winFailure("Failed to read RTL_USER_PROCESS_PARAMETERS structure from the PID " + pid);
                    return object;
                }
                rtl.read();
                String commandLine = rtl.CommandLine.readFromProcess(hProcess);
                if (commandLine == null) {
                    Object object = ErrorToolsKt.winFailure("Failed to read the command line from the PID " + pid);
                    return object;
                }
                String string = rtl.ImagePathName.readFromProcess(hProcess);
                if (string != null) {
                    String it = string;
                    boolean bl2 = false;
                    Path path = Paths.get(it, new String[0]);
                    v2 = path;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                } else {
                    v2 = executable = null;
                }
                if (executable == null) {
                    Object object = ErrorToolsKt.winFailure("Failed to read the image path name from the PID " + pid);
                    return object;
                }
                Object object = Result.constructor-impl((Object)new WinProcessInfo(pid, commandLine, executable, info.InheritedFromUniqueProcessId, null));
                return object;
            }
            finally {
                Kernel32.INSTANCE.CloseHandle(hProcess);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

