/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.java;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.impl.search.AnnotatedElementsSearcher;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.PatternValuesIndex;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.InjectionPlace;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
public final class InjectionCache {
    private final CachedValue<Set<String>> myAnnoIndex;
    private final CachedValue<Collection<String>> myXmlIndex;
    private final Project myProject;

    public InjectionCache(@NotNull Project project) {
        if (project == null) {
            InjectionCache.$$$reportNull$$$0(0);
        }
        Configuration configuration = Configuration.getProjectInstance((Project)project);
        this.myProject = project;
        this.myXmlIndex = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            HashMap<ElementPattern, BaseInjection> map = new HashMap<ElementPattern, BaseInjection>();
            for (BaseInjection injection : configuration.getInjections("java")) {
                for (InjectionPlace place : injection.getInjectionPlaces()) {
                    if (!place.isEnabled() || place.getElementPattern() == null) continue;
                    map.put(place.getElementPattern(), injection);
                }
            }
            Set stringSet = PatternValuesIndex.buildStringIndex(map.keySet());
            return new CachedValueProvider.Result((Object)stringSet, new Object[]{configuration});
        }, false);
        this.myAnnoIndex = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            Set<String> result = this.collectMethodNamesWithLanguage(configuration.getAdvancedConfiguration().getLanguageAnnotationClass());
            ModificationTracker modificationTracker = PsiModificationTracker.getInstance((Project)project).forLanguage((Language)JavaLanguage.INSTANCE);
            return new CachedValueProvider.Result(result, new Object[]{modificationTracker, configuration});
        }, false);
    }

    @NotNull
    private Set<String> collectMethodNamesWithLanguage(String annotationClassName) {
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)this.myProject);
        GlobalSearchScope usageScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)allScope, (FileType[])new FileType[]{JavaFileType.INSTANCE, JavaClassFileType.INSTANCE});
        HashSet<String> result = new HashSet<String>();
        ArrayList<PsiClass> annoClasses = new ArrayList<PsiClass>(List.of(JavaPsiFacade.getInstance((Project)this.myProject).findClasses(annotationClassName, allScope)));
        for (int cursor = 0; cursor < annoClasses.size(); ++cursor) {
            AnnotatedElementsSearch.Parameters parameters = new AnnotatedElementsSearch.Parameters((PsiClass)annoClasses.get(cursor), (SearchScope)usageScope, true, new Class[]{PsiClass.class, PsiParameter.class, PsiMethod.class, PsiRecordComponent.class});
            new AnnotatedElementsSearcher().execute(parameters, element -> {
                PsiRecordComponent psiRecordComponent;
                PsiClass psiClass;
                PsiClass psiClass2;
                if (element instanceof PsiParameter) {
                    PsiParameter psiParameter = (PsiParameter)element;
                    PsiElement scope = psiParameter.getDeclarationScope();
                    if (scope instanceof PsiMethod) {
                        PsiMethod psiMethod = (PsiMethod)scope;
                        ContainerUtil.addIfNotNull((Collection)result, (Object)psiMethod.getName());
                    }
                } else if (element instanceof PsiClass && (psiClass2 = (PsiClass)element).isAnnotationType() && !annoClasses.contains(psiClass2)) {
                    annoClasses.add(psiClass2);
                } else if (element instanceof PsiMethod) {
                    PsiMethod psiMethod = (PsiMethod)element;
                    ContainerUtil.addIfNotNull((Collection)result, (Object)psiMethod.getName());
                } else if (element instanceof PsiRecordComponent && (psiClass = (psiRecordComponent = (PsiRecordComponent)element).getContainingClass()) != null) {
                    ContainerUtil.addIfNotNull((Collection)result, (Object)psiClass.getName());
                }
                return true;
            });
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            InjectionCache.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    public static InjectionCache getInstance(Project project) {
        return (InjectionCache)project.getService(InjectionCache.class);
    }

    public Set<String> getAnnoIndex() {
        return (Set)this.myAnnoIndex.getValue();
    }

    public Collection<String> getXmlIndex() {
        return (Collection)this.myXmlIndex.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/inject/java/InjectionCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/inject/java/InjectionCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMethodNamesWithLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

