/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.settings.data;

import com.google.gson.JsonObject;
import com.intellij.charts.core.series.AreaSeries;
import com.intellij.charts.core.utils.GroupingResult;
import com.intellij.charts.core.utils.GroupingUtils;
import com.intellij.charts.dataframe.DataFrame;
import com.intellij.charts.dataframe.columns.Column;
import com.intellij.charts.dataframe.columns.ColumnKt;
import com.intellij.charts.dataframe.columns.DoubleColumn;
import com.intellij.charts.settings.data.ColumnSettings;
import com.intellij.charts.settings.data.SeriesSettings;
import com.intellij.charts.settings.data.type.AreaSeriesType;
import com.intellij.charts.settings.data.type.SeriesType;
import com.intellij.charts.style.ChartsConfig;
import com.intellij.charts.utils.ChartJsonUtilsKt;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.geom.geomArea;
import org.jetbrains.letsPlot.intern.Feature;
import org.jetbrains.letsPlot.intern.layer.SamplingOptions;
import org.jetbrains.letsPlot.intern.layer.geom.AreaMapping;
import org.jetbrains.letsPlot.label.LabsKt;
import org.jetbrains.letsPlot.tooltips.layerTooltips;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001BM\b\u0016\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000b\u0010\u000fJ\b\u0010\u001e\u001a\u00020\u000eH\u0016J\b\u0010\u001f\u001a\u00020\nH\u0016J\u0014\u0010 \u001a\u00020\n2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0096\u0082\u0004J\u0010\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%H\u0016J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u00032\u0006\u0010$\u001a\u00020%2\u0006\u0010(\u001a\u00020)H\u0016J\n\u0010*\u001a\u00020)H\u0096\u0080\u0004R\u0014\u0010\u0007\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u0017\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006+"}, d2={"Lcom/intellij/charts/settings/data/AreaSeriesSettings;", "Lcom/intellij/charts/settings/data/SeriesSettings;", "keys", "", "Lcom/intellij/charts/settings/data/ColumnSettings;", "groups", "values", "type", "Lcom/intellij/charts/core/series/AreaSeries$Type;", "showLegend", "", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Lcom/intellij/charts/core/series/AreaSeries$Type;Z)V", "json", "Lcom/google/gson/JsonObject;", "(Lcom/google/gson/JsonObject;)V", "Lcom/intellij/charts/settings/data/type/SeriesType;", "getType", "()Lcom/intellij/charts/settings/data/type/SeriesType;", "getKeys", "()Ljava/util/List;", "getGroups", "getValues", "areaType", "getAreaType", "()Lcom/intellij/charts/core/series/AreaSeries$Type;", "getShowLegend", "()Z", "setShowLegend", "(Z)V", "toJson", "isEmpty", "equals", "other", "", "filterByNewDataFrame", "dataFrame", "Lcom/intellij/charts/dataframe/DataFrame;", "getLetsPlotLayer", "Lorg/jetbrains/letsPlot/intern/Feature;", "chartIndex", "", "hashCode", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nAreaSeriesSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AreaSeriesSettings.kt\ncom/intellij/charts/settings/data/AreaSeriesSettings\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,188:1\n23#2:189\n1915#3,2:190\n1915#3,2:192\n1915#3,2:194\n*S KotlinDebug\n*F\n+ 1 AreaSeriesSettings.kt\ncom/intellij/charts/settings/data/AreaSeriesSettings\n*L\n87#1:189\n112#1:190,2\n126#1:192,2\n139#1:194,2\n*E\n"})
public final class AreaSeriesSettings
extends SeriesSettings {
    @NotNull
    private final SeriesType type;
    @NotNull
    private final List<ColumnSettings> keys;
    @NotNull
    private final List<ColumnSettings> groups;
    @NotNull
    private final List<ColumnSettings> values;
    @NotNull
    private final AreaSeries.Type areaType;
    private boolean showLegend;

    @Override
    @NotNull
    public SeriesType getType() {
        return this.type;
    }

    @NotNull
    public final List<ColumnSettings> getKeys() {
        return this.keys;
    }

    @NotNull
    public final List<ColumnSettings> getGroups() {
        return this.groups;
    }

    @NotNull
    public final List<ColumnSettings> getValues() {
        return this.values;
    }

    @NotNull
    public final AreaSeries.Type getAreaType() {
        return this.areaType;
    }

    public final boolean getShowLegend() {
        return this.showLegend;
    }

    public final void setShowLegend(boolean bl) {
        this.showLegend = bl;
    }

    public AreaSeriesSettings(@NotNull List<ColumnSettings> keys, @NotNull List<ColumnSettings> groups2, @NotNull List<ColumnSettings> values2, @NotNull AreaSeries.Type type, boolean showLegend) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter(groups2, (String)"groups");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.type = AreaSeriesType.Companion.getInstance();
        this.keys = keys;
        this.groups = groups2;
        this.values = values2;
        this.areaType = type;
        this.showLegend = showLegend;
    }

    public /* synthetic */ AreaSeriesSettings(List list2, List list3, List list4, AreaSeries.Type type, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            type = AreaSeries.Type.Stacked;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(list2, list3, list4, type, bl);
    }

    public AreaSeriesSettings(@NotNull JsonObject json) {
        AreaSeries.Type type;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.type = AreaSeriesType.Companion.getInstance();
        this.keys = ChartJsonUtilsKt.optColumnSettingsList(json, "keys");
        this.groups = ChartJsonUtilsKt.optColumnSettingsList(json, "groups");
        this.values = ChartJsonUtilsKt.optColumnSettingsList(json, "values");
        if (json.has("areaType")) {
            String string = json.get("areaType").getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
            type = AreaSeries.Type.valueOf(string);
        } else {
            type = AreaSeries.Type.Stacked;
        }
        this.areaType = type;
        this.showLegend = ChartJsonUtilsKt.optBoolean(json, "showLegend");
    }

    @Override
    @NotNull
    public JsonObject toJson() {
        JsonObject jsonObject;
        JsonObject $this$toJson_u24lambda_u240 = jsonObject = new JsonObject();
        boolean bl = false;
        $this$toJson_u24lambda_u240.addProperty("type", this.getType().getId());
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "keys", this.keys);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "groups", this.groups);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "values", this.values);
        $this$toJson_u24lambda_u240.addProperty("areaType", this.areaType.name());
        ChartJsonUtilsKt.optSetProperty($this$toJson_u24lambda_u240, "showLegend", this.showLegend);
        return jsonObject;
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty() && this.groups.isEmpty() && this.values.isEmpty();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof AreaSeriesSettings && Intrinsics.areEqual(((AreaSeriesSettings)other).keys, this.keys) && Intrinsics.areEqual(((AreaSeriesSettings)other).groups, this.groups) && Intrinsics.areEqual(((AreaSeriesSettings)other).values, this.values) && ((AreaSeriesSettings)other).areaType == this.areaType && ((AreaSeriesSettings)other).showLegend == this.showLegend;
    }

    @Override
    @NotNull
    public AreaSeriesSettings filterByNewDataFrame(@NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        return new AreaSeriesSettings(SeriesSettings.Companion.filterByDataFrame(this.keys, dataFrame), SeriesSettings.Companion.filterByDataFrame(this.groups, dataFrame), SeriesSettings.Companion.filterByDataFrame(this.values, dataFrame), this.areaType, this.showLegend);
    }

    @Override
    @NotNull
    public List<Feature> getLetsPlotLayer(@NotNull DataFrame dataFrame, int chartIndex) {
        int i;
        int n;
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        if (this.keys.isEmpty() || this.values.isEmpty()) {
            AreaSeriesSettings $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(AreaSeriesSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn("Area settings series should have at least one X and one Y axis.");
            return CollectionsKt.emptyList();
        }
        List[] $this$thisLogger$iv = new List[]{this.keys, this.groups, this.values};
        if (!SeriesSettings.Companion.dataFrameHasAllColumns(dataFrame, $this$thisLogger$iv)) {
            return CollectionsKt.emptyList();
        }
        GroupingResult groupingResult = GroupingUtils.INSTANCE.get(dataFrame, this.keys, this.groups, this.values);
        if (groupingResult == null) {
            return CollectionsKt.emptyList();
        }
        GroupingResult res = groupingResult;
        ArrayList<Double> previousColumnData = new ArrayList<Double>(res.getXColumn().getSize());
        int n2 = res.getXColumn().getSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            previousColumnData.add(0.0);
        }
        DoubleColumn previousColumn = null;
        previousColumn = new DoubleColumn("", (List<Double>)previousColumnData);
        ArrayList<Double> sums = new ArrayList<Double>(res.getXColumn().getSize());
        if (this.areaType == AreaSeries.Type.Expanded) {
            n = res.getXColumn().getSize();
            for (i = 0; i < n; ++i) {
                double sum2 = 0.0;
                Iterable $this$forEach$iv = res.getYColumns();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Column it = (Column)element$iv;
                    boolean bl = false;
                    sum2 += Math.abs(ColumnKt.getDoubleOrZero(it, i));
                }
                sums.add(sum2);
            }
        }
        if (this.areaType == AreaSeries.Type.Stream) {
            n = res.getXColumn().getSize();
            for (i = 0; i < n; ++i) {
                double sum3 = 0.0;
                int count2 = 0;
                Iterable $this$forEach$iv = res.getYColumns();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Column it = (Column)element$iv;
                    boolean bl = false;
                    if (!it.isNotNull(i)) continue;
                    sum3 += Math.abs(ColumnKt.getDoubleOrZero(it, i));
                    ++count2;
                }
                previousColumnData.set(i, count2 == 1 ? sum3 / (double)2 : (count2 > 0 ? sum3 / (double)count2 : 0.0));
            }
        }
        List result2 = new ArrayList();
        Iterable $this$forEach$iv = res.getYColumns();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Column it = (Column)element$iv;
            boolean bl = false;
            ArrayList<Double> data = new ArrayList<Double>(previousColumn.getSize());
            if (WhenMappings.$EnumSwitchMapping$0[this.areaType.ordinal()] == 1) {
                var16_33 = previousColumn.getSize();
                for (i = 0; i < var16_33; ++i) {
                    double d = ColumnKt.getDoubleOrZero(previousColumn, i);
                    double d2 = ColumnKt.getDoubleOrZero(it, i) * (double)100;
                    Object e = sums.get(i);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                    data.add(d + d2 / ((Number)e).doubleValue());
                }
            } else {
                var16_33 = previousColumn.getSize();
                for (i = 0; i < var16_33; ++i) {
                    data.add(ColumnKt.getDoubleOrZero(previousColumn, i) + ColumnKt.getDoubleOrZero(it, i));
                }
            }
            DoubleColumn currentColumn = new DoubleColumn(it.getName(), (List<Double>)data);
            Pair[] i3 = new Pair[]{TuplesKt.to((Object)res.getXColumn().getName(), res.getXColumn().toList()), TuplesKt.to((Object)currentColumn.getName(), currentColumn.toList())};
            Map chartData = MapsKt.mutableMapOf((Pair[])i3);
            Color color = ChartsConfig.Companion.getInstance().getSettings().getPaletteColor(chartIndex + result2.size());
            Collection collection = result2;
            SamplingOptions samplingOptions = SeriesSettings.Companion.getSampling(res);
            layerTooltips layerTooltips2 = new layerTooltips(new String[0]).line(res.getXColumn().getName() + "|@{" + res.getXColumn().getName() + "}").line(currentColumn.getName() + "|@{" + currentColumn.getName() + "}");
            collection.add(new geomArea(chartData, null, null, false, null, null, samplingOptions, layerTooltips2, null, null, null, 0.3, color, color, null, null, null, null, arg_0 -> AreaSeriesSettings.getLetsPlotLayer$lambda$2$0(res, currentColumn, arg_0), 247606, null));
            previousColumn = currentColumn;
        }
        return CollectionsKt.plus((Collection)result2, (Object)LabsKt.ylab(SeriesSettings.Companion.getPresentableAxisText$default(SeriesSettings.Companion, this.values, null, 2, null)));
    }

    public int hashCode() {
        int result2 = this.getType().hashCode();
        result2 = 31 * result2 + ((Object)this.keys).hashCode();
        result2 = 31 * result2 + ((Object)this.groups).hashCode();
        result2 = 31 * result2 + ((Object)this.values).hashCode();
        result2 = 31 * result2 + this.areaType.hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.showLegend);
        return result2;
    }

    private static final Unit getLetsPlotLayer$lambda$2$0(GroupingResult $res, DoubleColumn $currentColumn, AreaMapping $this$geomArea) {
        Intrinsics.checkNotNullParameter((Object)$this$geomArea, (String)"$this$geomArea");
        $this$geomArea.setX($res.getXColumn().getName());
        $this$geomArea.setY($currentColumn.getName());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AreaSeries.Type.values().length];
            try {
                nArray[AreaSeries.Type.Expanded.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

