/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleSegment;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.CrossBarGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.DimensionUnit;
import org.jetbrains.letsPlot.core.plot.base.geom.DimensionsUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.WithWidth;
import org.jetbrains.letsPlot.core.plot.base.geom.annotation.Annotation;
import org.jetbrains.letsPlot.core.plot.base.geom.annotation.CrossBarAnnotation;
import org.jetbrains.letsPlot.core.plot.base.geom.util.BoxHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.RectangleTooltipHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.RectanglesHelper;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TipLayoutHint;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 02\u00020\u00012\u00020\u0002:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0003J0\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u001e\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010#0!2\u0006\u0010$\u001a\u00020%H\u0002J\u001e\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010'0!2\u0006\u0010$\u001a\u00020%H\u0002J0\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\"2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00050,2\u0006\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020/H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u00061"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/CrossBarGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/WithWidth;", "()V", "fattenMidline", "", "getFattenMidline", "()D", "setFattenMidline", "(D)V", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "widthUnit", "Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;", "getWidthUnit", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;", "setWidthUnit", "(Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;)V", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "midLineByDataPoint", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleSegment;", "geomHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "rectByDataPoint", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "widthSpan", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "p", "coordAes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "resolution", "isDiscrete", "", "Companion", "plot-base"})
public final class CrossBarGeom
extends GeomBase
implements WithWidth {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double fattenMidline = 2.5;
    @NotNull
    private DimensionUnit widthUnit = DEF_WIDTH_UNIT;
    public static final boolean HANDLES_GROUPS = false;
    @NotNull
    private static final DimensionUnit DEF_WIDTH_UNIT = DimensionUnit.RESOLUTION;

    public final double getFattenMidline() {
        return this.fattenMidline;
    }

    public final void setFattenMidline(double d) {
        this.fattenMidline = d;
    }

    @NotNull
    public final DimensionUnit getWidthUnit() {
        return this.widthUnit;
    }

    public final void setWidthUnit(@NotNull DimensionUnit dimensionUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)dimensionUnit), (String)"<set-?>");
        this.widthUnit = dimensionUnit;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return BoxHelper.INSTANCE.legendFactory(false, !(this.fattenMidline == 0.0));
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
            Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
            GeomHelper geomHelper = new GeomHelper(pos, coord, ctx2);
            RectanglesHelper helper2 = new RectanglesHelper(aesthetics2, pos, coord, ctx2, this.rectByDataPoint(geomHelper));
            Object[] objectArray = new Aes[]{Aes.Companion.getYMIN(), Aes.Companion.getY(), Aes.Companion.getYMAX()};
            RectangleTooltipHelper tooltipHelper2 = new RectangleTooltipHelper(pos, coord, ctx2, CollectionsKt.listOf((Object[])objectArray), TipLayoutHint.Kind.CURSOR_TOOLTIP, buildIntern.tooltipHelper.1.INSTANCE, null, 64, null);
            HashMap<DataPointAesthetics, DoubleRectangle> rectangles = new HashMap<DataPointAesthetics, DoubleRectangle>();
            HashMap<Integer, DoubleSegment> midLines = new HashMap<Integer, DoubleSegment>();
            helper2.createRectangles((Function3<? super DataPointAesthetics, ? super SvgNode, ? super DoubleRectangle, Unit>)((Function3)new Function3<DataPointAesthetics, SvgNode, DoubleRectangle, Unit>(root, tooltipHelper2, rectangles){
                final /* synthetic */ SvgRoot $root;
                final /* synthetic */ RectangleTooltipHelper $tooltipHelper;
                final /* synthetic */ HashMap<DataPointAesthetics, DoubleRectangle> $rectangles;
                {
                    this.$root = $root;
                    this.$tooltipHelper = $tooltipHelper;
                    this.$rectangles = $rectangles;
                    super(3);
                }

                public final void invoke(@NotNull DataPointAesthetics aes2, @NotNull SvgNode svgNode, @NotNull DoubleRectangle rect2) {
                    Intrinsics.checkNotNullParameter((Object)aes2, (String)"aes");
                    Intrinsics.checkNotNullParameter((Object)svgNode, (String)"svgNode");
                    Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
                    this.$root.add(svgNode);
                    this.$tooltipHelper.addTarget(aes2, rect2);
                    ((Map)this.$rectangles).put(aes2, rect2);
                }
            }));
            BoxHelper.INSTANCE.buildMidlines(aesthetics2, this.fattenMidline, geomHelper, this.midLineByDataPoint(geomHelper), (Function3<? super DataPointAesthetics, ? super SvgNode, ? super DoubleSegment, Unit>)((Function3)new Function3<DataPointAesthetics, SvgNode, DoubleSegment, Unit>(root, midLines){
                final /* synthetic */ SvgRoot $root;
                final /* synthetic */ HashMap<Integer, DoubleSegment> $midLines;
                {
                    this.$root = $root;
                    this.$midLines = $midLines;
                    super(3);
                }

                public final void invoke(@NotNull DataPointAesthetics aes2, @NotNull SvgNode svgNode, @NotNull DoubleSegment segment2) {
                    Intrinsics.checkNotNullParameter((Object)aes2, (String)"aes");
                    Intrinsics.checkNotNullParameter((Object)svgNode, (String)"svgNode");
                    Intrinsics.checkNotNullParameter((Object)segment2, (String)"segment");
                    this.$root.add(svgNode);
                    ((Map)this.$midLines).put(aes2.index(), segment2);
                }
            }));
            Annotation annotation = ctx2.getAnnotation();
            if (annotation == null) break block0;
            Annotation it = annotation;
            boolean bl = false;
            CrossBarAnnotation.INSTANCE.build(root, (Map<DataPointAesthetics, DoubleRectangle>)rectangles, (Map<Integer, DoubleSegment>)midLines, this.fattenMidline, coord, ctx2);
        }
    }

    @Override
    @Nullable
    public DoubleSpan widthSpan(@NotNull DataPointAesthetics p, @NotNull Aes<Double> coordAes, double resolution, boolean isDiscrete) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(coordAes, (String)"coordAes");
        return DimensionsUtil.INSTANCE.dimensionSpan(p, coordAes, Aes.Companion.getWIDTH(), resolution, this.widthUnit);
    }

    private final Function1<DataPointAesthetics, DoubleRectangle> rectByDataPoint(GeomHelper geomHelper) {
        return (Function1)new Function1<DataPointAesthetics, DoubleRectangle>(geomHelper, this){
            final /* synthetic */ GeomHelper $geomHelper;
            final /* synthetic */ CrossBarGeom this$0;
            {
                this.$geomHelper = $geomHelper;
                this.this$0 = $receiver;
                super(1, Intrinsics.Kotlin.class, "factory", "rectByDataPoint$factory(Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;Lorg/jetbrains/letsPlot/core/plot/base/geom/CrossBarGeom;Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;)Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", 0);
            }

            @Nullable
            public final DoubleRectangle invoke(@NotNull DataPointAesthetics p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return CrossBarGeom.access$rectByDataPoint$factory(this.$geomHelper, this.this$0, p0);
            }
        };
    }

    private final Function1<DataPointAesthetics, DoubleSegment> midLineByDataPoint(GeomHelper geomHelper) {
        return (Function1)new Function1<DataPointAesthetics, DoubleSegment>(geomHelper, this){
            final /* synthetic */ GeomHelper $geomHelper;
            final /* synthetic */ CrossBarGeom this$0;
            {
                this.$geomHelper = $geomHelper;
                this.this$0 = $receiver;
                super(1, Intrinsics.Kotlin.class, "factory", "midLineByDataPoint$factory$1(Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;Lorg/jetbrains/letsPlot/core/plot/base/geom/CrossBarGeom;Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;)Lorg/jetbrains/letsPlot/commons/geometry/DoubleSegment;", 0);
            }

            @Nullable
            public final DoubleSegment invoke(@NotNull DataPointAesthetics p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return CrossBarGeom.access$midLineByDataPoint$factory$1(this.$geomHelper, this.this$0, p0);
            }
        };
    }

    private static final DoubleRectangle rectByDataPoint$factory(GeomHelper $geomHelper, CrossBarGeom this$0, DataPointAesthetics p) {
        Double d = p.finiteOrNull(Aes.Companion.getX());
        if (d == null) {
            return null;
        }
        double x2 = d;
        Double d2 = p.finiteOrNull(Aes.Companion.getYMIN());
        if (d2 == null) {
            return null;
        }
        double ymin = d2;
        Double d3 = p.finiteOrNull(Aes.Companion.getYMAX());
        if (d3 == null) {
            return null;
        }
        double ymax = d3;
        Double d4 = p.finiteOrNull(Aes.Companion.getWIDTH());
        if (d4 == null) {
            return null;
        }
        double w = d4;
        double width2 = w * $geomHelper.getUnitResolution(this$0.widthUnit, Aes.Companion.getX());
        DoubleVector origin = new DoubleVector(x2 - width2 / (double)2, ymin);
        DoubleVector dimension = new DoubleVector(width2, ymax - ymin);
        return new DoubleRectangle(origin, dimension);
    }

    private static final DoubleSegment midLineByDataPoint$factory$1(GeomHelper $geomHelper, CrossBarGeom this$0, DataPointAesthetics p) {
        Double d = p.finiteOrNull(Aes.Companion.getX());
        if (d == null) {
            return null;
        }
        double x2 = d;
        Double d2 = p.finiteOrNull(Aes.Companion.getY());
        if (d2 == null) {
            return null;
        }
        double y2 = d2;
        Double d3 = p.finiteOrNull(Aes.Companion.getWIDTH());
        if (d3 == null) {
            return null;
        }
        double w = d3;
        double width2 = w * $geomHelper.getUnitResolution(this$0.widthUnit, Aes.Companion.getX());
        return new DoubleSegment(new DoubleVector(x2 - width2 / (double)2, y2), new DoubleVector(x2 + width2 / (double)2, y2));
    }

    public static final /* synthetic */ DoubleRectangle access$rectByDataPoint$factory(GeomHelper $geomHelper, CrossBarGeom this$0, DataPointAesthetics p) {
        return CrossBarGeom.rectByDataPoint$factory($geomHelper, this$0, p);
    }

    public static final /* synthetic */ DoubleSegment access$midLineByDataPoint$factory$1(GeomHelper $geomHelper, CrossBarGeom this$0, DataPointAesthetics p) {
        return CrossBarGeom.midLineByDataPoint$factory$1($geomHelper, this$0, p);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/CrossBarGeom$Companion;", "", "()V", "DEF_WIDTH_UNIT", "Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;", "HANDLES_GROUPS", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

