/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.com.github.weisj.jsvg.nodes;

import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.size.Length;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.size.MeasureContext;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.size.Unit;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.AbstractGradient;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.Stop;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.animation.Animate;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.animation.AnimateTransform;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.animation.Set;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.prototype.spec.Category;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import org.jetbrains.relocated.com.github.weisj.jsvg.parser.AttributeNode;

@ElementCategories(value={Category.Gradient})
@PermittedContent(categories={Category.Descriptive}, anyOf={Stop.class, Animate.class, AnimateTransform.class, Set.class})
public final class LinearGradient
extends AbstractGradient<LinearGradient> {
    public static final String TAG = "lineargradient";
    private Length x1;
    private Length x2;
    private Length y1;
    private Length y2;

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    @Override
    protected void buildGradient(@NotNull AttributeNode attributeNode, @Nullable LinearGradient template) {
        this.x1 = attributeNode.getLength("x1", template != null ? template.x1 : Unit.PERCENTAGE.valueOf(0.0f));
        this.x2 = attributeNode.getLength("x2", template != null ? template.x2 : Unit.PERCENTAGE.valueOf(100.0f));
        this.y1 = attributeNode.getLength("y1", template != null ? template.y1 : Unit.PERCENTAGE.valueOf(0.0f));
        this.y2 = attributeNode.getLength("y2", template != null ? template.y2 : Unit.PERCENTAGE.valueOf(0.0f));
    }

    @Override
    @NotNull
    protected Paint gradientForBounds(@NotNull MeasureContext measure, @NotNull Rectangle2D bounds, float[] gradOffsets, @NotNull Color[] gradColors) {
        Point2D.Float pt2;
        Point2D.Float pt1 = new Point2D.Float(this.x1.resolveWidth(measure), this.y1.resolveHeight(measure));
        if (pt1.equals(pt2 = new Point2D.Float(this.x2.resolveWidth(measure), this.y2.resolveHeight(measure)))) {
            return gradColors[0];
        }
        return new LinearGradientPaint(pt1, pt2, gradOffsets, gradColors, this.spreadMethod.cycleMethod(), MultipleGradientPaint.ColorSpaceType.SRGB, this.computeViewTransform(bounds));
    }

    @Override
    public String toString() {
        return "LinearGradient{spreadMethod=" + (Object)((Object)this.spreadMethod) + ", gradientTransform=" + this.gradientTransform + ", x1=" + this.x1 + ", x2=" + this.x2 + ", y1=" + this.y1 + ", y2=" + this.y2 + ", colors=" + Arrays.toString(this.colors()) + ", offsets=" + Arrays.toString(this.offsets()) + '}';
    }
}

