/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.com.github.weisj.jsvg.parser;

import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.relocated.com.github.weisj.jsvg.parser.ResourceLoader;
import org.jetbrains.relocated.com.github.weisj.jsvg.parser.SwingUIFuture;
import org.jetbrains.relocated.com.github.weisj.jsvg.parser.UIFuture;
import org.jetbrains.relocated.com.github.weisj.jsvg.parser.resources.RenderableResource;
import org.jetbrains.relocated.com.github.weisj.jsvg.util.ResourceUtil;

public final class AsynchronousResourceLoader
implements ResourceLoader {
    private static final Logger LOGGER = Logger.getLogger(AsynchronousResourceLoader.class.getName());

    @Override
    @NotNull
    public UIFuture<RenderableResource> loadImage(@NotNull URI uri) {
        return new SwingUIFuture<RenderableResource>(() -> {
            try {
                return ResourceUtil.loadImage(uri);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                return null;
            }
        });
    }
}

