/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.config.yaml;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.navigation.PsiTargetNavigator;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.ide.DataManager;
import com.intellij.microservices.jvm.config.MicroservicesConfigBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ShowDuplicateKeysQuickFix
implements LocalQuickFix {
    private final String myConfigKey;
    private final Collection<SmartPsiElementPointer<PsiElement>> myDuplicateKeyElements;

    public ShowDuplicateKeysQuickFix(String configKey, Collection<? extends PsiElement> duplicateKeyElements) {
        this.myConfigKey = configKey;
        PsiElement psiElement = (PsiElement)ContainerUtil.getFirstItem(duplicateKeyElements);
        assert (psiElement != null) : "Empty collection passed to quick fix";
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)psiElement.getProject());
        this.myDuplicateKeyElements = ContainerUtil.map(duplicateKeyElements, element -> smartPointerManager.createSmartPsiElementPointer(element));
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        if (project == null) {
            ShowDuplicateKeysQuickFix.$$$reportNull$$$0(0);
        }
        if (previewDescriptor == null) {
            ShowDuplicateKeysQuickFix.$$$reportNull$$$0(1);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            ShowDuplicateKeysQuickFix.$$$reportNull$$$0(2);
        }
        return intentionPreviewInfo;
    }

    @IntentionName
    @NotNull
    public String getName() {
        String string = MicroservicesConfigBundle.message((String)"config.show.duplicates.for.key", (Object[])new Object[]{this.myConfigKey});
        if (string == null) {
            ShowDuplicateKeysQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = MicroservicesConfigBundle.message((String)"config.show.duplicates", (Object[])new Object[0]);
        if (string == null) {
            ShowDuplicateKeysQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            ShowDuplicateKeysQuickFix.$$$reportNull$$$0(5);
        }
        if (descriptor == null) {
            ShowDuplicateKeysQuickFix.$$$reportNull$$$0(6);
        }
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> new PsiTargetNavigator(() -> ContainerUtil.mapNotNull(this.myDuplicateKeyElements, element -> element.dereference())).createPopup(project, MicroservicesConfigBundle.message((String)"config.duplicates.for", (Object[])new Object[]{this.myConfigKey})).showInBestPositionFor(context));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/microservices/jvm/config/yaml/ShowDuplicateKeysQuickFix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/microservices/jvm/config/yaml/ShowDuplicateKeysQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

