/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.EarlyAccessRegistryManager;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002\u001a;\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0017H\u0082\b\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\"\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\" \u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\"\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "configFile", "Ljava/nio/file/Path;", "getConfigFile", "()Ljava/nio/file/Path;", "configFile$delegate", "Lkotlin/Lazy;", "DISABLE_SAVE_PROPERTY", "", "lazyMap", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "Ljava/util/concurrent/ConcurrentHashMap;", "map", "getMap", "()Ljava/util/concurrent/ConcurrentHashMap;", "getOrFromSystemProperty", "key", "saveConfigFile", "", "provider", "Lkotlin/Function1;", "intellij.platform.core"})
@SourceDebugExtension(value={"SMAP\nEarlyAccessRegistryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EarlyAccessRegistryManager.kt\ncom/intellij/openapi/util/registry/EarlyAccessRegistryManagerKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,237:1\n13#2:238\n*S KotlinDebug\n*F\n+ 1 EarlyAccessRegistryManager.kt\ncom/intellij/openapi/util/registry/EarlyAccessRegistryManagerKt\n*L\n25#1:238\n*E\n"})
public final class EarlyAccessRegistryManagerKt {
    @NotNull
    private static final Lazy configFile$delegate = LazyKt.lazy(EarlyAccessRegistryManagerKt::configFile_delegate$lambda$0);
    @NotNull
    private static final String DISABLE_SAVE_PROPERTY = "early.access.registry.disable.saving";
    @NotNull
    private static final SynchronizedClearableLazy<ConcurrentHashMap<String, String>> lazyMap = new SynchronizedClearableLazy(EarlyAccessRegistryManagerKt::lazyMap$lambda$0);

    private static final Logger getLOG() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EarlyAccessRegistryManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    private static final Path getConfigFile() {
        Lazy lazy = configFile$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Path)object;
    }

    private static final ConcurrentHashMap<String, String> getMap() {
        if (lazyMap.isInitialized()) {
            ConcurrentHashMap map2 = (ConcurrentHashMap)lazyMap.getValue();
            return map2.isEmpty() ? null : map2;
        }
        return null;
    }

    private static final String getOrFromSystemProperty(ConcurrentHashMap<String, String> map2, String key) {
        String string = map2.get(key);
        if (string == null) {
            string = System.getProperty(key);
        }
        return string;
    }

    private static final void saveConfigFile(ConcurrentHashMap<String, String> map2, Path configFile, Function1<? super String, String> provider) {
        Comparable comparable;
        boolean $i$f$saveConfigFile = false;
        if (Intrinsics.areEqual((Object)System.getProperty(DISABLE_SAVE_PROPERTY), (Object)"true")) {
            return;
        }
        List lines = new ArrayList();
        Set set = map2.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        for (String key : CollectionsKt.sorted((Iterable)set)) {
            String value;
            Intrinsics.checkNotNull((Object)key);
            if ((String)provider.invoke((Object)key) == null) continue;
            lines.add(key);
            lines.add(value);
        }
        if (lines.isEmpty()) {
            comparable = Boolean.valueOf(Files.deleteIfExists(configFile));
        } else {
            Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
            comparable = Files.write(configFile, (Iterable<? extends CharSequence>)lines, StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }

    private static final Path configFile_delegate$lambda$0() {
        return PathManager.getOriginalConfigDir().resolve("early-access-registry.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ConcurrentHashMap lazyMap$lambda$0() {
        AutoCloseable autoCloseable;
        ConcurrentHashMap result = new ConcurrentHashMap();
        try {
            autoCloseable = Files.lines(EarlyAccessRegistryManagerKt.getConfigFile());
        }
        catch (NoSuchFileException noSuchFileException) {
            return result;
        }
        Stream<String> lines = autoCloseable;
        autoCloseable = lines;
        Throwable throwable = null;
        try {
            AutoCloseable lineStream = autoCloseable;
            boolean bl = false;
            Iterator iterator = lineStream.iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                if (!iterator.hasNext()) break;
                result.put(key, iterator.next());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            try {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                AutoCloseableKt.closeFinally(autoCloseable, (Throwable)throwable);
                throw throwable3;
            }
        }
        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        return result;
    }

    public static final /* synthetic */ Logger access$getLOG() {
        return EarlyAccessRegistryManagerKt.getLOG();
    }

    public static final /* synthetic */ SynchronizedClearableLazy access$getLazyMap$p() {
        return lazyMap;
    }

    public static final /* synthetic */ String access$getOrFromSystemProperty(ConcurrentHashMap map2, String key) {
        return EarlyAccessRegistryManagerKt.getOrFromSystemProperty(map2, key);
    }

    public static final /* synthetic */ Path access$getConfigFile() {
        return EarlyAccessRegistryManagerKt.getConfigFile();
    }

    public static final /* synthetic */ ConcurrentHashMap access$getMap() {
        return EarlyAccessRegistryManagerKt.getMap();
    }
}

