/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public abstract class TempCopyArchiveHandler
extends ArchiveHandler {
    protected TempCopyArchiveHandler(@NotNull String path) {
        if (path == null) {
            TempCopyArchiveHandler.$$$reportNull$$$0(0);
        }
        super(path);
    }

    protected abstract String getTempDir();

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.removeTempCopy();
    }

    private void removeTempCopy() {
        try {
            NioFiles.deleteRecursively((Path)this.getTempFile());
        }
        catch (IOException e) {
            Logger.getInstance(this.getClass()).error("Failed to delete temp archive " + this.getTempFile(), (Throwable)e);
        }
    }

    @NotNull
    protected Path getTempCopy(@NotNull ThrowableComputable<InputStream, IOException> input) throws IOException {
        if (input == null) {
            TempCopyArchiveHandler.$$$reportNull$$$0(1);
        }
        Path file = this.getPath();
        Path copy = this.getTempFile();
        if (!Files.exists(copy, new LinkOption[0]) || Files.getLastModifiedTime(copy, new LinkOption[0]).toMillis() != Files.getLastModifiedTime(file, new LinkOption[0]).toMillis()) {
            NioFiles.createParentDirectories((Path)copy);
            Files.copy((InputStream)input.compute(), copy, new CopyOption[0]);
            Files.setLastModifiedTime(copy, Files.getLastModifiedTime(file, new LinkOption[0]));
        }
        Path path = copy;
        if (path == null) {
            TempCopyArchiveHandler.$$$reportNull$$$0(2);
        }
        return path;
    }

    private Path getTempFile() {
        Path file = this.getPath();
        String hash = Integer.toHexString(file.toString().hashCode());
        return PathManager.getSystemDir().resolve(this.getTempDir()).resolve(file.getFileName() + "_" + hash);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/TempCopyArchiveHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/TempCopyArchiveHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTempCopy";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

