/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.syntax;

import com.intellij.json.syntax.JsonSyntaxElementTypes;
import com.intellij.platform.syntax.SyntaxElementType;
import com.intellij.platform.syntax.parser.SyntaxTreeBuilder;
import com.intellij.platform.syntax.util.runtime.SyntaxGeneratedParserRuntime;
import com.intellij.platform.syntax.util.runtime.SyntaxRuntimeBundle;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a(\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"consumeArrayContentIfTooDeep", "", "runtime", "Lcom/intellij/platform/syntax/util/runtime/SyntaxGeneratedParserRuntime;", "level", "", "consumeObjectContentIfTooDeep", "consumeContentIfTooDeep", "name", "", "closingToken", "Lcom/intellij/platform/syntax/SyntaxElementType;", "intellij.json.syntax"})
@JvmName(name="JsonSyntaxParserUtil")
public final class JsonSyntaxParserUtil {
    public static final boolean consumeArrayContentIfTooDeep(@NotNull SyntaxGeneratedParserRuntime runtime, int level) {
        return JsonSyntaxParserUtil.consumeContentIfTooDeep(runtime, level, "array", JsonSyntaxElementTypes.INSTANCE.getR_BRACKET());
    }

    public static final boolean consumeObjectContentIfTooDeep(@NotNull SyntaxGeneratedParserRuntime runtime, int level) {
        return JsonSyntaxParserUtil.consumeContentIfTooDeep(runtime, level, "objet", JsonSyntaxElementTypes.INSTANCE.getR_CURLY());
    }

    private static final boolean consumeContentIfTooDeep(SyntaxGeneratedParserRuntime runtime, int level, String name, SyntaxElementType closingToken) {
        if (level + 1 < runtime.getMaxRecursionDepth()) {
            return true;
        }
        SyntaxTreeBuilder builder = runtime.getSyntaxBuilder();
        Object[] objectArray = new Object[]{runtime.getMaxRecursionDepth(), name};
        builder.error(SyntaxRuntimeBundle.message((String)"parsing.error.maximum.recursion.level.reached.in", (Object[])objectArray));
        while (!Intrinsics.areEqual((Object)builder.getTokenType(), (Object)closingToken) && builder.getTokenType() != null) {
            builder.advanceLexer();
        }
        return true;
    }
}

