/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.GError;
import com.intellij.credentialStore.GErrorByRef;
import com.intellij.credentialStore.LinuxSecretLibraryKt;
import com.intellij.credentialStore.SecretLibrary;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.text.StringKt;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.io.Closeable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 (2\u00020\u0001:\u0001(B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0096\u0002J\u001b\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\u001a\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00072\b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u0002J?\u0010\u001e\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\u0006\u0010 \u001a\u00020\u00032!\u0010!\u001a\u001d\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0004\u0012\u0002H\u001f0\"H\u0082\b\u00a2\u0006\u0002\u0010'R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000b\u001a\u0004\b\r\u0010\tR\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000b\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006)"}, d2={"Lcom/intellij/credentialStore/SecretCredentialStore;", "Lcom/intellij/credentialStore/CredentialStore;", "schemeName", "", "<init>", "(Ljava/lang/String;)V", "serviceAttributeNamePointer", "Lcom/sun/jna/Memory;", "getServiceAttributeNamePointer", "()Lcom/sun/jna/Memory;", "serviceAttributeNamePointer$delegate", "Lkotlin/Lazy;", "accountAttributeNamePointer", "getAccountAttributeNamePointer", "accountAttributeNamePointer$delegate", "schema", "Lcom/sun/jna/Pointer;", "getSchema", "()Lcom/sun/jna/Pointer;", "schema$delegate", "get", "Lcom/intellij/credentialStore/Credentials;", "attributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "set", "", "credentials", "clearPassword", "serviceNamePointer", "accountName", "checkError", "T", "method", "task", "Lkotlin/Function1;", "Lcom/intellij/credentialStore/GErrorByRef;", "Lkotlin/ParameterName;", "name", "errorRef", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "intellij.platform.credentialStore.impl"})
@SourceDebugExtension(value={"SMAP\nlinuxSecretLibrary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 linuxSecretLibrary.kt\ncom/intellij/credentialStore/SecretCredentialStore\n*L\n1#1,211:1\n164#1,15:212\n164#1,15:227\n164#1,15:242\n*S KotlinDebug\n*F\n+ 1 linuxSecretLibrary.kt\ncom/intellij/credentialStore/SecretCredentialStore\n*L\n129#1:212,15\n148#1:227,15\n86#1:242,15\n*E\n"})
public final class SecretCredentialStore
implements CredentialStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy serviceAttributeNamePointer$delegate = LazyKt.lazy(SecretCredentialStore::serviceAttributeNamePointer_delegate$lambda$0);
    @NotNull
    private final Lazy accountAttributeNamePointer$delegate = LazyKt.lazy(SecretCredentialStore::accountAttributeNamePointer_delegate$lambda$0);
    @NotNull
    private final Lazy schema$delegate = LazyKt.lazy(() -> SecretCredentialStore.schema_delegate$lambda$0(schemeName, this));
    private static final SecretLibrary library = (SecretLibrary)Native.load((String)"secret-1", SecretLibrary.class);
    private static final int DBUS_ERROR = library.g_dbus_error_quark();
    private static final int SECRET_ERROR = library.secret_error_get_quark();

    private SecretCredentialStore(String schemeName) {
    }

    private final Memory getServiceAttributeNamePointer() {
        Lazy lazy = this.serviceAttributeNamePointer$delegate;
        return (Memory)lazy.getValue();
    }

    private final Memory getAccountAttributeNamePointer() {
        Lazy lazy = this.accountAttributeNamePointer$delegate;
        return (Memory)lazy.getValue();
    }

    private final Pointer getSchema() {
        Lazy lazy = this.schema$delegate;
        return (Pointer)lazy.getValue();
    }

    @Nullable
    public Credentials get(@NotNull CredentialAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        long start = System.currentTimeMillis();
        try {
            Credentials credentials = CompletableFuture.supplyAsync(() -> SecretCredentialStore.get$lambda$0(attributes, this), AppExecutorUtil.getAppExecutorService()).get(30L, TimeUnit.SECONDS);
            long end = System.currentTimeMillis();
            if (credentials == null && end - start > 300L) {
                return CredentialAttributesKt.getACCESS_TO_KEY_CHAIN_DENIED();
            }
            return credentials;
        }
        catch (TimeoutException timeoutException) {
            CredentialStoreKt.getLOG().warn("storage unlock timeout");
            return CredentialAttributesKt.getCANNOT_UNLOCK_KEYCHAIN();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void set(@NotNull CredentialAttributes attributes, @Nullable Credentials credentials) {
        GErrorByRef errorRef$iv;
        String lookupName;
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        String string = attributes.getServiceName();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        Memory serviceNamePointer = LinuxSecretLibraryKt.stringPointer$default(byArray, false, 2, null);
        String string2 = StringKt.nullize$default((String)attributes.getUserName(), (boolean)false, (int)1, null);
        if (string2 == null) {
            Credentials credentials2 = credentials;
            string2 = credentials2 != null ? credentials2.getUserName() : null;
        }
        String accountName = string2;
        String string3 = lookupName = Intrinsics.areEqual((Object)attributes.getServiceName(), (Object)"IntelliJ Platform") ? accountName : null;
        if (CredentialAttributesKt.isEmpty((Credentials)credentials)) {
            this.clearPassword(serviceNamePointer, lookupName);
            return;
        }
        Credentials credentials3 = credentials;
        Intrinsics.checkNotNull((Object)credentials3);
        byte[] byArray2 = CredentialStoreKt.joinData(credentials3.getUserName(), attributes.isPasswordMemoryOnly() ? null : credentials.getPassword());
        Intrinsics.checkNotNull((Object)byArray2);
        Memory passwordPointer = LinuxSecretLibraryKt.stringPointer(byArray2, true);
        SecretCredentialStore secretCredentialStore = this;
        String method$iv = "secret_password_store_sync";
        boolean $i$f$checkError = false;
        GErrorByRef errorRef = errorRef$iv = new GErrorByRef();
        boolean bl = false;
        Closeable closeable = (Closeable)passwordPointer;
        Throwable throwable = null;
        try {
            Memory it = (Memory)closeable;
            boolean bl2 = false;
            this.clearPassword(serviceNamePointer, null);
            if (accountName == null) {
                Pointer[] pointerArray = new Pointer[]{this.getServiceAttributeNamePointer(), serviceNamePointer, null};
                library.secret_password_store_sync(this.getSchema(), null, (Pointer)serviceNamePointer, (Pointer)passwordPointer, null, errorRef, pointerArray);
            } else {
                Pointer pointer = this.getSchema();
                Pointer pointer2 = (Pointer)serviceNamePointer;
                Pointer pointer3 = (Pointer)passwordPointer;
                Pointer[] pointerArray = new Pointer[5];
                pointerArray[0] = this.getServiceAttributeNamePointer();
                pointerArray[1] = serviceNamePointer;
                pointerArray[2] = this.getAccountAttributeNamePointer();
                byte[] byArray3 = accountName.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
                pointerArray[3] = LinuxSecretLibraryKt.stringPointer$default(byArray3, false, 2, null);
                pointerArray[4] = null;
                library.secret_password_store_sync(pointer, null, pointer2, pointer3, null, errorRef, pointerArray);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Unit result$iv = Unit.INSTANCE;
        GError error$iv = errorRef$iv.getValue();
        if (error$iv == null) return;
        if (SecretCredentialStore.Companion.isNoSecretService(error$iv)) {
            CredentialStoreKt.getLOG().warn("gnome-keyring not installed or kde doesn't support Secret Service API. " + method$iv + " error code " + error$iv.code + ", error message " + error$iv.message);
        }
        Integer n = error$iv.domain;
        int n2 = SECRET_ERROR;
        if (n != null && n == n2) {
            Integer n3 = error$iv.code;
            n2 = 2;
            if (n3 != null && n3 == n2) {
                CredentialStoreKt.getLOG().warn("Cancelled storage unlock: " + error$iv.message);
                return;
            }
        }
        CredentialStoreKt.getLOG().error(method$iv + " error code " + error$iv.code + ", error message " + error$iv.message);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void clearPassword(Memory serviceNamePointer, String accountName) {
        GErrorByRef errorRef$iv;
        SecretCredentialStore secretCredentialStore = this;
        String method$iv = "secret_password_clear_sync";
        boolean $i$f$checkError = false;
        GErrorByRef errorRef = errorRef$iv = new GErrorByRef();
        boolean bl = false;
        if (accountName == null) {
            Pointer[] pointerArray = new Pointer[]{this.getServiceAttributeNamePointer(), serviceNamePointer, null};
            library.secret_password_clear_sync(this.getSchema(), null, errorRef, pointerArray);
        } else {
            Pointer pointer = this.getSchema();
            Pointer[] pointerArray = new Pointer[5];
            pointerArray[0] = this.getServiceAttributeNamePointer();
            pointerArray[1] = serviceNamePointer;
            pointerArray[2] = this.getAccountAttributeNamePointer();
            byte[] byArray = accountName.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            pointerArray[3] = LinuxSecretLibraryKt.stringPointer$default(byArray, false, 2, null);
            pointerArray[4] = null;
            library.secret_password_clear_sync(pointer, null, errorRef, pointerArray);
        }
        Unit result$iv = Unit.INSTANCE;
        GError error$iv = errorRef$iv.getValue();
        if (error$iv == null) return;
        if (SecretCredentialStore.Companion.isNoSecretService(error$iv)) {
            CredentialStoreKt.getLOG().warn("gnome-keyring not installed or kde doesn't support Secret Service API. " + method$iv + " error code " + error$iv.code + ", error message " + error$iv.message);
        }
        Integer n = error$iv.domain;
        int n2 = SECRET_ERROR;
        if (n != null && n == n2) {
            Integer n3 = error$iv.code;
            n2 = 2;
            if (n3 != null && n3 == n2) {
                CredentialStoreKt.getLOG().warn("Cancelled storage unlock: " + error$iv.message);
                return;
            }
        }
        CredentialStoreKt.getLOG().error(method$iv + " error code " + error$iv.code + ", error message " + error$iv.message);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final <T> T checkError(String method, Function1<? super GErrorByRef, ? extends T> task) {
        boolean $i$f$checkError = false;
        GErrorByRef errorRef = new GErrorByRef();
        Object result = task.invoke((Object)errorRef);
        GError error = errorRef.getValue();
        if (error == null) return (T)result;
        if (SecretCredentialStore.Companion.isNoSecretService(error)) {
            CredentialStoreKt.getLOG().warn("gnome-keyring not installed or kde doesn't support Secret Service API. " + method + " error code " + error.code + ", error message " + error.message);
        }
        Integer n = error.domain;
        int n2 = SECRET_ERROR;
        if (n != null && n == n2) {
            Integer n3 = error.code;
            n2 = 2;
            if (n3 != null && n3 == n2) {
                CredentialStoreKt.getLOG().warn("Cancelled storage unlock: " + error.message);
                return (T)result;
            }
        }
        CredentialStoreKt.getLOG().error(method + " error code " + error.code + ", error message " + error.message);
        return (T)result;
    }

    private static final Memory serviceAttributeNamePointer_delegate$lambda$0() {
        String string = "service";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return LinuxSecretLibraryKt.stringPointer$default(byArray, false, 2, null);
    }

    private static final Memory accountAttributeNamePointer_delegate$lambda$0() {
        String string = "account";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return LinuxSecretLibraryKt.stringPointer$default(byArray, false, 2, null);
    }

    private static final Pointer schema_delegate$lambda$0(String $schemeName, SecretCredentialStore this$0) {
        Object[] objectArray = new Object[]{this$0.getServiceAttributeNamePointer(), 0, this$0.getAccountAttributeNamePointer(), 0, null};
        return library.secret_schema_new($schemeName, 2, objectArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Credentials get$lambda$0(CredentialAttributes $attributes, SecretCredentialStore this$0) {
        Object v2;
        GErrorByRef errorRef$iv;
        String userName = StringKt.nullize$default((String)$attributes.getUserName(), (boolean)false, (int)1, null);
        SecretCredentialStore secretCredentialStore = this$0;
        String method$iv = "secret_password_lookup_sync";
        boolean $i$f$checkError = false;
        GErrorByRef errorRef = errorRef$iv = new GErrorByRef();
        boolean bl = false;
        byte[] byArray = $attributes.getServiceName().getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        Memory serviceNamePointer = LinuxSecretLibraryKt.stringPointer$default(byArray, false, 2, null);
        if (userName == null) {
            Pointer[] pointerArray = new Pointer[]{this$0.getServiceAttributeNamePointer(), serviceNamePointer, null};
            String string = library.secret_password_lookup_sync(this$0.getSchema(), null, errorRef, pointerArray);
            if (string != null) {
                String it = string;
                return CredentialStoreKt.splitData(it);
            }
            v2 = null;
        } else {
            Pointer pointer = this$0.getSchema();
            Pointer[] pointerArray = new Pointer[5];
            pointerArray[0] = this$0.getServiceAttributeNamePointer();
            pointerArray[1] = serviceNamePointer;
            pointerArray[2] = this$0.getAccountAttributeNamePointer();
            byte[] byArray2 = userName.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            pointerArray[3] = LinuxSecretLibraryKt.stringPointer$default(byArray2, false, 2, null);
            pointerArray[4] = null;
            String string = library.secret_password_lookup_sync(pointer, null, errorRef, pointerArray);
            if (string != null) {
                String it = string;
                return CredentialStoreKt.splitData(it);
            }
            v2 = null;
        }
        Object result$iv = v2;
        GError error$iv = errorRef$iv.getValue();
        if (error$iv == null) return result$iv;
        if (SecretCredentialStore.Companion.isNoSecretService(error$iv)) {
            CredentialStoreKt.getLOG().warn("gnome-keyring not installed or kde doesn't support Secret Service API. " + method$iv + " error code " + error$iv.code + ", error message " + error$iv.message);
        }
        Integer n = error$iv.domain;
        int n2 = SECRET_ERROR;
        if (n != null && n == n2) {
            Integer n3 = error$iv.code;
            n2 = 2;
            if (n3 != null && n3 == n2) {
                CredentialStoreKt.getLOG().warn("Cancelled storage unlock: " + error$iv.message);
                return result$iv;
            }
        }
        CredentialStoreKt.getLOG().error(method$iv + " error code " + error$iv.code + ", error message " + error$iv.message);
        return result$iv;
    }

    public /* synthetic */ SecretCredentialStore(String schemeName, DefaultConstructorMarker $constructor_marker) {
        this(schemeName);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/credentialStore/SecretCredentialStore$Companion;", "", "<init>", "()V", "library", "Lcom/intellij/credentialStore/SecretLibrary;", "kotlin.jvm.PlatformType", "DBUS_ERROR", "", "SECRET_ERROR", "create", "Lcom/intellij/credentialStore/SecretCredentialStore;", "schemeName", "", "pingService", "", "isNoSecretService", "error", "Lcom/intellij/credentialStore/GError;", "intellij.platform.credentialStore.impl"})
    @SourceDebugExtension(value={"SMAP\nlinuxSecretLibrary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 linuxSecretLibrary.kt\ncom/intellij/credentialStore/SecretCredentialStore$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,211:1\n1#2:212\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final SecretCredentialStore create(@NotNull String schemeName) {
            Intrinsics.checkNotNullParameter((Object)schemeName, (String)"schemeName");
            return this.pingService() ? new SecretCredentialStore(schemeName, null) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean pingService() {
            Pointer dummySchema;
            Memory attr;
            block12: {
                GError error;
                block11: {
                    Memory memory;
                    boolean bl;
                    attr = null;
                    dummySchema = null;
                    try {
                        Object[] objectArray = "ij-dummy-attribute";
                        byte[] byArray = objectArray.getBytes(Charsets.UTF_8);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                        attr = LinuxSecretLibraryKt.stringPointer$default(byArray, false, 2, null);
                        objectArray = new Object[]{attr, 0, null};
                        dummySchema = library.secret_schema_new("IJ.dummy.ping.schema", 2, objectArray);
                        GErrorByRef errorRef = new GErrorByRef();
                        Pointer[] pointerArray = new Pointer[]{attr, attr};
                        library.secret_password_lookup_sync(dummySchema, null, errorRef, pointerArray);
                        error = errorRef.getValue();
                        if (error != null) break block11;
                        bl = true;
                        memory = attr;
                    }
                    catch (Throwable throwable) {
                        Memory memory2 = attr;
                        if (memory2 != null) {
                            memory2.close();
                        }
                        Pointer pointer = dummySchema;
                        if (pointer != null) {
                            Pointer it = pointer;
                            boolean bl2 = false;
                            library.secret_schema_unref(it);
                        }
                        throw throwable;
                    }
                    if (memory != null) {
                        memory.close();
                    }
                    Pointer pointer = dummySchema;
                    if (pointer != null) {
                        Pointer it = pointer;
                        boolean bl3 = false;
                        library.secret_schema_unref(it);
                    }
                    return bl;
                }
                if (!this.isNoSecretService(error)) break block12;
                boolean bl = false;
                Memory memory = attr;
                if (memory != null) {
                    memory.close();
                }
                Pointer pointer = dummySchema;
                if (pointer != null) {
                    Pointer it = pointer;
                    boolean bl4 = false;
                    library.secret_schema_unref(it);
                }
                return bl;
            }
            Memory memory = attr;
            if (memory != null) {
                memory.close();
            }
            Pointer pointer = dummySchema;
            if (pointer != null) {
                Pointer it = pointer;
                boolean bl = false;
                library.secret_schema_unref(it);
            }
            return true;
        }

        private final boolean isNoSecretService(GError error) {
            boolean bl;
            Integer n = error.domain;
            int n2 = DBUS_ERROR;
            if (n != null && n == n2) {
                Integer n3 = error.code;
                n2 = 2;
                bl = n3 != null && n3 == n2;
            } else {
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

