/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.gpg;

import com.intellij.credentialStore.gpg.GpgToolWrapper;
import com.intellij.credentialStore.gpg.GpgUtilKt;
import com.intellij.credentialStore.gpg.PgpKey;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.SmartList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/credentialStore/gpg/Pgp;", "", "gpgTool", "Lcom/intellij/credentialStore/gpg/GpgToolWrapper;", "<init>", "(Lcom/intellij/credentialStore/gpg/GpgToolWrapper;)V", "listKeys", "", "Lcom/intellij/credentialStore/gpg/PgpKey;", "decrypt", "", "data", "encrypt", "recipient", "", "intellij.platform.credentialStore.impl"})
@ApiStatus.Internal
public final class Pgp {
    @NotNull
    private final GpgToolWrapper gpgTool;

    public Pgp(@NotNull GpgToolWrapper gpgTool) {
        Intrinsics.checkNotNullParameter((Object)gpgTool, (String)"gpgTool");
        this.gpgTool = gpgTool;
    }

    public /* synthetic */ Pgp(GpgToolWrapper gpgToolWrapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            gpgToolWrapper = GpgUtilKt.access$createGpg();
        }
        this(gpgToolWrapper);
    }

    @NotNull
    public final List<PgpKey> listKeys() {
        SmartList result = new SmartList();
        String keyId = null;
        String capabilities = null;
        String string = StringUtilRt.convertLineSeparators((String)this.gpgTool.listSecretKeys());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertLineSeparators(...)");
        char[] cArray = new char[]{'\n'};
        for (String line : StringsKt.splitToSequence$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null)) {
            int i;
            Object object;
            Iterator fields = StringsKt.splitToSequence$default((CharSequence)line, (char[])(object = new char[]{':'}), (boolean)false, (int)0, (int)6, null).iterator();
            if (!fields.hasNext()) continue;
            object = (String)fields.next();
            if (Intrinsics.areEqual((Object)object, (Object)"sec")) {
                for (i = 2; i < 5; ++i) {
                    fields.next();
                }
                keyId = (String)fields.next();
                for (i = 6; i < 12; ++i) {
                    fields.next();
                }
                capabilities = (String)fields.next();
                continue;
            }
            if (!Intrinsics.areEqual((Object)object, (Object)"uid")) continue;
            String string2 = capabilities;
            Intrinsics.checkNotNull(string2);
            if (StringsKt.contains$default((CharSequence)string2, (char)'D', (boolean)false, (int)2, null) || !StringsKt.contains$default((CharSequence)capabilities, (char)'E', (boolean)false, (int)2, null)) continue;
            for (i = 2; i < 10; ++i) {
                fields.next();
            }
            String string3 = keyId;
            Intrinsics.checkNotNull((Object)string3);
            result.add((Object)new PgpKey(string3, StringsKt.replace$default((String)((String)fields.next()), (String)"=\\x3a=", (String)":", (boolean)false, (int)4, null)));
        }
        return (List)result;
    }

    @NotNull
    public final byte[] decrypt(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.gpgTool.decrypt(data);
    }

    @NotNull
    public final byte[] encrypt(@NotNull byte[] data, @NotNull String recipient) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)recipient, (String)"recipient");
        return this.gpgTool.encrypt(data, recipient);
    }

    public Pgp() {
        this(null, 1, null);
    }
}

