/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.SystemIndependent;

public final class ProjectGroup
implements ModificationTracker {
    @NotNull
    @NlsSafe
    private String myName;
    private String myProjectPaths;
    private List<String> myProjects;
    private boolean myExpanded;
    private boolean myTutorials;
    private boolean myBottomGroup;
    private final AtomicInteger modCounter;

    public ProjectGroup(@NotNull @NlsSafe String name) {
        if (name == null) {
            ProjectGroup.$$$reportNull$$$0(0);
        }
        this.myName = "";
        this.myProjects = new ArrayList<String>();
        this.myExpanded = false;
        this.myTutorials = false;
        this.myBottomGroup = false;
        this.modCounter = new AtomicInteger();
        this.myName = name;
    }

    public ProjectGroup() {
        this.myName = "";
        this.myProjects = new ArrayList<String>();
        this.myExpanded = false;
        this.myTutorials = false;
        this.myBottomGroup = false;
        this.modCounter = new AtomicInteger();
    }

    @NotNull
    @NlsSafe
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ProjectGroup.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void setName(@NotNull @NlsSafe String name) {
        if (name == null) {
            ProjectGroup.$$$reportNull$$$0(2);
        }
        this.myName = name;
    }

    public void setProjects(List<String> projects) {
        this.myProjects = projects;
    }

    public String getProjectPaths() {
        return null;
    }

    public void setProjectPaths(String projectPaths) {
        ArrayList<String> paths = new ArrayList<String>(StringUtil.split((String)projectPaths, (String)File.pathSeparator));
        paths.forEach(this::addProject);
        this.modCounter.incrementAndGet();
    }

    public void addProject(@SystemIndependent String path) {
        if (!this.myProjects.contains(path)) {
            this.myProjects.add(path);
            this.modCounter.incrementAndGet();
        }
    }

    public boolean markProjectFirst(@SystemIndependent String path) {
        if (!this.myProjects.contains(path)) {
            return false;
        }
        ArrayList<String> existing = new ArrayList<String>(this.myProjects);
        int index = existing.indexOf(path);
        if (index <= 0) {
            return false;
        }
        ArrayList<String> projects = new ArrayList<String>(existing.size());
        projects.add(path);
        projects.addAll(existing.subList(0, index));
        projects.addAll(existing.subList(index + 1, existing.size()));
        this.save(projects);
        this.modCounter.incrementAndGet();
        return true;
    }

    private void save(@NotNull List<String> projects) {
        if (projects == null) {
            ProjectGroup.$$$reportNull$$$0(3);
        }
        this.myProjects = projects;
    }

    @NotNull
    public List<String> getProjects() {
        List<String> list = this.myProjects;
        if (list == null) {
            ProjectGroup.$$$reportNull$$$0(4);
        }
        return list;
    }

    public boolean removeProject(@SystemIndependent String path) {
        this.modCounter.incrementAndGet();
        return this.myProjects.remove(path);
    }

    public boolean isExpanded() {
        return this.myExpanded;
    }

    public void setExpanded(boolean expanded) {
        this.myExpanded = expanded;
        this.modCounter.incrementAndGet();
    }

    public boolean isTutorials() {
        return this.myTutorials;
    }

    public void setTutorials(boolean tutorials) {
        this.myTutorials = tutorials;
        this.modCounter.incrementAndGet();
    }

    public boolean isBottomGroup() {
        return this.myBottomGroup;
    }

    public void setBottomGroup(boolean bottomGroup) {
        this.myBottomGroup = bottomGroup;
        this.modCounter.incrementAndGet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectGroup group = (ProjectGroup)o;
        return this.myName.equals(group.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    @Transient
    public long getModificationCount() {
        return this.modCounter.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ProjectGroup";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ProjectGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }
}

