/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser;

import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.system.OS;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class FileChooserDescriptorFactory {
    private FileChooserDescriptorFactory() {
    }

    public static FileChooserDescriptor singleFile() {
        return new FileChooserDescriptor(true, false, false, false);
    }

    public static FileChooserDescriptor singleDir() {
        return new FileChooserDescriptor(false, true, false, false);
    }

    public static FileChooserDescriptor singleFileOrDir() {
        return new FileChooserDescriptor(true, true, false, false);
    }

    public static FileChooserDescriptor singleFileOrAppBundle() {
        if (OS.CURRENT == OS.macOS) {
            return new FileChooserDescriptor(true, true, false, false){

                @Override
                public void validateSelectedFiles(@NotNull @NotNull VirtualFile @NotNull [] files) throws Exception {
                    VirtualFile file;
                    if (files == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((file = files[0]).isDirectory() && !"app".equals(file.getExtension())) {
                        throw new Exception(IdeCoreBundle.message("file.chooser.not.app.bundle", file.getPresentableUrl()));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/fileChooser/FileChooserDescriptorFactory$1", "validateSelectedFiles"));
                }
            };
        }
        return FileChooserDescriptorFactory.singleFile();
    }

    public static FileChooserDescriptor multiFiles() {
        return new FileChooserDescriptor(true, false, false, true);
    }

    public static FileChooserDescriptor multiDirs() {
        return new FileChooserDescriptor(false, true, false, true);
    }

    public static FileChooserDescriptor multiFilesOrDirs() {
        return new FileChooserDescriptor(true, true, false, true);
    }

    public static FileChooserDescriptor multiJarsOrDirs() {
        return new FileChooserDescriptor(false, true, true, true);
    }

    @ApiStatus.Obsolete
    public static FileChooserDescriptor createAllButJarContentsDescriptor() {
        return FileChooserDescriptorFactory.multiFilesOrDirs();
    }

    @ApiStatus.Obsolete
    public static FileChooserDescriptor createMultipleFilesNoJarsDescriptor() {
        return FileChooserDescriptorFactory.multiFiles();
    }

    @ApiStatus.Obsolete
    public static FileChooserDescriptor createMultipleFoldersDescriptor() {
        return FileChooserDescriptorFactory.multiDirs();
    }

    @ApiStatus.Obsolete
    public static FileChooserDescriptor createSingleFileNoJarsDescriptor() {
        return FileChooserDescriptorFactory.singleFile();
    }

    @ApiStatus.Obsolete
    public static FileChooserDescriptor createSingleFileOrExecutableAppDescriptor() {
        return FileChooserDescriptorFactory.singleFileOrAppBundle();
    }

    @Deprecated
    public static FileChooserDescriptor createSingleLocalFileDescriptor() {
        return new FileChooserDescriptor(true, true, false, false);
    }

    @Deprecated
    public static FileChooserDescriptor createSingleFileDescriptor() {
        return FileChooserDescriptorFactory.createSingleLocalFileDescriptor();
    }

    @ApiStatus.Obsolete
    public static FileChooserDescriptor createSingleFileDescriptor(@NotNull FileType fileType) {
        if (fileType == null) {
            FileChooserDescriptorFactory.$$$reportNull$$$0(0);
        }
        return FileChooserDescriptorFactory.singleFile().withExtensionFilter(fileType);
    }

    @ApiStatus.Obsolete
    public static FileChooserDescriptor createSingleFileOrFolderDescriptor(@NotNull FileType fileType) {
        if (fileType == null) {
            FileChooserDescriptorFactory.$$$reportNull$$$0(1);
        }
        return FileChooserDescriptorFactory.singleFileOrDir().withExtensionFilter(fileType);
    }

    @ApiStatus.Obsolete
    public static FileChooserDescriptor createSingleFileDescriptor(@NotNull String extension) {
        if (extension == null) {
            FileChooserDescriptorFactory.$$$reportNull$$$0(2);
        }
        return FileChooserDescriptorFactory.singleFile().withExtensionFilter(extension);
    }

    @ApiStatus.Obsolete
    public static FileChooserDescriptor createSingleFolderDescriptor() {
        return FileChooserDescriptorFactory.singleDir();
    }

    @ApiStatus.Obsolete
    public static FileChooserDescriptor createMultipleJavaPathDescriptor() {
        return FileChooserDescriptorFactory.multiJarsOrDirs();
    }

    @ApiStatus.Obsolete
    public static FileChooserDescriptor createSingleFileOrFolderDescriptor() {
        return FileChooserDescriptorFactory.singleFileOrDir();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/fileChooser/FileChooserDescriptorFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createSingleFileDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createSingleFileOrFolderDescriptor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

