/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.CompositeSettingsEditor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditorListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SettingsEditor<Settings>
implements Disposable {
    private final List<SettingsEditorListener<Settings>> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private UserActivityWatcher myWatcher;
    private boolean myIsInUpdate = false;
    private final Factory<? extends Settings> mySettingsFactory;
    private CompositeSettingsEditor<Settings> myOwner;
    private JComponent myEditorComponent;
    private final boolean myMaximizeEditorHeight;

    @ApiStatus.Internal
    public final boolean isMaximizeEditorHeight() {
        return this.myMaximizeEditorHeight;
    }

    protected abstract void resetEditorFrom(@NotNull Settings var1);

    protected abstract void applyEditorTo(@NotNull Settings var1) throws ConfigurationException;

    @NotNull
    protected abstract JComponent createEditor();

    @ApiStatus.Internal
    @NotNull
    public static JComponent createEditorComponent(@NotNull SettingsEditor<?> editor) {
        if (editor == null) {
            SettingsEditor.$$$reportNull$$$0(0);
        }
        JComponent jComponent = editor.createEditor();
        if (jComponent == null) {
            SettingsEditor.$$$reportNull$$$0(1);
        }
        return jComponent;
    }

    protected void disposeEditor() {
    }

    public SettingsEditor() {
        this(null);
    }

    public SettingsEditor(@Nullable Factory<? extends Settings> settingsFactory) {
        this(settingsFactory, false);
    }

    @ApiStatus.Internal
    protected SettingsEditor(@Nullable Factory<? extends Settings> settingsFactory, boolean maximizeEditorHeight) {
        this.mySettingsFactory = settingsFactory;
        this.myMaximizeEditorHeight = maximizeEditorHeight;
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                SettingsEditor.this.disposeEditor();
                SettingsEditor.this.uninstallWatcher();
            }
        });
    }

    @NotNull
    public Settings getSnapshot() throws ConfigurationException {
        if (this.myOwner != null) {
            Settings Settings = this.myOwner.getSnapshot();
            if (Settings == null) {
                SettingsEditor.$$$reportNull$$$0(2);
            }
            return Settings;
        }
        Object settings = this.mySettingsFactory.create();
        this.applyTo(settings);
        Object object = settings;
        if (object == null) {
            SettingsEditor.$$$reportNull$$$0(3);
        }
        return (Settings)object;
    }

    final void setOwner(CompositeSettingsEditor<Settings> owner) {
        this.myOwner = owner;
    }

    public final CompositeSettingsEditor<Settings> getOwner() {
        return this.myOwner;
    }

    public Factory<? extends Settings> getFactory() {
        return this.mySettingsFactory;
    }

    public final void resetFrom(Settings s) {
        this.bulkUpdate(() -> {
            if (this.myEditorComponent == null) {
                this.getComponent();
            }
            this.resetEditorFrom(s);
        });
    }

    public final void bulkUpdate(Runnable runnable) {
        boolean wasInUpdate = this.myIsInUpdate;
        try {
            this.myIsInUpdate = true;
            runnable.run();
        }
        finally {
            this.myIsInUpdate = wasInUpdate;
        }
        this.fireEditorStateChanged();
    }

    public final void applyTo(Settings s) throws ConfigurationException {
        this.applyEditorTo(s);
    }

    public final JComponent getComponent() {
        if (this.myEditorComponent == null) {
            this.myEditorComponent = this.createEditor();
            this.installWatcher(this.myEditorComponent);
        }
        return this.myEditorComponent;
    }

    public final void dispose() {
        this.myListeners.clear();
    }

    protected void uninstallWatcher() {
        this.myWatcher = null;
    }

    protected void installWatcher(JComponent c) {
        this.myWatcher = this.createWatcher();
        this.myWatcher.register(c);
        UserActivityListener userActivityListener = new UserActivityListener(){

            @Override
            public void stateChanged() {
                SettingsEditor.this.fireEditorStateChanged();
            }
        };
        this.myWatcher.addUserActivityListener(userActivityListener, this);
    }

    @NotNull
    protected UserActivityWatcher createWatcher() {
        return new UserActivityWatcher();
    }

    public final void addSettingsEditorListener(SettingsEditorListener<Settings> listener) {
        this.myListeners.add(listener);
    }

    public final void removeSettingsEditorListener(SettingsEditorListener<Settings> listener) {
        this.myListeners.remove(listener);
    }

    protected final void fireEditorStateChanged() {
        if (this.myIsInUpdate) {
            return;
        }
        for (SettingsEditorListener<Settings> listener : this.myListeners) {
            listener.stateChanged(this);
        }
    }

    public boolean isSpecificallyModified() {
        return false;
    }

    public boolean isReadyForApply() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/SettingsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/SettingsEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorComponent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSnapshot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createEditorComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

