/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.BaseProjectDirectoriesDiff;
import com.intellij.openapi.project.BaseProjectDirectoriesListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.Topic;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH$J\u0012\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000bH&J\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/project/BaseProjectDirectories;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "isProcessing", "", "()Z", "getBaseDirectories", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getBaseDirectoryFor", "virtualFile", "contains", "file", "fireChange", "", "diff", "Lcom/intellij/openapi/project/BaseProjectDirectoriesDiff;", "Companion", "intellij.platform.ide.core"})
public abstract class BaseProjectDirectories {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Topic.ProjectLevel
    @NotNull
    private static final Topic<BaseProjectDirectoriesListener> TOPIC = new Topic("Change of base project directories", BaseProjectDirectoriesListener.class, Topic.BroadcastDirection.NONE);

    public BaseProjectDirectories(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @TestOnly
    public abstract boolean isProcessing();

    @NotNull
    protected abstract Set<VirtualFile> getBaseDirectories();

    @Nullable
    public abstract VirtualFile getBaseDirectoryFor(@NotNull VirtualFile var1);

    public final boolean contains(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.getBaseDirectoryFor(file) != null;
    }

    @RequiresEdt
    protected final void fireChange(@NotNull BaseProjectDirectoriesDiff diff) {
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        ((BaseProjectDirectoriesListener)this.project.getMessageBus().syncPublisher(TOPIC)).changed(this.project, diff);
    }

    @JvmStatic
    @NotNull
    public static final Set<VirtualFile> getBaseDirectories(@NotNull Project $this$getBaseDirectories) {
        return Companion.getBaseDirectories($this$getBaseDirectories);
    }

    @JvmStatic
    @NotNull
    public static final BaseProjectDirectories getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0007R\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/project/BaseProjectDirectories$Companion;", "", "<init>", "()V", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/openapi/project/BaseProjectDirectoriesListener;", "getTOPIC", "()Lcom/intellij/util/messages/Topic;", "getBaseDirectories", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/project/Project;", "getInstance", "Lcom/intellij/openapi/project/BaseProjectDirectories;", "project", "intellij.platform.ide.core"})
    @SourceDebugExtension(value={"SMAP\nBaseProjectDirectories.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseProjectDirectories.kt\ncom/intellij/openapi/project/BaseProjectDirectories$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,62:1\n30#2,2:63\n*S KotlinDebug\n*F\n+ 1 BaseProjectDirectories.kt\ncom/intellij/openapi/project/BaseProjectDirectories$Companion\n*L\n29#1:63,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Topic<BaseProjectDirectoriesListener> getTOPIC() {
            return TOPIC;
        }

        @JvmStatic
        @NotNull
        public final Set<VirtualFile> getBaseDirectories(@NotNull Project $this$getBaseDirectories) {
            Intrinsics.checkNotNullParameter((Object)$this$getBaseDirectories, (String)"<this>");
            return this.getInstance($this$getBaseDirectories).getBaseDirectories();
        }

        @JvmStatic
        @NotNull
        public final BaseProjectDirectories getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<BaseProjectDirectories> serviceClass$iv = BaseProjectDirectories.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (BaseProjectDirectories)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

