/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.microservices.jvm.config.ConfigKeyPathContext;
import com.intellij.microservices.jvm.config.ConfigKeyPathReference;
import com.intellij.microservices.jvm.config.ConfigKeyPathUtils;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyManager;
import com.intellij.microservices.jvm.config.MetaConfigKeyReference;
import com.intellij.microservices.jvm.config.hints.HintReferenceProvider;
import com.intellij.microservices.jvm.config.yaml.ConfigYamlUtils;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.boot.application.config.SpringBootHintReferencesProvider;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLKeyValue;

class SpringBootApplicationYamlKeyReferenceProvider
extends PsiReferenceProvider {
    SpringBootApplicationYamlKeyReferenceProvider() {
    }

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        YAMLKeyValue yamlKeyValue;
        if (element == null) {
            SpringBootApplicationYamlKeyReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SpringBootApplicationYamlKeyReferenceProvider.$$$reportNull$$$0(1);
        }
        if ((yamlKeyValue = (YAMLKeyValue)element).getKey() == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringBootApplicationYamlKeyReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String qualifiedConfigKeyName = ConfigYamlUtils.getQualifiedConfigKeyName((YAMLKeyValue)yamlKeyValue);
        YamlKeyMetaConfigKeyReference metaConfigKeyReference = new YamlKeyMetaConfigKeyReference(yamlKeyValue, qualifiedConfigKeyName);
        SmartList references = new SmartList((Object)metaConfigKeyReference);
        MetaConfigKey key = metaConfigKeyReference.getResolvedKey();
        if (key == null) {
            PsiReference[] psiReferenceArray = references.toArray(PsiReference.EMPTY_ARRAY);
            if (psiReferenceArray == null) {
                SpringBootApplicationYamlKeyReferenceProvider.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }
        YAMLKeyValue parent = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)yamlKeyValue, YAMLKeyValue.class);
        references.addAll(SpringBootApplicationYamlKeyReferenceProvider.getReferences(yamlKeyValue, parent, key, context));
        if (references.size() > 1) {
            int start;
            int configKeyPathStart = ((PsiReference)references.get(1)).getRangeInElement().getStartOffset();
            if (configKeyPathStart == (start = metaConfigKeyReference.getRangeInElement().getStartOffset()) || yamlKeyValue.getKeyText().isEmpty() || yamlKeyValue.getKeyText().charAt(configKeyPathStart - 1) != '.') {
                metaConfigKeyReference.setRangeInElement(TextRange.EMPTY_RANGE);
            } else {
                TextRange textRange = TextRange.create((int)start, (int)(configKeyPathStart - 1));
                metaConfigKeyReference.setRangeInElement(ConfigYamlUtils.trimIndexedAccess((TextRange)textRange, (YAMLKeyValue)yamlKeyValue));
            }
        }
        PsiReference[] psiReferenceArray = references.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            SpringBootApplicationYamlKeyReferenceProvider.$$$reportNull$$$0(4);
        }
        return psiReferenceArray;
    }

    static List<PsiReference> getReferences(@NotNull YAMLKeyValue yamlKeyValue, @Nullable YAMLKeyValue parent, @NotNull MetaConfigKey configKey, @NotNull ProcessingContext processingContext) {
        List references;
        if (yamlKeyValue == null) {
            SpringBootApplicationYamlKeyReferenceProvider.$$$reportNull$$$0(5);
        }
        if (configKey == null) {
            SpringBootApplicationYamlKeyReferenceProvider.$$$reportNull$$$0(6);
        }
        if (processingContext == null) {
            SpringBootApplicationYamlKeyReferenceProvider.$$$reportNull$$$0(7);
        }
        if ((references = ConfigYamlUtils.getConfigPathReferences((YAMLKeyValue)yamlKeyValue, (YAMLKeyValue)parent, (MetaConfigKey)configKey)).isEmpty()) {
            return Collections.emptyList();
        }
        return ContainerUtil.flatMap((Iterable)references, reference -> {
            if (SpringBootApplicationYamlKeyReferenceProvider.canHaveKeyHint(reference)) {
                ConfigKeyPathContext context = reference.getContext();
                String prefix = ConfigYamlUtils.getMapKeyPrefix((ConfigKeyPathContext)context);
                if (context.isFirst() || StringUtil.isNotEmpty((String)prefix)) {
                    processingContext.put(HintReferenceProvider.HINT_REFERENCES_MAP_KEY_PREFIX, (Object)prefix);
                    Object[] hintReferences = SpringBootHintReferencesProvider.getInstance().getKeyReferences(configKey, (PsiElement)yamlKeyValue, reference.getRangeInElement(), processingContext);
                    if (hintReferences.length > 0) {
                        SmartList additionalReferences = new SmartList(hintReferences);
                        additionalReferences.add(reference);
                        return additionalReferences;
                    }
                }
            }
            return new SmartList(reference);
        });
    }

    private static boolean canHaveKeyHint(ConfigKeyPathReference reference) {
        ConfigKeyPathContext context = reference.getContext();
        if (context.isFirst()) {
            return true;
        }
        MetaConfigKey key = context.getKey();
        if (!key.isAccessType(MetaConfigKey.AccessType.MAP_GROUP)) {
            return false;
        }
        PsiType valueType = ConfigKeyPathUtils.getMapValueType((PsiType)ConfigKeyPathUtils.unwrapIndexed((PsiType)key.getType()));
        PsiClass valueClass = ConfigKeyPathUtils.getPsiClass((PsiType)ConfigKeyPathUtils.unwrapIndexed((PsiType)valueType));
        return valueClass != null && ConfigKeyPathUtils.stopResolvingProperty((PsiClass)valueClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlKeyReferenceProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yamlKeyValue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKey";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlKeyReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    private static final class YamlKeyMetaConfigKeyReference
    extends MetaConfigKeyReference<YAMLKeyValue> {
        private YamlKeyMetaConfigKeyReference(YAMLKeyValue yamlKeyValue, String keyText) {
            super((MetaConfigKeyManager)SpringBootApplicationMetaConfigKeyManager.getInstance(), (PsiElement)yamlKeyValue, keyText);
        }

        protected TextRange calculateDefaultRangeInElement() {
            TextRange defaultRange = ConfigYamlUtils.getKeyReferenceRange((YAMLKeyValue)((YAMLKeyValue)this.myElement));
            MetaConfigKey configKey = this.getResolvedKey();
            if (configKey != null && !configKey.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL})) {
                return this.trimIndexedAccess(defaultRange);
            }
            return defaultRange;
        }

        @NotNull
        public String getReferenceDisplayText() {
            String valueText = ConfigYamlUtils.getValuePresentationText((YAMLKeyValue)((YAMLKeyValue)this.getElement()));
            Object object = valueText.isEmpty() ? this.getKeyText() : this.getKeyText() + ": " + valueText;
            if (object == null) {
                YamlKeyMetaConfigKeyReference.$$$reportNull$$$0(0);
            }
            return object;
        }

        private TextRange trimIndexedAccess(TextRange textRange) {
            String valueText = ((YAMLKeyValue)this.myElement).getKeyText();
            if (StringUtil.startsWithChar((CharSequence)valueText, (char)'[')) {
                textRange = textRange.shiftRight(1).grown(-1);
                if (StringUtil.endsWithChar((CharSequence)valueText, (char)']')) {
                    textRange = textRange.grown(-1);
                }
                return textRange;
            }
            return ConfigYamlUtils.trimIndexedAccess((TextRange)textRange, (YAMLKeyValue)((YAMLKeyValue)this.myElement));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlKeyReferenceProvider$YamlKeyMetaConfigKeyReference", "getReferenceDisplayText"));
        }
    }
}

