/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.microservices.jvm.config.ConfigKeyParts;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a&\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\nH\u0000\u001a\"\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\"\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "isInsideApplicationYamlFile", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "getDeepestMatchingYamlMapping", "Lkotlin/Pair;", "Lorg/jetbrains/yaml/psi/YAMLMapping;", "", "root", "key", "generateMappingHierarchy", "value", "project", "Lcom/intellij/openapi/project/Project;", "generateKeyValueHierarchy", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "intellij.spring.boot.configYaml"})
@SourceDebugExtension(value={"SMAP\nspringBootApplicationYamlUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 springBootApplicationYamlUtil.kt\ncom/intellij/spring/boot/application/yaml/SpringBootApplicationYamlUtilKt\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,87:1\n18#2:88\n*S KotlinDebug\n*F\n+ 1 springBootApplicationYamlUtil.kt\ncom/intellij/spring/boot/application/yaml/SpringBootApplicationYamlUtilKt\n*L\n75#1:88\n*E\n"})
public final class SpringBootApplicationYamlUtilKt {
    @NotNull
    private static final Logger LOG;

    public static final boolean isInsideApplicationYamlFile(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return false;
        }
        PsiFile psiFile = containingFile.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        PsiFile originalFile = psiFile;
        return originalFile instanceof YAMLFile && SpringBootConfigurationFileService.getInstance().isApplicationConfigurationFile(originalFile);
    }

    @Nullable
    public static final Pair<YAMLMapping, String> getDeepestMatchingYamlMapping(@NotNull YAMLMapping root, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        char[] cArray = new char[]{'.'};
        List parts = StringsKt.split$default((CharSequence)key, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        Iterator partsIterator = CollectionsKt.withIndex(parts.iterator());
        YAMLMapping current = root;
        while (partsIterator.hasNext()) {
            YAMLMapping next;
            IndexedValue indexedValue = (IndexedValue)partsIterator.next();
            int idx = indexedValue.component1();
            String part = (String)indexedValue.component2();
            YAMLKeyValue yAMLKeyValue = current.getKeyValueByKey(part);
            YAMLValue yAMLValue = yAMLKeyValue != null ? yAMLKeyValue.getValue() : null;
            YAMLMapping yAMLMapping = next = yAMLValue instanceof YAMLMapping ? (YAMLMapping)yAMLValue : null;
            if (next == null) {
                return TuplesKt.to((Object)current, (Object)CollectionsKt.joinToString$default((Iterable)parts.subList(idx, parts.size()), (CharSequence)".", null, null, (int)0, null, null, (int)62, null));
            }
            current = next;
        }
        LOG.debug("Tried to add new key '" + key + "', but it appears already existing: '" + root.getText() + "'");
        return null;
    }

    @Nullable
    public static final YAMLMapping generateMappingHierarchy(@NotNull String key, @NotNull String value, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        char[] cArray = new char[]{'.'};
        List list = ConfigKeyParts.joinArbitraryKeyParts((List)StringsKt.split$default((CharSequence)key, (char[])cArray, (boolean)false, (int)0, (int)6, null));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"joinArbitraryKeyParts(...)");
        List parts = list;
        if (parts.isEmpty()) {
            return null;
        }
        YAMLElementGenerator generator = YAMLElementGenerator.getInstance((Project)project);
        List list2 = generator.createDummyYamlWithText(YAMLElementGenerator.createChainedKey((List)parts, (int)0) + " " + value).getDocuments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getDocuments(...)");
        YAMLValue $this$asSafely$iv = ((YAMLDocument)CollectionsKt.first((List)list2)).getTopLevelValue();
        boolean $i$f$asSafely = false;
        YAMLValue yAMLValue = $this$asSafely$iv;
        if (!(yAMLValue instanceof YAMLMapping)) {
            yAMLValue = null;
        }
        return (YAMLMapping)yAMLValue;
    }

    @Nullable
    public static final YAMLKeyValue generateKeyValueHierarchy(@NotNull String key, @NotNull String value, @NotNull Project project) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        YAMLMapping yAMLMapping = SpringBootApplicationYamlUtilKt.generateMappingHierarchy(key, value, project);
        return yAMLMapping != null && (collection = yAMLMapping.getKeyValues()) != null ? (YAMLKeyValue)CollectionsKt.firstOrNull((Iterable)collection) : null;
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.spring.boot.application.yaml");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

