/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerGlobalSearchScope
extends DelegatingGlobalSearchScope {
    private final Comparator<VirtualFile> myScopeComparator;
    private final GlobalSearchScope myFallbackAllScope;

    public DebuggerGlobalSearchScope(@NotNull GlobalSearchScope scope, @NotNull Project project) {
        if (scope == null) {
            DebuggerGlobalSearchScope.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DebuggerGlobalSearchScope.$$$reportNull$$$0(1);
        }
        super(project, scope);
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        this.myScopeComparator = Comparator.comparing(arg_0 -> ((ProjectFileIndex)projectFileIndex).isInSourceContent(arg_0)).thenComparing(arg_0 -> ((ProjectFileIndex)projectFileIndex).isInLibrarySource(arg_0)).thenComparing((x$0, x$1) -> super.compare(x$0, x$1));
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)project);
        this.myFallbackAllScope = !allScope.equals(scope) ? new DebuggerGlobalSearchScope(allScope, project) : null;
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            DebuggerGlobalSearchScope.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            DebuggerGlobalSearchScope.$$$reportNull$$$0(3);
        }
        return this.myScopeComparator.compare(file1, file2);
    }

    @Nullable
    public Module getModuleIfAny() {
        return this.myBaseScope instanceof ModuleWithDependenciesScope ? ((ModuleWithDependenciesScope)this.myBaseScope).getModule() : null;
    }

    @Nullable
    public GlobalSearchScope fallbackAllScope() {
        return this.myFallbackAllScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/DebuggerGlobalSearchScope";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "compare";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

